/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.UpgradeRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.IRegistryDelegate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import shadows.apotheosis.Apoth;
import shadows.apotheosis.Apotheosis;
import shadows.apotheosis.adventure.AdventureConfig;
import shadows.apotheosis.adventure.AdventureEvents;
import shadows.apotheosis.adventure.AdventureGeneration;
import shadows.apotheosis.adventure.affix.AffixManager;
import shadows.apotheosis.adventure.affix.reforging.ReforgingMenu;
import shadows.apotheosis.adventure.affix.reforging.ReforgingTableBlock;
import shadows.apotheosis.adventure.affix.reforging.ReforgingTableTile;
import shadows.apotheosis.adventure.affix.salvaging.SalvageItem;
import shadows.apotheosis.adventure.affix.salvaging.SalvagingMenu;
import shadows.apotheosis.adventure.affix.salvaging.SalvagingTableBlock;
import shadows.apotheosis.adventure.affix.socket.AddSocketsRecipe;
import shadows.apotheosis.adventure.affix.socket.ExpulsionRecipe;
import shadows.apotheosis.adventure.affix.socket.ExtractionRecipe;
import shadows.apotheosis.adventure.affix.socket.GemItem;
import shadows.apotheosis.adventure.affix.socket.GemManager;
import shadows.apotheosis.adventure.affix.socket.SocketingRecipe;
import shadows.apotheosis.adventure.boss.BossArmorManager;
import shadows.apotheosis.adventure.boss.BossDungeonFeature;
import shadows.apotheosis.adventure.boss.BossDungeonFeature2;
import shadows.apotheosis.adventure.boss.BossEvents;
import shadows.apotheosis.adventure.boss.BossItemManager;
import shadows.apotheosis.adventure.boss.BossSpawnerBlock;
import shadows.apotheosis.adventure.boss.BossSummonerItem;
import shadows.apotheosis.adventure.client.AdventureModuleClient;
import shadows.apotheosis.adventure.compat.AdventureTOPPlugin;
import shadows.apotheosis.adventure.compat.GatewaysCompat;
import shadows.apotheosis.adventure.loot.AffixConvertLootModifier;
import shadows.apotheosis.adventure.loot.AffixLootManager;
import shadows.apotheosis.adventure.loot.AffixLootModifier;
import shadows.apotheosis.adventure.loot.AffixLootPoolEntry;
import shadows.apotheosis.adventure.loot.GemLootModifier;
import shadows.apotheosis.adventure.loot.GemLootPoolEntry;
import shadows.apotheosis.adventure.loot.LootRarity;
import shadows.apotheosis.adventure.spawner.RandomSpawnerManager;
import shadows.apotheosis.adventure.spawner.RogueSpawnerFeature;
import shadows.apotheosis.ench.objects.GlowyBlockItem;
import shadows.apotheosis.util.NameHelper;
import shadows.placebo.block_entity.TickingBlockEntityType;
import shadows.placebo.config.Configuration;
import shadows.placebo.container.ContainerUtil;
import shadows.placebo.loot.LootSystem;

public class AdventureModule {
    public static final Logger LOGGER = LogManager.getLogger((String)"Apotheosis : Adventure");
    public static final BiMap<LootRarity, IRegistryDelegate<Item>> RARITY_MATERIALS = HashBiMap.create();
    public static boolean stages = ModList.get().isLoaded("gamestages");
    public static final boolean DEBUG = false;

    @SubscribeEvent
    public void preInit(Apotheosis.ApotheosisConstruction e) {
        ObfuscationReflectionHelper.setPrivateValue(RangedAttribute.class, (Object)((RangedAttribute)Attributes.f_22284_), (Object)40.0, (String)"f_22308_");
        ObfuscationReflectionHelper.setPrivateValue(RangedAttribute.class, (Object)((RangedAttribute)Attributes.f_22285_), (Object)30.0, (String)"f_22308_");
    }

    @SubscribeEvent
    public void init(FMLCommonSetupEvent e) {
        this.reload(null);
        MinecraftForge.EVENT_BUS.register((Object)new AdventureEvents());
        MinecraftForge.EVENT_BUS.register((Object)new BossEvents());
        MinecraftForge.EVENT_BUS.addListener(this::reload);
        AffixManager.INSTANCE.registerToBus();
        GemManager.INSTANCE.registerToBus();
        AffixLootManager.INSTANCE.registerToBus();
        BossArmorManager.INSTANCE.registerToBus();
        BossItemManager.INSTANCE.registerToBus();
        RandomSpawnerManager.INSTANCE.registerToBus();
        Apotheosis.HELPER.registerProvider(f -> {
            f.addRecipe((Recipe)new SocketingRecipe());
            f.addRecipe((Recipe)new ExpulsionRecipe());
            f.addRecipe((Recipe)new ExtractionRecipe());
            Item g = Apoth.Items.GEM_DUST;
            f.addShaped((Object)new ItemStack((ItemLike)Apoth.Items.VIAL_OF_EXPULSION, 2), 3, 3, new Object[]{g, Items.f_42542_, g, Items.f_42585_, Apotheosis.potionIngredient(Potions.f_43601_), Items.f_42585_, g, Items.f_42448_, g});
            f.addShaped((Object)new ItemStack((ItemLike)Apoth.Items.VIAL_OF_EXTRACTION, 2), 3, 3, new Object[]{g, Items.f_151049_, g, Items.f_42584_, Apotheosis.potionIngredient(Potions.f_43601_), Items.f_42584_, g, Items.f_42447_, g});
        });
        e.enqueueWork(() -> {
            if (ModList.get().isLoaded("gateways")) {
                GatewaysCompat.register();
            }
            if (ModList.get().isLoaded("theoneprobe")) {
                AdventureTOPPlugin.register();
            }
            LootSystem.defaultBlockTable((Block)Apoth.Blocks.REFORGING_TABLE);
            LootSystem.defaultBlockTable((Block)Apoth.Blocks.SALVAGING_TABLE);
            Registry.m_122965_((Registry)Registry.f_122875_, (ResourceLocation)new ResourceLocation("apotheosis", "random_affix_item"), (Object)AffixLootPoolEntry.TYPE);
            Registry.m_122965_((Registry)Registry.f_122875_, (ResourceLocation)new ResourceLocation("apotheosis", "random_gem"), (Object)GemLootPoolEntry.TYPE);
        });
    }

    @SubscribeEvent
    public void register(RegistryEvent.Register<Feature<?>> e) {
        e.getRegistry().register((IForgeRegistryEntry)((Feature)BossDungeonFeature.INSTANCE.setRegistryName("boss_dng")));
        e.getRegistry().register((IForgeRegistryEntry)((Feature)BossDungeonFeature2.INSTANCE.setRegistryName("boss_dng_2")));
        e.getRegistry().register((IForgeRegistryEntry)((Feature)RogueSpawnerFeature.INSTANCE.setRegistryName("rogue_spawner")));
        MinecraftForge.EVENT_BUS.register(AdventureGeneration.class);
    }

    @SubscribeEvent
    public void items(RegistryEvent.Register<Item> e) {
        e.getRegistry().register((IForgeRegistryEntry)((Item)new GemItem(new Item.Properties().m_41487_(1)).setRegistryName("gem")));
        e.getRegistry().register((IForgeRegistryEntry)((Item)new BossSummonerItem(new Item.Properties().m_41491_(Apotheosis.APOTH_GROUP)).setRegistryName("boss_summoner")));
        e.getRegistry().register((IForgeRegistryEntry)((Item)new Item(new Item.Properties().m_41491_(Apotheosis.APOTH_GROUP)).setRegistryName("gem_dust")));
        e.getRegistry().register((IForgeRegistryEntry)((Item)new Item(new Item.Properties().m_41491_(Apotheosis.APOTH_GROUP)).setRegistryName("vial_of_extraction")));
        e.getRegistry().register((IForgeRegistryEntry)((Item)new Item(new Item.Properties().m_41491_(Apotheosis.APOTH_GROUP)).setRegistryName("vial_of_expulsion")));
        for (LootRarity r : LootRarity.values()) {
            if (r == LootRarity.ANCIENT) continue;
            Item material = (Item)new SalvageItem(r, new Item.Properties().m_41491_(Apotheosis.APOTH_GROUP)).setRegistryName(r.id() + "_material");
            e.getRegistry().register((IForgeRegistryEntry)material);
            RARITY_MATERIALS.put((Object)r, (Object)material.delegate);
        }
        e.getRegistry().register((IForgeRegistryEntry)((Item)new BlockItem((Block)Apoth.Blocks.REFORGING_TABLE, new Item.Properties().m_41491_(Apotheosis.APOTH_GROUP)).setRegistryName("reforging_table")));
        e.getRegistry().register((IForgeRegistryEntry)((Item)new BlockItem((Block)Apoth.Blocks.SALVAGING_TABLE, new Item.Properties().m_41491_(Apotheosis.APOTH_GROUP)).setRegistryName("salvaging_table")));
        e.getRegistry().register((IForgeRegistryEntry)((Item)new Item(new Item.Properties().m_41491_(Apotheosis.APOTH_GROUP)).setRegistryName("sigil_of_socketing")));
        e.getRegistry().register((IForgeRegistryEntry)((Item)new GlowyBlockItem.GlowyItem(new Item.Properties().m_41491_(Apotheosis.APOTH_GROUP)).setRegistryName("superior_sigil_of_socketing")));
        e.getRegistry().register((IForgeRegistryEntry)((Item)new Item(new Item.Properties().m_41491_(Apotheosis.APOTH_GROUP)).setRegistryName("sigil_of_enhancement")));
        e.getRegistry().register((IForgeRegistryEntry)((Item)new GlowyBlockItem.GlowyItem(new Item.Properties().m_41491_(Apotheosis.APOTH_GROUP)).setRegistryName("superior_sigil_of_enhancement")));
    }

    @SubscribeEvent
    public void blocks(RegistryEvent.Register<Block> e) {
        e.getRegistry().register((IForgeRegistryEntry)((Block)new BossSpawnerBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60913_(-1.0f, 3600000.0f).m_60993_()).setRegistryName("boss_spawner")));
        e.getRegistry().register((IForgeRegistryEntry)((Block)new ReforgingTableBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60999_().m_60913_(5.0f, 1000.0f)).setRegistryName("reforging_table")));
        e.getRegistry().register((IForgeRegistryEntry)((Block)new SalvagingTableBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60918_(SoundType.f_56736_).m_60978_(2.5f)).setRegistryName("salvaging_table")));
    }

    @SubscribeEvent
    public void tiles(RegistryEvent.Register<BlockEntityType<?>> e) {
        e.getRegistry().register((IForgeRegistryEntry)((BlockEntityType)new TickingBlockEntityType(BossSpawnerBlock.BossSpawnerTile::new, (Set)ImmutableSet.of((Object)((Object)Apoth.Blocks.BOSS_SPAWNER)), false, true).setRegistryName("boss_spawner")));
        e.getRegistry().register((IForgeRegistryEntry)((BlockEntityType)new TickingBlockEntityType(ReforgingTableTile::new, (Set)ImmutableSet.of((Object)((Object)Apoth.Blocks.REFORGING_TABLE)), true, false).setRegistryName("reforging_table")));
    }

    @SubscribeEvent
    public void serializers(RegistryEvent.Register<RecipeSerializer<?>> e) {
        e.getRegistry().register((IForgeRegistryEntry)((RecipeSerializer)SocketingRecipe.Serializer.INSTANCE.setRegistryName("socketing")));
        e.getRegistry().register((IForgeRegistryEntry)((RecipeSerializer)ExpulsionRecipe.Serializer.INSTANCE.setRegistryName("expulsion")));
        e.getRegistry().register((IForgeRegistryEntry)((RecipeSerializer)ExtractionRecipe.Serializer.INSTANCE.setRegistryName("extraction")));
        e.getRegistry().register((IForgeRegistryEntry)((RecipeSerializer)AddSocketsRecipe.Serializer.INSTANCE.setRegistryName("add_sockets")));
    }

    @SubscribeEvent
    public void lootSerializers(RegistryEvent.Register<GlobalLootModifierSerializer<?>> e) {
        e.getRegistry().register((IForgeRegistryEntry)new GemLootModifier.Serializer().setRegistryName("gems"));
        e.getRegistry().register((IForgeRegistryEntry)new AffixLootModifier.Serializer().setRegistryName("affix_loot"));
        e.getRegistry().register((IForgeRegistryEntry)new AffixConvertLootModifier.Serializer().setRegistryName("affix_conversion"));
    }

    @SubscribeEvent
    public void containers(RegistryEvent.Register<MenuType<?>> e) {
        e.getRegistry().register((IForgeRegistryEntry)((MenuType)ContainerUtil.makeType(ReforgingMenu::new).setRegistryName("reforging")));
        e.getRegistry().register((IForgeRegistryEntry)((MenuType)new MenuType(SalvagingMenu::new).setRegistryName("salvage")));
    }

    @SubscribeEvent
    public void attribs(RegistryEvent.Register<Attribute> e) {
        e.getRegistry().registerAll((IForgeRegistryEntry[])new Attribute[]{(Attribute)new RangedAttribute("apotheosis:draw_speed", 1.0, 1.0, 4.0).m_22084_(true).setRegistryName("draw_speed"), (Attribute)new RangedAttribute("apotheosis:crit_chance", 1.0, 1.0, 1024.0).m_22084_(true).setRegistryName("crit_chance"), (Attribute)new RangedAttribute("apotheosis:crit_damage", 1.5, 1.0, 1024.0).m_22084_(true).setRegistryName("crit_damage"), (Attribute)new RangedAttribute("apotheosis:cold_damage", 0.0, 0.0, 1024.0).m_22084_(true).setRegistryName("cold_damage"), (Attribute)new RangedAttribute("apotheosis:fire_damage", 0.0, 0.0, 1024.0).m_22084_(true).setRegistryName("fire_damage"), (Attribute)new RangedAttribute("apotheosis:life_steal", 1.0, 1.0, 1024.0).m_22084_(true).setRegistryName("life_steal"), (Attribute)new RangedAttribute("apotheosis:piercing", 1.0, 1.0, 2.0).m_22084_(true).setRegistryName("piercing"), (Attribute)new RangedAttribute("apotheosis:current_hp_damage", 1.0, 1.0, 2.0).m_22084_(true).setRegistryName("current_hp_damage"), (Attribute)new RangedAttribute("apotheosis:overheal", 1.0, 0.0, 1024.0).m_22084_(true).setRegistryName("overheal"), (Attribute)new RangedAttribute("apotheosis:ghost_health", 0.0, 0.0, 1024.0).m_22084_(true).setRegistryName("ghost_health"), (Attribute)new RangedAttribute("apotheosis:mining_speed", 1.0, 0.0, 1024.0).m_22084_(true).setRegistryName("mining_speed"), (Attribute)new RangedAttribute("apotheosis:arrow_damage", 1.0, 0.0, 1024.0).m_22084_(true).setRegistryName("arrow_damage"), (Attribute)new RangedAttribute("apotheosis:arrow_velocity", 1.0, 0.0, 1024.0).m_22084_(true).setRegistryName("arrow_velocity")});
    }

    @SubscribeEvent
    public void applyAttribs(EntityAttributeModificationEvent e) {
        e.getTypes().forEach(type -> AdventureModule.addAll((EntityType<? extends LivingEntity>)type, (arg_0, arg_1) -> ((EntityAttributeModificationEvent)e).add(arg_0, arg_1), Apoth.Attributes.DRAW_SPEED, Apoth.Attributes.CRIT_CHANCE, Apoth.Attributes.CRIT_DAMAGE, Apoth.Attributes.COLD_DAMAGE, Apoth.Attributes.FIRE_DAMAGE, Apoth.Attributes.LIFE_STEAL, Apoth.Attributes.PIERCING, Apoth.Attributes.CURRENT_HP_DAMAGE, Apoth.Attributes.OVERHEAL, Apoth.Attributes.GHOST_HEALTH, Apoth.Attributes.MINING_SPEED, Apoth.Attributes.ARROW_DAMAGE, Apoth.Attributes.ARROW_VELOCITY));
    }

    private static void addAll(EntityType<? extends LivingEntity> type, BiConsumer<EntityType<? extends LivingEntity>, Attribute> add, Attribute ... attribs) {
        for (Attribute a : attribs) {
            add.accept(type, a);
        }
    }

    @SubscribeEvent
    public void client(FMLClientSetupEvent e) {
        e.enqueueWork(AdventureModuleClient::init);
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)new AdventureModuleClient());
    }

    public void reload(Apotheosis.ApotheosisReloadEvent e) {
        Configuration mainConfig = new Configuration(new File(Apotheosis.configDir, "adventure.cfg"));
        Configuration nameConfig = new Configuration(new File(Apotheosis.configDir, "names.cfg"));
        AdventureConfig.load(mainConfig);
        NameHelper.load(nameConfig);
        if (e == null && mainConfig.hasChanged()) {
            mainConfig.save();
        }
        if (e == null && nameConfig.hasChanged()) {
            nameConfig.save();
        }
    }

    public static void debugLog(BlockPos pos, String name) {
    }

    public static class ApothUpgradeRecipe
    extends UpgradeRecipe {
        public ApothUpgradeRecipe(ResourceLocation pId, Ingredient pBase, Ingredient pAddition, ItemStack pResult) {
            super(pId, pBase, pAddition, pResult);
        }
    }
}

