/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util.raytracer;

import net.minecraft.client.Minecraft;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeMod;

public class RayTracer {
    public static BlockHitResult retrace(Player player) {
        return RayTracer.retrace(player, RayTracer.getBlockReachDistance(player), ClipContext.Fluid.ANY);
    }

    public static BlockHitResult retrace(Player player, double reach) {
        return RayTracer.retrace(player, reach, ClipContext.Fluid.ANY);
    }

    public static BlockHitResult retrace(Player player, ClipContext.Fluid fluidMode) {
        return RayTracer.retrace(player, ClipContext.Block.COLLIDER, fluidMode);
    }

    public static BlockHitResult retrace(Player player, double reach, ClipContext.Fluid fluidMode) {
        return RayTracer.retrace(player, reach, ClipContext.Block.COLLIDER, fluidMode);
    }

    public static BlockHitResult retrace(Player player, ClipContext.Block blockMode, ClipContext.Fluid fluidMode) {
        return player.f_19853_.m_45547_(new ClipContext(RayTracer.getStartVec(player), RayTracer.getEndVec(player), blockMode, fluidMode, (Entity)player));
    }

    public static BlockHitResult retrace(Player player, double reach, ClipContext.Block blockMode, ClipContext.Fluid fluidMode) {
        return player.f_19853_.m_45547_(new ClipContext(RayTracer.getStartVec(player), RayTracer.getEndVec(player, reach), blockMode, fluidMode, (Entity)player));
    }

    public static Vec3 getStartVec(Player player) {
        return RayTracer.getCorrectedHeadVec(player);
    }

    public static Vec3 getEndVec(Player player) {
        Vec3 headVec = RayTracer.getCorrectedHeadVec(player);
        Vec3 lookVec = player.m_20252_(1.0f);
        double reach = RayTracer.getBlockReachDistance(player);
        return headVec.m_82520_(lookVec.f_82479_ * reach, lookVec.f_82480_ * reach, lookVec.f_82481_ * reach);
    }

    public static Vec3 getEndVec(Player player, double reach) {
        Vec3 headVec = RayTracer.getCorrectedHeadVec(player);
        Vec3 lookVec = player.m_20252_(1.0f);
        return headVec.m_82520_(lookVec.f_82479_ * reach, lookVec.f_82480_ * reach, lookVec.f_82481_ * reach);
    }

    public static Vec3 getCorrectedHeadVec(Player player) {
        return new Vec3(player.m_20185_(), player.m_20186_() + (double)player.m_20192_(), player.m_20189_());
    }

    public static double getBlockReachDistance(Player player) {
        double d;
        if (player.f_19853_.f_46443_) {
            d = RayTracer.getBlockReachDistanceClient();
        } else if (player instanceof ServerPlayer) {
            ServerPlayer serverplayer = (ServerPlayer)player;
            d = RayTracer.getBlockReachDistanceServer(serverplayer);
        } else {
            d = 5.0;
        }
        return d;
    }

    private static double getBlockReachDistanceServer(ServerPlayer player) {
        return player.m_21051_((Attribute)ForgeMod.REACH_DISTANCE.get()).m_22135_();
    }

    @OnlyIn(value=Dist.CLIENT)
    private static double getBlockReachDistanceClient() {
        return Minecraft.m_91087_().f_91072_.m_105286_();
    }
}

