/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.client.model;

import cofh.core.util.helpers.FluidHelper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Quaternion;
import com.mojang.math.Transformation;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.CompositeModelState;
import net.minecraftforge.client.model.ForgeModelBakery;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.ItemMultiLayerBakedModel;
import net.minecraftforge.client.model.ItemTextureQuadConverter;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public final class DynamicFluidContainerModel
implements IModelGeometry<DynamicFluidContainerModel> {
    private static final float NORTH_Z_COVER = 0.4685f;
    private static final float SOUTH_Z_COVER = 0.5315f;
    private static final float NORTH_Z_FLUID = 0.468625f;
    private static final float SOUTH_Z_FLUID = 0.531375f;
    @Nonnull
    private final FluidStack fluidStack;
    private final boolean flipGas;
    private final boolean tint;
    private final boolean coverIsMask;
    private final boolean applyFluidLuminosity;

    public DynamicFluidContainerModel(FluidStack fluidStack, boolean flipGas, boolean tint, boolean coverIsMask, boolean applyFluidLuminosity) {
        this.fluidStack = fluidStack;
        this.flipGas = flipGas;
        this.tint = tint;
        this.coverIsMask = coverIsMask;
        this.applyFluidLuminosity = applyFluidLuminosity;
    }

    public DynamicFluidContainerModel withFluid(FluidStack newFluid) {
        return new DynamicFluidContainerModel(newFluid, this.flipGas, this.tint, this.coverIsMask, this.applyFluidLuminosity);
    }

    public BakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides overrides, ResourceLocation modelLocation) {
        TextureAtlasSprite templateSprite;
        TextureAtlasSprite particleSprite;
        Material particleLocation = owner.isTexturePresent("particle") ? owner.resolveTexture("particle") : null;
        Material baseLocation = owner.isTexturePresent("base") ? owner.resolveTexture("base") : null;
        Material fluidMaskLocation = owner.isTexturePresent("fluid_mask") ? owner.resolveTexture("fluid_mask") : null;
        Material coverLocation = owner.isTexturePresent("cover") ? owner.resolveTexture("cover") : null;
        ModelState transformsFromModel = owner.getCombinedTransform();
        Fluid fluid = this.fluidStack.getFluid();
        TextureAtlasSprite fluidSprite = fluid != Fluids.f_76191_ ? spriteGetter.apply(ForgeHooksClient.getBlockMaterial((ResourceLocation)fluid.getAttributes().getStillTexture())) : null;
        TextureAtlasSprite coverSprite = coverLocation != null && (!this.coverIsMask || baseLocation != null) ? spriteGetter.apply(coverLocation) : null;
        ImmutableMap transformMap = PerspectiveMapWrapper.getTransforms((ModelState)new CompositeModelState(transformsFromModel, modelTransform));
        TextureAtlasSprite textureAtlasSprite = particleSprite = particleLocation != null ? spriteGetter.apply(particleLocation) : null;
        if (particleSprite == null) {
            particleSprite = fluidSprite;
        }
        if (particleSprite == null && !this.coverIsMask) {
            particleSprite = coverSprite;
        }
        if (this.flipGas && fluid != Fluids.f_76191_ && fluid.getAttributes().isLighterThanAir()) {
            modelTransform = new SimpleModelState(modelTransform.m_6189_().blockCornerToCenter().m_121096_(new Transformation(null, new Quaternion(0.0f, 0.0f, 1.0f, 0.0f), null, null)).blockCenterToCorner());
        }
        Transformation transform = modelTransform.m_6189_();
        ItemMultiLayerBakedModel.Builder builder = ItemMultiLayerBakedModel.builder((IModelConfiguration)owner, (TextureAtlasSprite)particleSprite, (ItemOverrides)new ContainedFluidOverrideHandler(overrides, bakery, owner, this), (ImmutableMap)transformMap);
        if (baseLocation != null) {
            builder.addQuads(ItemLayerModel.getLayerRenderType((boolean)false), (Collection)ItemLayerModel.getQuadsForSprites((List)ImmutableList.of((Object)baseLocation), (Transformation)transform, spriteGetter));
        }
        if (fluidMaskLocation != null && fluidSprite != null && (templateSprite = spriteGetter.apply(fluidMaskLocation)) != null) {
            int luminosity = this.applyFluidLuminosity ? fluid.getAttributes().getLuminosity(this.fluidStack) : 0;
            int color = this.tint ? fluid.getAttributes().getColor(this.fluidStack) : -1;
            builder.addQuads(ItemLayerModel.getLayerRenderType((luminosity > 0 ? 1 : 0) != 0), (Collection)ItemTextureQuadConverter.convertTexture((Transformation)transform, (TextureAtlasSprite)templateSprite, (TextureAtlasSprite)fluidSprite, (float)0.468625f, (Direction)Direction.NORTH, (int)color, (int)1, (int)luminosity));
            builder.addQuads(ItemLayerModel.getLayerRenderType((luminosity > 0 ? 1 : 0) != 0), (Collection)ItemTextureQuadConverter.convertTexture((Transformation)transform, (TextureAtlasSprite)templateSprite, (TextureAtlasSprite)fluidSprite, (float)0.531375f, (Direction)Direction.SOUTH, (int)color, (int)1, (int)luminosity));
        }
        if (this.coverIsMask) {
            if (coverSprite != null && baseLocation != null) {
                TextureAtlasSprite baseSprite = spriteGetter.apply(baseLocation);
                builder.addQuads(ItemLayerModel.getLayerRenderType((boolean)false), (Collection)ItemTextureQuadConverter.convertTexture((Transformation)transform, (TextureAtlasSprite)coverSprite, (TextureAtlasSprite)baseSprite, (float)0.4685f, (Direction)Direction.NORTH, (int)-1, (int)2));
                builder.addQuads(ItemLayerModel.getLayerRenderType((boolean)false), (Collection)ItemTextureQuadConverter.convertTexture((Transformation)transform, (TextureAtlasSprite)coverSprite, (TextureAtlasSprite)baseSprite, (float)0.5315f, (Direction)Direction.SOUTH, (int)-1, (int)2));
            }
        } else if (coverSprite != null) {
            builder.addQuads(ItemLayerModel.getLayerRenderType((boolean)false), new BakedQuad[]{ItemTextureQuadConverter.genQuad((Transformation)transform, (float)0.0f, (float)0.0f, (float)16.0f, (float)16.0f, (float)0.4685f, (TextureAtlasSprite)coverSprite, (Direction)Direction.NORTH, (int)-1, (int)2)});
            builder.addQuads(ItemLayerModel.getLayerRenderType((boolean)false), new BakedQuad[]{ItemTextureQuadConverter.genQuad((Transformation)transform, (float)0.0f, (float)0.0f, (float)16.0f, (float)16.0f, (float)0.5315f, (TextureAtlasSprite)coverSprite, (Direction)Direction.SOUTH, (int)-1, (int)2)});
        }
        builder.setParticle(particleSprite);
        return builder.build();
    }

    public Collection<Material> getTextures(IModelConfiguration owner, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        HashSet texs = Sets.newHashSet();
        if (owner.isTexturePresent("particle")) {
            texs.add(owner.resolveTexture("particle"));
        }
        if (owner.isTexturePresent("base")) {
            texs.add(owner.resolveTexture("base"));
        }
        if (owner.isTexturePresent("fluid_mask")) {
            texs.add(owner.resolveTexture("fluid_mask"));
        }
        if (owner.isTexturePresent("cover")) {
            texs.add(owner.resolveTexture("cover"));
        }
        return texs;
    }

    private static final class ContainedFluidOverrideHandler
    extends ItemOverrides {
        private final Int2ObjectMap<BakedModel> cache = new Int2ObjectOpenHashMap();
        private final ItemOverrides nested;
        private final ModelBakery bakery;
        private final IModelConfiguration owner;
        private final DynamicFluidContainerModel parent;

        private ContainedFluidOverrideHandler(ItemOverrides nested, ModelBakery bakery, IModelConfiguration owner, DynamicFluidContainerModel parent) {
            this.nested = nested;
            this.bakery = bakery;
            this.owner = owner;
            this.parent = parent;
        }

        public BakedModel m_173464_(BakedModel originalModel, ItemStack stack, @Nullable ClientLevel world, @Nullable LivingEntity entity, int seed) {
            BakedModel overrideModel = this.nested.m_173464_(originalModel, stack, world, entity, seed);
            if (overrideModel != originalModel) {
                return overrideModel;
            }
            return FluidHelper.getFluidContainedInItem(stack).map(fluidStack -> {
                int fluidHash = FluidHelper.fluidHashcode(fluidStack);
                if (!this.cache.containsKey(fluidHash)) {
                    DynamicFluidContainerModel unbaked = this.parent.withFluid((FluidStack)fluidStack);
                    BakedModel bakedModel = unbaked.bake(this.owner, this.bakery, ForgeModelBakery.defaultTextureGetter(), (ModelState)BlockModelRotation.X0_Y0, this, new ResourceLocation("cofh_core", "fluid_container_override"));
                    this.cache.put(fluidHash, (Object)bakedModel);
                    return bakedModel;
                }
                return (BakedModel)this.cache.get(fluidHash);
            }).orElse(originalModel);
        }
    }

    public static class Loader
    implements IModelLoader<DynamicFluidContainerModel> {
        public void m_6213_(ResourceManager resourceManager) {
        }

        public DynamicFluidContainerModel read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
            ResourceLocation fluidName;
            Fluid fluid;
            FluidStack stack = FluidStack.EMPTY;
            if (modelContents.has("fluid") && (fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(fluidName = new ResourceLocation(modelContents.get("fluid").getAsString()))) != null) {
                stack = new FluidStack(fluid, 1000);
            }
            boolean flip = false;
            if (modelContents.has("flipGas")) {
                flip = modelContents.get("flipGas").getAsBoolean();
            }
            boolean tint = true;
            if (modelContents.has("applyTint")) {
                tint = modelContents.get("applyTint").getAsBoolean();
            }
            boolean coverIsMask = true;
            if (modelContents.has("coverIsMask")) {
                coverIsMask = modelContents.get("coverIsMask").getAsBoolean();
            }
            boolean applyFluidLuminosity = true;
            if (modelContents.has("applyFluidLuminosity")) {
                applyFluidLuminosity = modelContents.get("applyFluidLuminosity").getAsBoolean();
            }
            return new DynamicFluidContainerModel(stack, flip, tint, coverIsMask, applyFluidLuminosity);
        }
    }
}

