/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util.filter;

import cofh.core.util.filter.EmptyFilter;
import cofh.core.util.filter.FluidFilter;
import cofh.core.util.filter.IFilter;
import cofh.core.util.filter.IFilterFactory;
import cofh.core.util.filter.IFilterableTile;
import cofh.core.util.filter.ItemFilter;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;

public class FilterRegistry {
    public static final String FLUID_FILTER_TYPE = "fluid";
    public static final String ITEM_FILTER_TYPE = "item";
    protected static final Map<String, IFilterFactory<? extends IFilter>> FILTER_FACTORY_MAP = new Object2ObjectOpenHashMap();

    public static boolean registerFilterFactory(String type, IFilterFactory<?> factory) {
        if (type == null || type.isEmpty() || factory == null) {
            return false;
        }
        FILTER_FACTORY_MAP.put(type, factory);
        return true;
    }

    public static IFilter getHeldFilter(String type, CompoundTag nbt) {
        if (FILTER_FACTORY_MAP.containsKey(type)) {
            return FILTER_FACTORY_MAP.get(type).createFilter(nbt, true, BlockPos.f_121853_);
        }
        return EmptyFilter.INSTANCE;
    }

    public static IFilter getTileFilter(String type, CompoundTag nbt, IFilterableTile tile) {
        if (FILTER_FACTORY_MAP.containsKey(type)) {
            return FILTER_FACTORY_MAP.get(type).createFilter(nbt, false, tile.pos());
        }
        return EmptyFilter.INSTANCE;
    }

    static {
        FilterRegistry.registerFilterFactory(FLUID_FILTER_TYPE, FluidFilter.FACTORY);
        FilterRegistry.registerFilterFactory(ITEM_FILTER_TYPE, ItemFilter.FACTORY);
    }
}

