/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.model;

import appeng.client.render.DelegateBakedModel;
import appeng.client.render.model.DriveModelData;
import appeng.client.render.model.MatrixVertexTransformer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.pipeline.BakedQuadBuilder;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;

public class DriveBakedModel
extends DelegateBakedModel {
    private final Map<Item, BakedModel> bakedCells;
    private final BakedModel defaultCell;

    public DriveBakedModel(BakedModel bakedBase, Map<Item, BakedModel> cellModels, BakedModel defaultCell) {
        super(bakedBase);
        this.bakedCells = cellModels;
        this.defaultCell = defaultCell;
    }

    public static void getSlotOrigin(int row, int col, Vector3f translation) {
        float xOffset = (float)(9 - col * 8) / 16.0f;
        float yOffset = (float)(13 - row * 3) / 16.0f;
        float zOffset = 0.0625f;
        translation.m_122245_(xOffset, yOffset, zOffset);
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, Random rand, IModelData extraData) {
        ArrayList<BakedQuad> result = new ArrayList<BakedQuad>(super.getQuads(state, side, rand, extraData));
        if (!extraData.hasProperty(DriveModelData.STATE)) {
            return result;
        }
        Item[] cells = (Item[])extraData.getData(DriveModelData.STATE);
        Vector3f slotTranslation = new Vector3f();
        if (cells != null) {
            for (int row = 0; row < 5; ++row) {
                for (int col = 0; col < 2; ++col) {
                    Matrix4f transform = new Matrix4f();
                    DriveBakedModel.getSlotOrigin(row, col, slotTranslation);
                    transform.setTranslation(slotTranslation.m_122239_(), slotTranslation.m_122260_(), slotTranslation.m_122269_());
                    int slot = row * 2 + col;
                    Item cell = slot < cells.length ? cells[slot] : null;
                    BakedModel cellChassisModel = this.getCellChassisModel(cell);
                    DriveBakedModel.addModel(state, rand, extraData, result, side, cellChassisModel, transform);
                }
            }
        }
        return result;
    }

    @Override
    public boolean m_7541_() {
        return false;
    }

    public BakedModel getCellChassisModel(Item cell) {
        if (cell == null) {
            return this.bakedCells.get(Items.f_41852_);
        }
        BakedModel model = this.bakedCells.get(cell);
        return model != null ? model : this.defaultCell;
    }

    private static void addModel(@Nullable BlockState state, Random rand, IModelData extraData, List<BakedQuad> result, Direction side, BakedModel bakedCell, Matrix4f transform) {
        MatrixVertexTransformer transformer = new MatrixVertexTransformer(transform);
        for (BakedQuad bakedQuad : bakedCell.getQuads(state, side, rand, extraData)) {
            BakedQuadBuilder builder = new BakedQuadBuilder();
            transformer.setParent((IVertexConsumer)builder);
            transformer.setVertexFormat(builder.getVertexFormat());
            bakedQuad.pipe((IVertexConsumer)transformer);
            result.add(builder.build());
        }
    }
}

