/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.cablebus;

import appeng.api.parts.PartModelsInternal;
import appeng.api.util.AEColor;
import appeng.client.render.BasicUnbakedModel;
import appeng.client.render.cablebus.CableBuilder;
import appeng.client.render.cablebus.CableBusBakedModel;
import appeng.client.render.cablebus.CableCoreType;
import appeng.client.render.cablebus.FacadeBuilder;
import appeng.core.AELog;
import appeng.core.AppEng;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.model.IModelConfiguration;

public class CableBusModel
implements BasicUnbakedModel<CableBusModel> {
    public static final ResourceLocation TRANSLUCENT_FACADE_MODEL = AppEng.makeId("part/translucent_facade");

    @Override
    public Collection<ResourceLocation> getModelDependencies() {
        PartModelsInternal.freeze();
        ArrayList<ResourceLocation> models = new ArrayList<ResourceLocation>(PartModelsInternal.getModels());
        models.add(TRANSLUCENT_FACADE_MODEL);
        return models;
    }

    @Override
    public Stream<Material> getAdditionalTextures() {
        return CableBuilder.getTextures().stream();
    }

    public BakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides overrides, ResourceLocation modelLocation) {
        Map<ResourceLocation, BakedModel> partModels = this.loadPartModels(bakery, spriteGetter, modelTransform);
        CableBuilder cableBuilder = new CableBuilder(spriteGetter);
        BakedModel translucentFacadeModel = bakery.bake(TRANSLUCENT_FACADE_MODEL, modelTransform, spriteGetter);
        FacadeBuilder facadeBuilder = new FacadeBuilder(translucentFacadeModel);
        TextureAtlasSprite particleTexture = cableBuilder.getCoreTexture(CableCoreType.GLASS, AEColor.TRANSPARENT);
        return new CableBusBakedModel(cableBuilder, facadeBuilder, partModels, particleTexture);
    }

    private Map<ResourceLocation, BakedModel> loadPartModels(ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetterIn, ModelState transformIn) {
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (ResourceLocation location : PartModelsInternal.getModels()) {
            BakedModel bakedModel = bakery.bake(location, transformIn, spriteGetterIn);
            if (bakedModel == null) {
                AELog.warn("Failed to bake part model {}", location);
                continue;
            }
            result.put((Object)location, (Object)bakedModel);
        }
        return result.build();
    }
}

