/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import java.util.Locale;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.StringRepresentable;

public enum FacingToRotation implements StringRepresentable
{
    DOWN_DOWN(new Vector3f(0.0f, 0.0f, 0.0f)),
    DOWN_UP(new Vector3f(0.0f, 0.0f, 0.0f)),
    DOWN_NORTH(new Vector3f(-90.0f, 0.0f, 0.0f)),
    DOWN_SOUTH(new Vector3f(-90.0f, 0.0f, 180.0f)),
    DOWN_WEST(new Vector3f(-90.0f, 0.0f, 90.0f)),
    DOWN_EAST(new Vector3f(-90.0f, 0.0f, -90.0f)),
    UP_DOWN(new Vector3f(0.0f, 0.0f, 0.0f)),
    UP_UP(new Vector3f(0.0f, 0.0f, 0.0f)),
    UP_NORTH(new Vector3f(90.0f, 0.0f, 180.0f)),
    UP_SOUTH(new Vector3f(90.0f, 0.0f, 0.0f)),
    UP_WEST(new Vector3f(90.0f, 0.0f, 90.0f)),
    UP_EAST(new Vector3f(90.0f, 0.0f, -90.0f)),
    NORTH_DOWN(new Vector3f(0.0f, 0.0f, 180.0f)),
    NORTH_UP(new Vector3f(0.0f, 0.0f, 0.0f)),
    NORTH_NORTH(new Vector3f(0.0f, 0.0f, 0.0f)),
    NORTH_SOUTH(new Vector3f(0.0f, 0.0f, 0.0f)),
    NORTH_WEST(new Vector3f(0.0f, 0.0f, 90.0f)),
    NORTH_EAST(new Vector3f(0.0f, 0.0f, -90.0f)),
    SOUTH_DOWN(new Vector3f(0.0f, 180.0f, 180.0f)),
    SOUTH_UP(new Vector3f(0.0f, 180.0f, 0.0f)),
    SOUTH_NORTH(new Vector3f(0.0f, 0.0f, 0.0f)),
    SOUTH_SOUTH(new Vector3f(0.0f, 0.0f, 0.0f)),
    SOUTH_WEST(new Vector3f(0.0f, 180.0f, -90.0f)),
    SOUTH_EAST(new Vector3f(0.0f, 180.0f, 90.0f)),
    WEST_DOWN(new Vector3f(0.0f, 90.0f, 180.0f)),
    WEST_UP(new Vector3f(0.0f, 90.0f, 0.0f)),
    WEST_NORTH(new Vector3f(0.0f, 90.0f, -90.0f)),
    WEST_SOUTH(new Vector3f(0.0f, 90.0f, 90.0f)),
    WEST_WEST(new Vector3f(0.0f, 0.0f, 0.0f)),
    WEST_EAST(new Vector3f(0.0f, 0.0f, 0.0f)),
    EAST_DOWN(new Vector3f(0.0f, -90.0f, 180.0f)),
    EAST_UP(new Vector3f(0.0f, -90.0f, 0.0f)),
    EAST_NORTH(new Vector3f(0.0f, -90.0f, 90.0f)),
    EAST_SOUTH(new Vector3f(0.0f, -90.0f, -90.0f)),
    EAST_WEST(new Vector3f(0.0f, 0.0f, 0.0f)),
    EAST_EAST(new Vector3f(0.0f, 0.0f, 0.0f));

    private final Vector3f rot;
    private final Quaternion xRot;
    private final Quaternion yRot;
    private final Quaternion zRot;
    private final Quaternion combinedRotation;
    private final Matrix4f mat;

    private FacingToRotation(Vector3f rot) {
        this.rot = rot;
        this.mat = new Matrix4f();
        this.mat.m_27624_();
        this.xRot = Vector3f.f_122223_.m_122240_(rot.m_122239_());
        this.mat.m_27646_(this.xRot);
        this.yRot = Vector3f.f_122225_.m_122240_(rot.m_122260_());
        this.mat.m_27646_(this.yRot);
        this.zRot = Vector3f.f_122227_.m_122240_(rot.m_122269_());
        this.mat.m_27646_(this.zRot);
        this.combinedRotation = new Quaternion(rot.m_122239_(), rot.m_122260_(), rot.m_122269_(), true);
    }

    public boolean isRedundant() {
        return this.rot.m_122239_() == 0.0f && this.rot.m_122260_() == 0.0f && this.rot.m_122269_() == 0.0f;
    }

    public Quaternion getRot() {
        return this.combinedRotation;
    }

    public Matrix4f getMat() {
        return new Matrix4f(this.mat);
    }

    public void push(PoseStack mStack) {
        mStack.m_85845_(this.xRot);
        mStack.m_85845_(this.yRot);
        mStack.m_85845_(this.zRot);
    }

    public Direction rotate(Direction facing) {
        Vec3i dir = facing.m_122436_();
        Vector4f vec = new Vector4f((float)dir.m_123341_(), (float)dir.m_123342_(), (float)dir.m_123343_(), 1.0f);
        vec.m_123607_(this.mat);
        return Direction.m_122372_((float)vec.m_123601_(), (float)vec.m_123615_(), (float)vec.m_123616_());
    }

    public Direction resultingRotate(Direction facing) {
        for (Direction face : Direction.values()) {
            if (this.rotate(face) != facing) continue;
            return face;
        }
        return null;
    }

    public static FacingToRotation get(Direction forward, Direction up) {
        return FacingToRotation.values()[forward.ordinal() * 6 + up.ordinal()];
    }

    public String m_7912_() {
        return this.name().toLowerCase(Locale.ROOT);
    }
}

