/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.util;

import codechicken.multipart.api.part.MultiPart;
import codechicken.multipart.api.part.RandomTickPart;
import codechicken.multipart.block.TileMultipart;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.covers1624.quack.collection.FastStream;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import org.jetbrains.annotations.Nullable;

class WorldTickScheduler {
    private static final Capability<WorldTickScheduler> WORLD_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<WorldTickScheduler>(){});
    private static final Capability<ChunkScheduler> CHUNK_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<ChunkScheduler>(){});
    static final ChunkStorage CHUNK_STORAGE = new ChunkStorage();
    private final ServerLevel world;
    private final Map<ChunkPos, ChunkScheduler> tickingChunks = new HashMap<ChunkPos, ChunkScheduler>();

    public static WorldTickScheduler getInstance(ServerLevel level) {
        return (WorldTickScheduler)level.getCapability(WORLD_CAPABILITY, null).orElseThrow(() -> new RuntimeException("Should never happen..."));
    }

    public static ChunkScheduler getInstance(LevelChunk chunk) {
        return (ChunkScheduler)chunk.getCapability(CHUNK_CAPABILITY).orElseThrow(() -> new RuntimeException("Should never happen..."));
    }

    WorldTickScheduler(ServerLevel world) {
        this.world = world;
    }

    public void onChunkUnload(ChunkPos pos) {
        this.tickingChunks.remove(pos);
    }

    public void tick() {
        if (!this.tickingChunks.isEmpty()) {
            this.tickingChunks.values().removeIf(ChunkScheduler::tick);
        }
    }

    static class ChunkScheduler {
        private final WorldTickScheduler worldScheduler;
        private final LevelChunk chunk;
        private final List<SavedTickEntry> savedTicks = new ArrayList<SavedTickEntry>();
        private final List<PartTickEntry> scheduledTicks = new LinkedList<PartTickEntry>();
        private final List<PartTickEntry> randomTicks = new LinkedList<PartTickEntry>();
        private boolean ticking = false;
        private final List<PartTickEntry> pendingScheduled = new LinkedList<PartTickEntry>();
        private final List<PartTickEntry> pendingRandom = new LinkedList<PartTickEntry>();

        ChunkScheduler(WorldTickScheduler worldScheduler, LevelChunk chunk) {
            this.worldScheduler = worldScheduler;
            this.chunk = chunk;
        }

        public void addScheduledTick(MultiPart part, int time) {
            PartTickEntry entry = new PartTickEntry(part, this.worldScheduler.world.m_46467_() + (long)time, false);
            if (this.ticking) {
                this.pendingScheduled.add(entry);
            } else {
                this.scheduledTicks.add(entry);
                this.onAdd();
            }
        }

        public void loadRandomTick(MultiPart part) {
            this.addRandomTick(part, this.worldScheduler.world.m_46467_() + (long)this.nextRandomTick());
        }

        public void addRandomTick(MultiPart part, long time) {
            PartTickEntry entry = new PartTickEntry(part, time, true);
            if (this.ticking) {
                this.pendingRandom.add(entry);
            } else {
                this.randomTicks.add(entry);
                this.onAdd();
            }
        }

        private void onAdd() {
            if (!this.scheduledTicks.isEmpty() || !this.randomTicks.isEmpty()) {
                this.worldScheduler.tickingChunks.put(this.chunk.m_7697_(), this);
            }
        }

        public void onChunkLoad() {
            for (SavedTickEntry savedTick : this.savedTicks) {
                BlockEntity tileEntity = (BlockEntity)this.chunk.m_62954_().get(savedTick.pos);
                if (!(tileEntity instanceof TileMultipart)) continue;
                TileMultipart tile = (TileMultipart)tileEntity;
                this.scheduledTicks.add(new PartTickEntry(tile.getPartList().get(savedTick.idx), savedTick.time, false));
            }
            this.savedTicks.clear();
            this.onAdd();
        }

        public boolean tick() {
            this.ticking = true;
            this.doTicks(this.scheduledTicks);
            this.doTicks(this.randomTicks);
            this.ticking = false;
            this.scheduledTicks.addAll(this.pendingScheduled);
            this.randomTicks.addAll(this.pendingRandom);
            this.pendingScheduled.clear();
            this.pendingRandom.clear();
            return this.scheduledTicks.isEmpty() && this.randomTicks.isEmpty() || !this.chunk.f_62775_;
        }

        private void doTicks(List<PartTickEntry> list) {
            Iterator<PartTickEntry> itr = list.iterator();
            long time = this.worldScheduler.world.m_46467_();
            while (itr.hasNext()) {
                PartTickEntry entry = itr.next();
                if (entry.time > time) continue;
                if (entry.part.hasTile()) {
                    if (entry.random) {
                        if (entry.part instanceof RandomTickPart) {
                            ((RandomTickPart)entry.part).randomTick();
                        }
                        this.addRandomTick(entry.part, time + (long)this.nextRandomTick());
                    } else {
                        entry.part.scheduledTick();
                    }
                }
                itr.remove();
            }
        }

        private int nextRandomTick() {
            return this.worldScheduler.world.m_5822_().nextInt(800) + 800;
        }
    }

    static class ChunkStorage {
        ChunkStorage() {
        }

        public Tag writeNBT(ChunkScheduler instance) {
            CompoundTag tag = new CompoundTag();
            ListTag scheduledTicks = new ListTag();
            FastStream.of(instance.scheduledTicks).map(PartTickEntry::write).filter(Objects::nonNull).forEach(arg_0 -> scheduledTicks.add(arg_0));
            instance.savedTicks.forEach(e -> scheduledTicks.add((Object)e.write()));
            tag.m_128365_("ticks", (Tag)scheduledTicks);
            return tag;
        }

        public void readNBT(ChunkScheduler instance, Tag nbt) {
            CompoundTag tag = (CompoundTag)nbt;
            FastStream.of((Iterable)tag.m_128437_("ticks", 10)).map(e -> (CompoundTag)e).map(SavedTickEntry::new).forEach(instance.savedTicks::add);
        }
    }

    private static class SavedTickEntry {
        public final BlockPos pos;
        public final int idx;
        public final long time;

        public SavedTickEntry(CompoundTag tag) {
            this.pos = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("pos"));
            this.idx = tag.m_128451_("idx");
            this.time = tag.m_128454_("time");
        }

        public CompoundTag write() {
            CompoundTag tag = new CompoundTag();
            tag.m_128365_("pos", (Tag)NbtUtils.m_129224_((BlockPos)this.pos));
            tag.m_128405_("idx", this.idx);
            tag.m_128356_("time", this.time);
            return tag;
        }
    }

    private static class PartTickEntry {
        public final MultiPart part;
        public final long time;
        public final boolean random;

        private PartTickEntry(MultiPart part, long time, boolean random) {
            this.part = part;
            this.time = time;
            this.random = random;
        }

        @Nullable
        public CompoundTag write() {
            if (!this.part.hasTile()) {
                return null;
            }
            CompoundTag tag = new CompoundTag();
            tag.m_128365_("pos", (Tag)NbtUtils.m_129224_((BlockPos)this.part.pos()));
            tag.m_128405_("idx", this.part.tile().getPartList().indexOf(this.part));
            tag.m_128356_("time", this.time);
            return tag;
        }
    }
}

