/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.minecraft;

import codechicken.lib.util.ArrayUtils;
import codechicken.multipart.api.MultipartType;
import codechicken.multipart.api.PartConverter;
import codechicken.multipart.api.SimpleMultipartType;
import codechicken.multipart.api.part.MultiPart;
import codechicken.multipart.minecraft.ButtonPart;
import codechicken.multipart.minecraft.LeverPart;
import codechicken.multipart.minecraft.McStatePart;
import codechicken.multipart.minecraft.RedstoneTorchPart;
import codechicken.multipart.minecraft.SoulTorchPart;
import codechicken.multipart.minecraft.TorchPart;
import codechicken.multipart.util.MultipartPlaceContext;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="minecraft")
public class ModContent {
    @ObjectHolder(value="torch")
    public static MultipartType<TorchPart> torchPartType;
    @ObjectHolder(value="soul_torch")
    public static MultipartType<SoulTorchPart> soulTorchPartType;
    @ObjectHolder(value="redstone_torch")
    public static MultipartType<RedstoneTorchPart> redstoneTorchPartType;
    @ObjectHolder(value="lever")
    public static MultipartType<LeverPart> leverPartType;
    @ObjectHolder(value="stone_button")
    public static MultipartType<ButtonPart.StoneButtonPart> stoneButtonPartType;
    @ObjectHolder(value="polished_blackstone_button")
    public static MultipartType<ButtonPart.PolishedBlackstoneButtonPart> polishedBlackstoneButtonPartType;
    @ObjectHolder(value="oak_button")
    public static MultipartType<ButtonPart.OakButtonPart> oakButtonPartType;
    @ObjectHolder(value="spruce_button")
    public static MultipartType<ButtonPart.SpruceButtonPart> spruceButtonPartType;
    @ObjectHolder(value="birch_button")
    public static MultipartType<ButtonPart.BirchButtonPart> birchButtonPartType;
    @ObjectHolder(value="jungle_button")
    public static MultipartType<ButtonPart.JungleButtonPart> jungleButtonPartType;
    @ObjectHolder(value="acacia_button")
    public static MultipartType<ButtonPart.AcaciaButtonPart> acaciaButtonPartType;
    @ObjectHolder(value="dark_oak_button")
    public static MultipartType<ButtonPart.DarkOakButtonPart> darkOakButtonPartType;
    @ObjectHolder(value="crimson_button")
    public static MultipartType<ButtonPart.CrimsonButtonPart> crimsonButtonPartType;
    @ObjectHolder(value="warped_button")
    public static MultipartType<ButtonPart.WarpedButtonPart> warpedButtonPartType;

    @SubscribeEvent
    public static void onRegisterMultiParts(RegistryEvent.Register<MultipartType<?>> event) {
        IForgeRegistry r = event.getRegistry();
        ModContainer container = ModLoadingContext.get().getActiveContainer();
        ModLoadingContext.get().setActiveContainer(null);
        r.register((IForgeRegistryEntry)((MultipartType)new SimpleMultipartType<TorchPart>(e -> new TorchPart()).setRegistryName("torch")));
        r.register((IForgeRegistryEntry)((MultipartType)new SimpleMultipartType<SoulTorchPart>(e -> new SoulTorchPart()).setRegistryName("soul_torch")));
        r.register((IForgeRegistryEntry)((MultipartType)new SimpleMultipartType<RedstoneTorchPart>(e -> new RedstoneTorchPart()).setRegistryName("redstone_torch")));
        r.register((IForgeRegistryEntry)((MultipartType)new SimpleMultipartType<LeverPart>(e -> new LeverPart()).setRegistryName("lever")));
        r.register((IForgeRegistryEntry)((MultipartType)new SimpleMultipartType<ButtonPart.StoneButtonPart>(e -> new ButtonPart.StoneButtonPart()).setRegistryName("stone_button")));
        r.register((IForgeRegistryEntry)((MultipartType)new SimpleMultipartType<ButtonPart.PolishedBlackstoneButtonPart>(e -> new ButtonPart.PolishedBlackstoneButtonPart()).setRegistryName("polished_blackstone_button")));
        r.register((IForgeRegistryEntry)((MultipartType)new SimpleMultipartType<ButtonPart.OakButtonPart>(e -> new ButtonPart.OakButtonPart()).setRegistryName("oak_button")));
        r.register((IForgeRegistryEntry)((MultipartType)new SimpleMultipartType<ButtonPart.SpruceButtonPart>(e -> new ButtonPart.SpruceButtonPart()).setRegistryName("spruce_button")));
        r.register((IForgeRegistryEntry)((MultipartType)new SimpleMultipartType<ButtonPart.BirchButtonPart>(e -> new ButtonPart.BirchButtonPart()).setRegistryName("birch_button")));
        r.register((IForgeRegistryEntry)((MultipartType)new SimpleMultipartType<ButtonPart.JungleButtonPart>(e -> new ButtonPart.JungleButtonPart()).setRegistryName("jungle_button")));
        r.register((IForgeRegistryEntry)((MultipartType)new SimpleMultipartType<ButtonPart.AcaciaButtonPart>(e -> new ButtonPart.AcaciaButtonPart()).setRegistryName("acacia_button")));
        r.register((IForgeRegistryEntry)((MultipartType)new SimpleMultipartType<ButtonPart.DarkOakButtonPart>(e -> new ButtonPart.DarkOakButtonPart()).setRegistryName("dark_oak_button")));
        r.register((IForgeRegistryEntry)((MultipartType)new SimpleMultipartType<ButtonPart.CrimsonButtonPart>(e -> new ButtonPart.CrimsonButtonPart()).setRegistryName("crimson_button")));
        r.register((IForgeRegistryEntry)((MultipartType)new SimpleMultipartType<ButtonPart.WarpedButtonPart>(e -> new ButtonPart.WarpedButtonPart()).setRegistryName("warped_button")));
        ModLoadingContext.get().setActiveContainer(container);
    }

    @SubscribeEvent
    public static void onRegisterMultiPartConverters(RegistryEvent.Register<PartConverter> event) {
        IForgeRegistry r = event.getRegistry();
        ModContainer container = ModLoadingContext.get().getActiveContainer();
        ModLoadingContext.get().setActiveContainer(null);
        r.register((IForgeRegistryEntry)((PartConverter)new Converter<TorchPart>(TorchPart::new, TorchPart::new, Items.f_42000_, Blocks.f_50081_, Blocks.f_50082_).setRegistryName("torch")));
        r.register((IForgeRegistryEntry)((PartConverter)new Converter<SoulTorchPart>(SoulTorchPart::new, SoulTorchPart::new, Items.f_42053_, Blocks.f_50139_, Blocks.f_50140_).setRegistryName("soul_torch")));
        r.register((IForgeRegistryEntry)((PartConverter)new Converter<RedstoneTorchPart>(RedstoneTorchPart::new, RedstoneTorchPart::new, Items.f_41978_, Blocks.f_50174_, Blocks.f_50123_).setRegistryName("redstone_torch")));
        r.register((IForgeRegistryEntry)((PartConverter)new Converter<LeverPart>(LeverPart::new, LeverPart::new, Items.f_41966_, Blocks.f_50164_).setRegistryName("lever")));
        r.register((IForgeRegistryEntry)((PartConverter)new Converter<ButtonPart.StoneButtonPart>(ButtonPart.StoneButtonPart::new, ButtonPart.StoneButtonPart::new, Items.f_42083_, Blocks.f_50124_).setRegistryName("stone_button")));
        r.register((IForgeRegistryEntry)((PartConverter)new Converter<ButtonPart.PolishedBlackstoneButtonPart>(ButtonPart.PolishedBlackstoneButtonPart::new, ButtonPart.PolishedBlackstoneButtonPart::new, Items.f_42145_, Blocks.f_50710_).setRegistryName("polished_blackstone_button")));
        r.register((IForgeRegistryEntry)((PartConverter)new Converter<ButtonPart.OakButtonPart>(ButtonPart.OakButtonPart::new, ButtonPart.OakButtonPart::new, Items.f_42084_, Blocks.f_50251_).setRegistryName("oak_button")));
        r.register((IForgeRegistryEntry)((PartConverter)new Converter<ButtonPart.SpruceButtonPart>(ButtonPart.SpruceButtonPart::new, ButtonPart.SpruceButtonPart::new, Items.f_42085_, Blocks.f_50252_).setRegistryName("spruce_button")));
        r.register((IForgeRegistryEntry)((PartConverter)new Converter<ButtonPart.BirchButtonPart>(ButtonPart.BirchButtonPart::new, ButtonPart.BirchButtonPart::new, Items.f_42086_, Blocks.f_50253_).setRegistryName("birch_button")));
        r.register((IForgeRegistryEntry)((PartConverter)new Converter<ButtonPart.JungleButtonPart>(ButtonPart.JungleButtonPart::new, ButtonPart.JungleButtonPart::new, Items.f_42087_, Blocks.f_50254_).setRegistryName("jungle_button")));
        r.register((IForgeRegistryEntry)((PartConverter)new Converter<ButtonPart.AcaciaButtonPart>(ButtonPart.AcaciaButtonPart::new, ButtonPart.AcaciaButtonPart::new, Items.f_42088_, Blocks.f_50308_).setRegistryName("acacia_button")));
        r.register((IForgeRegistryEntry)((PartConverter)new Converter<ButtonPart.DarkOakButtonPart>(ButtonPart.DarkOakButtonPart::new, ButtonPart.DarkOakButtonPart::new, Items.f_42089_, Blocks.f_50309_).setRegistryName("dark_oak_button")));
        r.register((IForgeRegistryEntry)((PartConverter)new Converter<ButtonPart.CrimsonButtonPart>(ButtonPart.CrimsonButtonPart::new, ButtonPart.CrimsonButtonPart::new, Items.f_42090_, Blocks.f_50669_).setRegistryName("crimson_button")));
        r.register((IForgeRegistryEntry)((PartConverter)new Converter<ButtonPart.WarpedButtonPart>(ButtonPart.WarpedButtonPart::new, ButtonPart.WarpedButtonPart::new, Items.f_42144_, Blocks.f_50670_).setRegistryName("warped_button")));
        ModLoadingContext.get().setActiveContainer(container);
    }

    private static class Converter<T extends McStatePart>
    extends PartConverter {
        private final Supplier<T> factory;
        private final Function<BlockState, T> blockFactory;
        private final Item item;
        private final Block[] blocks;

        private Converter(Supplier<T> factory, Function<BlockState, T> blockFactory, Item item, Block ... blocks) {
            this.factory = factory;
            this.blockFactory = blockFactory;
            this.item = item;
            this.blocks = blocks;
        }

        @Override
        public PartConverter.ConversionResult<Collection<MultiPart>> convert(LevelAccessor world, BlockPos pos, BlockState state) {
            if (this.blocks.length == 0) {
                return PartConverter.emptyResultList();
            }
            if (ArrayUtils.contains((Object[])this.blocks, (Object)state.m_60734_())) {
                return PartConverter.ConversionResult.success(Collections.singleton((MultiPart)this.blockFactory.apply(state)));
            }
            return super.convert(world, pos, state);
        }

        @Override
        public PartConverter.ConversionResult<MultiPart> convert(MultipartPlaceContext context) {
            if (context.m_43722_().m_41720_() != this.item) {
                return Converter.emptyResult();
            }
            MultiPart result = ((McStatePart)this.factory.get()).setStateOnPlacement(context);
            if (result != null) {
                return PartConverter.ConversionResult.success(result);
            }
            return super.convert(context);
        }
    }
}

