/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.handler;

import codechicken.lib.raytracer.RayTracer;
import codechicken.multipart.api.part.MultiPart;
import codechicken.multipart.block.TileMultipart;
import codechicken.multipart.init.MultiPartRegistries;
import codechicken.multipart.util.MultipartHelper;
import codechicken.multipart.util.MultipartPlaceContext;
import net.covers1624.quack.util.CrashLock;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;

public class PlacementConversionHandler {
    private static final CrashLock LOCK = new CrashLock("Already initialized.");

    public static void init() {
        LOCK.lock();
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOW, PlacementConversionHandler::onRightClickBlock);
    }

    private static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Level world = event.getWorld();
        if (PlacementConversionHandler.place(event.getPlayer(), event.getHand())) {
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.m_19078_((boolean)world.f_46443_));
        }
    }

    private static boolean place(Player player, InteractionHand hand) {
        ItemStack held = player.m_21120_(hand);
        if (held.m_41619_()) {
            return false;
        }
        BlockHitResult hit = RayTracer.retrace((Player)player);
        if (hit.m_6662_() == HitResult.Type.MISS) {
            return false;
        }
        MultipartPlaceContext ctx = new MultipartPlaceContext(player, hand, hit);
        if (ctx.getHitDepth() < 1.0 && PlacementConversionHandler.place(player, hand, ctx)) {
            return true;
        }
        return PlacementConversionHandler.place(player, hand, ctx.applyOffset());
    }

    private static boolean place(Player player, InteractionHand hand, MultipartPlaceContext ctx) {
        Level world = ctx.m_43725_();
        BlockPos pos = ctx.m_8083_();
        MultiPart part = MultiPartRegistries.convertItem(ctx);
        if (part == null) {
            return false;
        }
        TileMultipart tile = MultipartHelper.getOrConvertTile(world, pos);
        if (tile == null) {
            return false;
        }
        if (!tile.canAddPart(part)) {
            return false;
        }
        if (!world.f_46443_) {
            TileMultipart.addPart(world, pos, part);
            SoundType sound = part.getPlacementSound((UseOnContext)ctx);
            if (sound != null) {
                world.m_6263_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, sound.m_56777_(), SoundSource.BLOCKS, (sound.m_56773_() + 1.0f) / 2.0f, sound.m_56774_() * 0.8f);
            }
            if (!player.m_150110_().f_35937_) {
                ItemStack held = ctx.m_43722_();
                held.m_41774_(1);
                if (held.m_41619_()) {
                    ForgeEventFactory.onPlayerDestroyItem((Player)player, (ItemStack)held, (InteractionHand)hand);
                }
            }
        } else {
            player.m_6674_(hand);
        }
        return true;
    }
}

