/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.api;

import codechicken.lib.vec.Rotation;
import codechicken.multipart.api.RedstoneConnectorBlock;
import codechicken.multipart.api.part.MultiPart;
import codechicken.multipart.api.part.redstone.FaceRedstonePart;
import codechicken.multipart.api.part.redstone.MaskedRedstonePart;
import codechicken.multipart.api.part.redstone.RedstonePart;
import codechicken.multipart.api.tile.RedstoneConnector;
import codechicken.multipart.trait.extern.RedstoneTile;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.RedstoneWallTorchBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class RedstoneInteractions {
    private static final Set<Block> FULL_VANILLA_BLOCKS = ImmutableSet.builder().add((Object)Blocks.f_50261_).build();

    public static int getPowerTo(MultiPart p, int side) {
        int oc = ((RedstoneTile)((Object)p.tile())).openConnections(side);
        return RedstoneInteractions.getPowerTo(p.level(), p.pos(), side, oc & RedstoneInteractions.connectionMask(p, side));
    }

    public static int getPowerTo(Level world, BlockPos pos, int side, int mask) {
        return RedstoneInteractions.getPower(world, pos.m_142300_(Direction.m_122376_((int)side)), side ^ 1, mask);
    }

    public static int getPower(Level world, BlockPos pos, int side, int mask) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof RedstoneConnector) {
            RedstoneConnector cond = (RedstoneConnector)blockEntity;
            return cond.weakPowerLevel(side, mask);
        }
        BlockState state = world.m_8055_(pos);
        Block block = state.m_60734_();
        if (block instanceof RedstoneConnectorBlock) {
            RedstoneConnectorBlock bl = (RedstoneConnectorBlock)block;
            return bl.weakPowerLevel((LevelReader)world, pos, side, mask);
        }
        int vMask = RedstoneInteractions.vanillaConnectionMask((LevelReader)world, pos, state, side, true);
        if ((vMask & mask) > 0) {
            int m = world.m_46681_(pos, Direction.m_122376_((int)(side ^ 1)));
            if (m < 15 && block == Blocks.f_50088_) {
                m = Math.max(m, (Integer)state.m_61143_((Property)RedStoneWireBlock.f_55500_));
            }
            return m;
        }
        return 0;
    }

    public static int otherConnectionMask(LevelReader world, BlockPos pos, int side, boolean power) {
        return RedstoneInteractions.getConnectionMask(world, pos.m_142300_(Direction.m_122376_((int)side)), side ^ 1, power);
    }

    public static int connectionMask(MultiPart p, int side) {
        if (p instanceof RedstonePart && ((RedstonePart)p).canConnectRedstone(side)) {
            if (p instanceof FaceRedstonePart) {
                FaceRedstonePart part = (FaceRedstonePart)p;
                int fside = part.getFace();
                if ((side & 6) == (fside & 6)) {
                    return 16;
                }
                return 1 << Rotation.rotationTo((int)(side & 6), (int)fside);
            }
            if (p instanceof MaskedRedstonePart) {
                MaskedRedstonePart part = (MaskedRedstonePart)p;
                return part.getConnectionMask(side);
            }
            return 31;
        }
        return 0;
    }

    public static int getConnectionMask(LevelReader world, BlockPos pos, int side, boolean power) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof RedstoneConnector) {
            RedstoneConnector cond = (RedstoneConnector)blockEntity;
            return cond.getConnectionMask(side);
        }
        BlockState state = world.m_8055_(pos);
        Block block = state.m_60734_();
        if (block instanceof RedstoneConnectorBlock) {
            RedstoneConnectorBlock bl = (RedstoneConnectorBlock)block;
            return bl.getConnectionMask(world, pos, side);
        }
        return RedstoneInteractions.vanillaConnectionMask(world, pos, state, side, power);
    }

    public static int vanillaConnectionMask(LevelReader world, BlockPos pos, BlockState state, int side, boolean power) {
        Block block = state.m_60734_();
        if (FULL_VANILLA_BLOCKS.contains(block)) {
            return 31;
        }
        if (block == Blocks.f_50088_) {
            if (side == 1) {
                return 0;
            }
            return power ? 31 : 4;
        }
        if (block == Blocks.f_50328_) {
            if (side == 0 || side == 1) {
                return 0;
            }
            return power ? 31 : 4;
        }
        if (block == Blocks.f_50146_) {
            int fside = ((Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).ordinal();
            if ((side & 6) == (fside & 6)) {
                return power ? 31 : 4;
            }
            return 0;
        }
        if (block == Blocks.f_50174_) {
            if (power) {
                return 31;
            }
            if (side == 0 || side == 1) {
                return 16;
            }
            return 4;
        }
        if (block == Blocks.f_50123_) {
            if (power) {
                return 31;
            }
            int fside = ((Direction)state.m_61143_((Property)RedstoneWallTorchBlock.f_55740_)).m_122424_().ordinal();
            if ((side & 6) == (fside & 6)) {
                return 16;
            }
            return 1 << Rotation.rotationTo((int)(side & 6), (int)fside);
        }
        if (block instanceof ButtonBlock || block instanceof LeverBlock) {
            if (power) {
                return 31;
            }
            int fside = FaceAttachedHorizontalDirectionalBlock.m_53200_((BlockState)state).m_122424_().ordinal();
            if ((side & 6) == (fside & 6)) {
                return 16;
            }
            return 1 << Rotation.rotationTo((int)(side & 6), (int)fside);
        }
        if (power || block.canConnectRedstone(state, (BlockGetter)world, pos, Direction.m_122376_((int)side))) {
            return 31;
        }
        return 0;
    }
}

