/*
 * Decompiled with CFR 0.152.
 */
package codechicken.mixin.util;

import codechicken.mixin.util.FieldMixin;
import com.google.common.collect.Streams;
import java.util.List;
import java.util.stream.Stream;
import org.objectweb.asm.tree.MethodNode;

public class MixinInfo {
    private final String name;
    private final String parent;
    private final List<MixinInfo> parentTraits;
    private final List<FieldMixin> fields;
    private final List<MethodNode> methods;
    private final List<String> supers;

    public MixinInfo(String name, String parent, List<MixinInfo> parentTraits, List<FieldMixin> fields, List<MethodNode> methods, List<String> supers) {
        this.name = name;
        this.parent = parent;
        this.parentTraits = parentTraits;
        this.fields = fields;
        this.methods = methods;
        this.supers = supers;
    }

    public Stream<MixinInfo> linearize() {
        return Streams.concat((Stream[])new Stream[]{this.parentTraits.stream().flatMap(MixinInfo::linearize), Stream.of(this)});
    }

    public String getName() {
        return this.name;
    }

    public String getParent() {
        return this.parent;
    }

    public List<MixinInfo> getParentTraits() {
        return this.parentTraits;
    }

    public List<FieldMixin> getFields() {
        return this.fields;
    }

    public List<MethodNode> getMethods() {
        return this.methods;
    }

    public List<String> getSupers() {
        return this.supers;
    }
}

