/*
 * Decompiled with CFR 0.152.
 */
package codechicken.microblock.init;

import codechicken.microblock.api.BlockMicroMaterial;
import codechicken.microblock.api.MicroMaterial;
import codechicken.microblock.util.MicroMaterialRegistry;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import net.covers1624.quack.io.IOUtils;
import net.covers1624.quack.util.SneakyUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MicroMaterialConfig {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final List<String> DEFAULT_CONFIG = List.of("# Configuration file for adding microblock materials for aesthetic blocks added by mods", "# The '#' character defines a comment, everything after this character on a given line will be ignored.", "# Each line needs to be of the form <registry_name>[property=value,otherProperty=value]", "# <registry_name> being the registry name of the block. E.G: 'minecraft:stone'", "# This can optionally be followed by Key-Value pairs describing any block state properties.", "# If no properties are defined, the default state of the block will be used.", "# Examples:", "#minecraft:stone", "#minecraft:grass_block[snowy=true]");

    public static void parse(Path file) {
        if (Files.notExists(file, new LinkOption[0])) {
            try {
                Files.write(IOUtils.makeParents((Path)file), DEFAULT_CONFIG, StandardCharsets.UTF_8, new OpenOption[0]);
            }
            catch (IOException ex) {
                LOGGER.error("Failed to write default microblock config.", (Throwable)ex);
            }
            return;
        }
        ForgeRegistry registry = (ForgeRegistry)MicroMaterialRegistry.MICRO_MATERIALS;
        registry.unfreeze();
        try (BufferedReader reader = Files.newBufferedReader(file);){
            String line;
            int i = 0;
            while ((line = reader.readLine()) != null) {
                MicroMaterialConfig.parseLine(line.trim(), i++, (IForgeRegistry<MicroMaterial>)registry);
            }
        }
        catch (IOException ex) {
            LOGGER.error("failed to read microblock config.", (Throwable)ex);
        }
        registry.freeze();
    }

    private static void parseLine(String line, int lineNumber, IForgeRegistry<MicroMaterial> registry) {
        int hashIndex = line.indexOf("#");
        if (hashIndex != -1) {
            line = line.substring(0, hashIndex).trim();
        }
        if (line.isEmpty()) {
            return;
        }
        int openBracketIdx = line.indexOf("[");
        ResourceLocation resourceLocation = new ResourceLocation(openBracketIdx == -1 ? line : line.substring(0, openBracketIdx));
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(resourceLocation);
        if (block == null) {
            LOGGER.error("Error reading microblock config line {}, Missing block: '{}'", (Object)lineNumber, (Object)resourceLocation);
            return;
        }
        BlockState state = block.m_49966_();
        if (openBracketIdx != -1) {
            int closeBracketIdx = line.indexOf(93);
            if (closeBracketIdx == -1) {
                LOGGER.error("Error reading microblock config line {}: '{}', Missing closing brace.", (Object)lineNumber, (Object)line);
                return;
            }
            String rawProps = line.substring(openBracketIdx + 1, closeBracketIdx);
            String[] splits = rawProps.split(",");
            for (int i = 0; i < splits.length; ++i) {
                String elem = splits[i];
                if (!elem.contains("=")) {
                    LOGGER.error("Error reading microblock config line {}. Property split {} missing equals.", (Object)lineNumber, (Object)i);
                    return;
                }
                String[] propSplit = elem.split("=");
                if (propSplit.length != 2) {
                    LOGGER.error("Error reading microblock config line {}. Property split {}, split on equals error: {}", (Object)lineNumber, (Object)i, (Object)elem);
                    return;
                }
                String propName = propSplit[0];
                String propValue = propSplit[1];
                Property property = block.m_49965_().m_61081_(propName);
                if (property == null) {
                    LOGGER.error("Error reading microblock config line {}. Property '{}' does not exist for block: {}", (Object)lineNumber, (Object)propName, (Object)resourceLocation);
                    return;
                }
                Optional value = property.m_6215_(propValue);
                if (value.isEmpty()) {
                    LOGGER.error("Error reading microblock config line {}. Property '{}' does not have value {} for block: {}", (Object)lineNumber, (Object)propName, (Object)propValue, (Object)resourceLocation);
                    return;
                }
                state = (BlockState)state.m_61124_(property, (Comparable)SneakyUtils.unsafeCast(value.get()));
            }
        }
        if (registry.containsKey(BlockMicroMaterial.makeMaterialKey(state))) {
            LOGGER.warn("Skipping microblock config line {}. Micro material for BlockState {} already registered.", (Object)lineNumber, (Object)state);
            return;
        }
        registry.register((IForgeRegistryEntry)new BlockMicroMaterial(state));
    }
}

