/*
 * Decompiled with CFR 0.152.
 */
package codechicken.microblock.client;

import codechicken.lib.model.CachedFormat;
import codechicken.lib.model.pipeline.BakedPipeline;
import codechicken.lib.model.pipeline.transformers.QuadClamper;
import codechicken.lib.model.pipeline.transformers.QuadFaceStripper;
import codechicken.lib.model.pipeline.transformers.QuadReInterpolator;
import codechicken.lib.model.pipeline.transformers.QuadTinter;
import codechicken.lib.render.BakedVertexSource;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.buffer.TransformingVertexConsumer;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.render.pipeline.IVertexSource;
import codechicken.lib.vec.Line3;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Scale;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;
import codechicken.microblock.api.BlockMicroMaterial;
import codechicken.microblock.api.MicroMaterial;
import codechicken.microblock.client.MicroMaterialClientRegistry;
import codechicken.microblock.init.CBMicroblockModContent;
import codechicken.microblock.item.ItemMicroBlock;
import codechicken.microblock.part.ExecutablePlacement;
import codechicken.microblock.part.MicroblockPlacement;
import codechicken.microblock.part.PlacementGrid;
import codechicken.microblock.part.StandardMicroFactory;
import codechicken.microblock.util.MaskedCuboid;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.OptionalDouble;
import java.util.Random;
import net.covers1624.quack.util.CrashLock;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.client.event.DrawSelectionEvent;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import org.jetbrains.annotations.Nullable;

public class MicroblockRender {
    private static final CrashLock LOCK = new CrashLock("Already Initialized");
    private static final ThreadLocal<PipelineState> PIPELINES = ThreadLocal.withInitial(PipelineState::create);
    public static final RenderType HIGHLIGHT_RENDER_TYPE = RenderType.m_173209_((String)"cb_microblock:highlight", (VertexFormat)DefaultVertexFormat.f_85811_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)255, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RenderType.f_173097_).m_173290_((RenderStateShard.EmptyTextureStateShard)RenderType.f_110146_).m_110687_(RenderType.f_110114_).m_110685_(RenderType.f_110139_).m_110691_(false));
    private static final RenderType LINES = RenderType.m_173209_((String)"lines", (VertexFormat)DefaultVertexFormat.f_166851_, (VertexFormat.Mode)VertexFormat.Mode.LINES, (int)256, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RenderType.f_173095_).m_110673_(new RenderStateShard.LineStateShard(OptionalDouble.of(2.0))).m_110669_(RenderType.f_110119_).m_110685_(RenderType.f_110139_).m_110687_(RenderType.f_110114_).m_110661_(RenderType.f_110110_).m_110691_(false));

    public static void init() {
        LOCK.lock();
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGH, MicroblockRender::onDrawHighlight);
    }

    private static void onDrawHighlight(DrawSelectionEvent.HighlightBlock event) {
        Camera camera = event.getCamera();
        Entity entity = camera.m_90592_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            ItemStack stack = player.m_21205_();
            if (!stack.m_150930_((Item)CBMicroblockModContent.MICRO_BLOCK_ITEM.get())) {
                return;
            }
            PoseStack pStack = event.getPoseStack();
            pStack.m_85836_();
            pStack.m_85837_(-camera.m_90583_().f_82479_, -camera.m_90583_().f_82480_, -camera.m_90583_().f_82481_);
            if (MicroblockRender.renderHighlight(player, InteractionHand.MAIN_HAND, stack, event.getTarget(), pStack, event.getMultiBufferSource(), event.getPartialTicks())) {
                event.setCanceled(true);
            }
            pStack.m_85849_();
        }
    }

    private static boolean renderHighlight(Player player, InteractionHand hand, ItemStack stack, BlockHitResult hit, PoseStack pStack, MultiBufferSource buffers, float partialTicks) {
        MicroMaterial material = ItemMicroBlock.getMaterialFromStack(stack);
        StandardMicroFactory factory = ItemMicroBlock.getFactory(stack);
        int size = ItemMicroBlock.getSize(stack);
        if (material == null || factory == null) {
            return false;
        }
        MicroblockRender.renderHighlight(player, hand, hit, factory, size, material, pStack, buffers, partialTicks);
        return true;
    }

    private static void renderHighlight(Player player, InteractionHand hand, BlockHitResult hit, StandardMicroFactory factory, int size, MicroMaterial material, PoseStack pStack, MultiBufferSource buffers, float partialTicks) {
        if (MicroMaterialClientRegistry.renderHighlightOverride(player, hand, hit, factory, size, material, pStack, buffers, partialTicks)) {
            return;
        }
        MicroblockRender.renderPlacementGrid(factory.placementProperties().placementGrid(), pStack, new Vector3(hit.m_82450_()), hit.m_82434_().ordinal(), buffers);
        ExecutablePlacement placement = new MicroblockPlacement(player, hand, hit, size, material, !player.m_150110_().f_35937_, factory.placementProperties()).calculate();
        if (placement == null) {
            return;
        }
        BlockPos pos = placement.pos;
        Matrix4 mat = new Matrix4(pStack);
        mat.translate((Vec3i)pos);
        mat.apply(new Scale(1.002, 1.002, 1.002).at(Vector3.CENTER));
        CCRenderState ccrs = CCRenderState.instance();
        ccrs.reset();
        ccrs.bind(HIGHLIGHT_RENDER_TYPE, buffers, mat);
        ccrs.alphaOverride = 80;
        MicroblockRender.renderCuboids(ccrs, ((BlockMicroMaterial)material).state, null, placement.part.getRenderCuboids(true));
    }

    private static void renderPlacementGrid(PlacementGrid grid, PoseStack pStack, Vector3 hit, int side, MultiBufferSource buffers) {
        Matrix4 mat = new Matrix4(pStack);
        MicroblockRender.transformFace(hit, side, mat);
        TransformingVertexConsumer cons = new TransformingVertexConsumer(buffers.m_6299_(LINES), (Transformation)mat);
        for (Line3 line : grid.getOverlayLines()) {
            MicroblockRender.bufferLinePair((VertexConsumer)cons, line.pt1, line.pt2, 0.0f, 0.0f, 0.0f, 1.0f);
        }
    }

    private static void bufferLinePair(VertexConsumer builder, Vector3 v1, Vector3 v2, float r, float g, float b, float a) {
        Vector3 vn = v1.copy().subtract(v2);
        double d = vn.mag();
        vn.divide(d);
        builder.m_5483_(v1.x, v1.y, v1.z).m_85950_(r, g, b, a).m_5601_((float)vn.x, (float)vn.y, (float)vn.z).m_5752_();
        builder.m_5483_(v2.x, v2.y, v2.z).m_85950_(r, g, b, a).m_5601_((float)vn.x, (float)vn.y, (float)vn.z).m_5752_();
    }

    private static void transformFace(Vector3 hit, int side, Matrix4 mat) {
        Vector3 pos = hit.copy().floor().add(Vector3.CENTER);
        mat.translate(pos);
        mat.apply(Rotation.sideRotations[side]);
        Vector3 rHit = pos.copy().subtract(hit).apply((Transformation)Rotation.sideRotations[side ^ 1].inverse());
        mat.translate(0.0, rHit.y - 0.002, 0.0);
    }

    public static boolean renderCuboids(CCRenderState ccrs, BlockState state, @Nullable RenderType layer, Iterable<MaskedCuboid> cuboids) {
        PipelineState pipeState = PIPELINES.get();
        BakedVertexSource vertexSource = BakedVertexSource.instance();
        Random randy = new Random();
        BlockRenderDispatcher dispatcher = Minecraft.m_91087_().m_91289_();
        BlockColors blockColors = Minecraft.m_91087_().m_91298_();
        BakedModel model = dispatcher.m_110910_(state);
        BlockPos pos = null;
        long seed = 42L;
        MicroblockLevelProxy level = null;
        EmptyModelData modelData = EmptyModelData.INSTANCE;
        if (layer != null) {
            pos = ccrs.lightMatrix.pos;
            seed = state.m_60726_(pos);
            level = new MicroblockLevelProxy(ccrs.lightMatrix.access, pos, state);
            modelData = model.getModelData((BlockAndTintGetter)level, pos, state, (IModelData)modelData);
        }
        boolean ret = false;
        for (Direction face : Direction.f_122348_) {
            randy.setSeed(seed);
            for (BakedQuad quad : model.getQuads(state, face, randy, (IModelData)modelData)) {
                ret |= MicroblockRender.renderQuad(ccrs, vertexSource, pipeState, blockColors, layer, quad, state, level, pos, cuboids);
            }
        }
        randy.setSeed(seed);
        for (BakedQuad quad : model.getQuads(state, null, randy, (IModelData)modelData)) {
            ret |= MicroblockRender.renderQuad(ccrs, vertexSource, pipeState, blockColors, layer, quad, state, level, pos, cuboids);
        }
        return ret;
    }

    private static boolean renderQuad(CCRenderState ccrs, BakedVertexSource vs, PipelineState pipeState, BlockColors blockColors, @Nullable RenderType layer, BakedQuad quad, BlockState state, @Nullable BlockAndTintGetter level, @Nullable BlockPos pos, Iterable<MaskedCuboid> cuboids) {
        BakedPipeline pipeline = pipeState.pipeline;
        QuadClamper clamper = pipeState.clamper;
        QuadFaceStripper faceStripper = pipeState.faceStripper;
        QuadTinter tinter = pipeState.tinter;
        CachedFormat format = MicroblockRender.formatFor(quad);
        vs.reset(format);
        if (quad.m_111304_()) {
            tinter.setTint(blockColors.m_92577_(state, level, pos, quad.m_111305_()));
        }
        for (MaskedCuboid cuboid : cuboids) {
            pipeline.reset(format);
            faceStripper.setBounds(cuboid.box());
            faceStripper.setMask(cuboid.sideMask());
            clamper.setClampBounds(cuboid.box());
            pipeline.setElementState("tinter", quad.m_111304_());
            pipeline.prepare((IVertexConsumer)vs);
            quad.pipe((IVertexConsumer)pipeline);
        }
        if (vs.getVertexCount() <= 0) {
            return false;
        }
        ccrs.setModel((IVertexSource)vs);
        if (layer != null) {
            ccrs.render(new IVertexOperation[]{ccrs.lightMatrix});
        } else {
            ccrs.render();
        }
        return true;
    }

    private static CachedFormat formatFor(BakedQuad quad) {
        return CachedFormat.BLOCK;
    }

    private record PipelineState(BakedPipeline pipeline, QuadClamper clamper, QuadFaceStripper faceStripper, QuadTinter tinter) {
        public static PipelineState create() {
            BakedPipeline pipeline = BakedPipeline.builder().addElement("clamper", QuadClamper.FACTORY).addElement("face_stripper", QuadFaceStripper.FACTORY).addElement("interpolator", QuadReInterpolator.FACTORY).addElement("tinter", QuadTinter.FACTORY, false).build();
            return new PipelineState(pipeline, (QuadClamper)pipeline.getElement("clamper", QuadClamper.class), (QuadFaceStripper)pipeline.getElement("face_stripper", QuadFaceStripper.class), (QuadTinter)pipeline.getElement("tinter", QuadTinter.class));
        }
    }

    private static class MicroblockLevelProxy
    implements BlockAndTintGetter {
        private final BlockAndTintGetter other;
        private final BlockPos pos;
        private final BlockState state;

        private MicroblockLevelProxy(BlockAndTintGetter other, BlockPos pos, BlockState state) {
            this.other = other;
            this.pos = pos;
            this.state = state;
        }

        public float m_7717_(Direction face, boolean shade) {
            return this.other.m_7717_(face, shade);
        }

        public LevelLightEngine m_5518_() {
            return this.other.m_5518_();
        }

        public int m_6171_(BlockPos pos, ColorResolver resolver) {
            return this.other.m_6171_(pos, resolver);
        }

        @Nullable
        public BlockEntity m_7702_(BlockPos pos) {
            return this.other.m_7702_(pos);
        }

        public BlockState m_8055_(BlockPos pos) {
            return pos.equals((Object)this.pos) ? this.state : this.other.m_8055_(pos);
        }

        public FluidState m_6425_(BlockPos pos) {
            return this.other.m_6425_(pos);
        }

        public int m_141928_() {
            return this.other.m_141928_();
        }

        public int m_141937_() {
            return this.other.m_141937_();
        }
    }
}

