/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.trollcave;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.data.worldgen.features.TreeFeatures;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import twilightforest.world.components.structures.trollcave.TrollCaveMainComponent;
import twilightforest.world.components.structures.trollcave.TrollCavePieces;
import twilightforest.world.registration.TFFeature;
import twilightforest.world.registration.features.TFConfiguredFeatures;

public class TrollCaveGardenComponent
extends TrollCaveMainComponent {
    public TrollCaveGardenComponent(StructurePieceSerializationContext ctx, CompoundTag nbt) {
        super(TrollCavePieces.TFTCGard, nbt);
    }

    public TrollCaveGardenComponent(TFFeature feature, int index, int x, int y, int z, int caveSize, int caveHeight, Direction direction) {
        super(TrollCavePieces.TFTCGard, feature, index, x, y, z);
        this.size = caveSize;
        this.height = caveHeight;
        this.m_73519_(direction);
        this.f_73383_ = feature.getComponentToAddBoundingBox(x, y, z, 0, 0, 0, this.size - 1, this.height - 1, this.size - 1, direction);
    }

    @Override
    public void m_142537_(StructurePiece parent, StructurePieceAccessor list, Random rand) {
    }

    @Override
    public void m_183269_(WorldGenLevel world, StructureFeatureManager manager, ChunkGenerator generator, Random rand, BoundingBox sbb, ChunkPos chunkPosIn, BlockPos blockPos) {
        BlockPos.MutableBlockPos dest;
        int i;
        this.hollowCaveMiddle(world, sbb, rand, 0, 0, 0, this.size - 1, this.height - 1, this.size - 1);
        Random decoRNG = new Random(world.m_7328_() + (long)this.f_73383_.m_162395_() * 321534781L ^ (long)this.f_73383_.m_162398_() * 756839L);
        this.makeTreasureCrate(world, sbb);
        for (i = 0; i < 24; ++i) {
            dest = this.getCoordsInCave(decoRNG);
            this.generate(world, generator, TFConfiguredFeatures.TROLL_CAVE_DIRT, decoRNG, dest.m_123341_(), 0, dest.m_123343_(), sbb);
        }
        for (i = 0; i < 16; ++i) {
            dest = this.getCoordsInCave(decoRNG);
            this.generate(world, generator, TFConfiguredFeatures.TROLL_CAVE_MYCELIUM, decoRNG, dest.m_123341_(), 0, dest.m_123343_(), sbb);
        }
        for (i = 0; i < 16; ++i) {
            dest = this.getCoordsInCave(decoRNG);
            this.generate(world, generator, TFConfiguredFeatures.UBEROUS_SOIL_PATCH_SMALL, decoRNG, dest.m_123341_(), 0, dest.m_123343_(), sbb);
            this.generateAtSurface(world, generator, TFConfiguredFeatures.UBEROUS_SOIL_PATCH_SMALL, decoRNG, dest.m_123341_(), dest.m_123343_(), sbb);
        }
        for (i = 0; i < 8; ++i) {
            dest = this.getCoordsInCave(decoRNG);
            this.setBlockStateRotated(world, Blocks.f_50195_.m_49966_(), dest.m_123341_(), dest.m_142448_(0).m_123342_(), dest.m_123343_(), this.f_73379_, sbb);
            this.generate(world, generator, TFConfiguredFeatures.BIG_MUSHGLOOM, decoRNG, dest.m_123341_(), dest.m_142448_(1).m_123342_(), dest.m_123343_(), sbb);
        }
        for (i = 0; i < 16; ++i) {
            dest = this.getCoordsInCave(decoRNG);
            this.setBlockStateRotated(world, Blocks.f_50195_.m_49966_(), dest.m_123341_(), dest.m_142448_(0).m_123342_(), dest.m_123343_(), this.f_73379_, sbb);
            this.generate(world, generator, rand.nextBoolean() ? TreeFeatures.f_195121_ : TreeFeatures.f_195122_, decoRNG, dest.m_123341_(), dest.m_142448_(1).m_123342_(), dest.m_123343_(), sbb);
        }
        for (i = 0; i < 128; ++i) {
            dest = this.getCoordsInCave(decoRNG);
            this.generateBlockSpike(world, STONE_STALACTITE, (Vec3i)dest.m_175288_(this.height), sbb);
        }
    }

    protected <FC extends FeatureConfiguration> void generate(WorldGenLevel world, ChunkGenerator generator, Holder<ConfiguredFeature<FC, ?>> feature, Random rand, int x, int y, int z, BoundingBox sbb) {
        int dz;
        int dy;
        int dx = this.m_73392_(x, z);
        BlockPos pos = new BlockPos(dx, dy = this.m_73544_(y), dz = this.m_73525_(x, z));
        if (sbb.m_71051_((Vec3i)pos)) {
            ((ConfiguredFeature)feature.m_203334_()).m_65385_(world, generator, rand, pos);
        }
    }
}

