/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.loot.functions;

import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IRegistryDelegate;
import twilightforest.loot.TFTreasure;

public class Enchant
extends LootItemConditionalFunction {
    private final Map<IRegistryDelegate<Enchantment>, Short> enchantments;

    protected Enchant(LootItemCondition[] conditions, Map<IRegistryDelegate<Enchantment>, Short> enchantments) {
        super(conditions);
        this.enchantments = enchantments;
    }

    public LootItemFunctionType m_7162_() {
        return TFTreasure.ENCHANT;
    }

    public ItemStack m_7372_(ItemStack stack, LootContext context) {
        for (Map.Entry<IRegistryDelegate<Enchantment>, Short> e : this.enchantments.entrySet()) {
            if (stack.m_41720_() == Items.f_42690_) {
                EnchantedBookItem.m_41153_((ItemStack)stack, (EnchantmentInstance)new EnchantmentInstance((Enchantment)e.getKey().get(), (int)e.getValue().shortValue()));
                continue;
            }
            stack.m_41663_((Enchantment)e.getKey().get(), (int)e.getValue().shortValue());
        }
        return stack;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        private final Map<IRegistryDelegate<Enchantment>, Short> enchants = Maps.newHashMap();

        protected Builder getThis() {
            return this;
        }

        public Builder apply(Enchantment p_216077_1_, Integer p_216077_2_) {
            this.enchants.put((IRegistryDelegate<Enchantment>)p_216077_1_.delegate, p_216077_2_.shortValue());
            return this;
        }

        public LootItemFunction m_7453_() {
            return new Enchant(this.m_80699_(), this.enchants);
        }
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<Enchant> {
        public void serialize(JsonObject object, Enchant function, JsonSerializationContext ctx) {
            if (!function.enchantments.isEmpty()) {
                JsonObject obj = new JsonObject();
                for (Map.Entry<IRegistryDelegate<Enchantment>, Short> e : function.enchantments.entrySet()) {
                    obj.addProperty(((Enchantment)e.getKey().get()).getRegistryName().toString(), (Number)e.getValue());
                }
                object.add("enchantments", (JsonElement)obj);
            }
        }

        public Enchant deserialize(JsonObject object, JsonDeserializationContext ctx, LootItemCondition[] conditions) {
            HashMap<IRegistryDelegate<Enchantment>, Short> enchantments = new HashMap<IRegistryDelegate<Enchantment>, Short>();
            if (object.has("enchantments")) {
                JsonObject enchantObj = GsonHelper.m_13930_((JsonObject)object, (String)"enchantments");
                for (Map.Entry e : enchantObj.entrySet()) {
                    ResourceLocation id = new ResourceLocation((String)e.getKey());
                    if (!ForgeRegistries.ENCHANTMENTS.containsKey(id)) {
                        throw new JsonSyntaxException("Can't find enchantment " + (String)e.getKey());
                    }
                    Enchantment ench = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(id);
                    short lvl = ((JsonElement)e.getValue()).getAsShort();
                    for (IRegistryDelegate other : enchantments.keySet()) {
                        if (ench.m_44695_((Enchantment)other.get())) continue;
                        throw new JsonParseException(String.format("Enchantments %s and %s conflict", ench.getRegistryName(), ((Enchantment)other.get()).getRegistryName()));
                    }
                    enchantments.put((IRegistryDelegate<Enchantment>)ench.delegate, lvl);
                }
            }
            return new Enchant(conditions, enchantments);
        }
    }
}

