/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.compat.tcon.traits;

import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.util.FakePlayer;
import slimeknights.tconstruct.library.modifiers.impl.NoLevelsModifier;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import twilightforest.block.TFBlocks;
import twilightforest.item.TFItems;
import twilightforest.util.TFItemStackUtils;
import twilightforest.util.TwilightItemTier;

public class SynergyModifier
extends NoLevelsModifier {
    private static final float REPAIR_DAMPENER = 0.00390625f;

    public float getRepairFactor(IToolStackView toolStack, int level, float factor) {
        return super.getRepairFactor(toolStack, level, factor);
    }

    public void onInventoryTick(IToolStackView tool, int level, Level world, LivingEntity holder, int itemSlot, boolean isSelected, boolean isCorrectSlot, ItemStack stack) {
        if (!world.m_5776_() && holder instanceof Player) {
            Player player = (Player)holder;
            if (!(holder instanceof FakePlayer)) {
                if (!isCorrectSlot) {
                    return;
                }
                if (!SynergyModifier.needsRepair(tool)) {
                    return;
                }
                int healPower = 0;
                NonNullList playerInv = player.m_150109_().f_35974_;
                for (int i = 0; i < 9; ++i) {
                    if (i == itemSlot) continue;
                    ItemStack invSlot = (ItemStack)playerInv.get(i);
                    if (invSlot.m_150930_((Item)TFItems.STEELEAF_INGOT.get())) {
                        healPower += invSlot.m_41613_();
                        continue;
                    }
                    if (invSlot.m_150930_(((Block)TFBlocks.STEELEAF_BLOCK.get()).m_5456_())) {
                        healPower += invSlot.m_41613_() * 9;
                        continue;
                    }
                    if (!TFItemStackUtils.hasToolMaterial(invSlot, TwilightItemTier.STEELEAF)) continue;
                    ++healPower;
                }
                ToolDamageUtil.repair((IToolStackView)tool, (int)SynergyModifier.averageInt((float)healPower * 0.00390625f));
            }
        }
    }

    private static boolean needsRepair(IToolStackView tool) {
        return tool.getDamage() > 0 && !tool.isBroken();
    }

    private static int averageInt(float value) {
        double floor = Math.floor(value);
        double rem = (double)value - floor;
        return (int)floor + (Math.random() < rem ? 1 : 0);
    }
}

