/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.infrastructure.debugInfo;

import com.google.common.collect.ImmutableMap;
import com.jozufozu.flywheel.Flywheel;
import com.jozufozu.flywheel.backend.Backend;
import com.mojang.blaze3d.platform.GlUtil;
import com.simibubi.create.foundation.mixin.accessor.SystemReportAccessor;
import com.simibubi.create.infrastructure.debugInfo.element.DebugInfoSection;
import com.simibubi.create.infrastructure.debugInfo.element.InfoElement;
import com.simibubi.create.infrastructure.debugInfo.element.InfoEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.SystemReport;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModInfo;

public class DebugInformation {
    private static final List<DebugInfoSection> client = new ArrayList<DebugInfoSection>();
    private static final List<DebugInfoSection> server = new ArrayList<DebugInfoSection>();
    private static final ImmutableMap<String, String> mcSystemInfo = (ImmutableMap)Util.m_137537_(() -> {
        SystemReport systemReport = new SystemReport();
        SystemReportAccessor access = (SystemReportAccessor)systemReport;
        return ImmutableMap.copyOf(access.getEntries());
    });

    public static void registerClientInfo(DebugInfoSection section) {
        client.add(section);
    }

    public static void registerServerInfo(DebugInfoSection section) {
        server.add(section);
    }

    public static void registerBothInfo(DebugInfoSection section) {
        DebugInformation.registerClientInfo(section);
        DebugInformation.registerServerInfo(section);
    }

    public static List<DebugInfoSection> getClientInfo() {
        return client;
    }

    public static List<DebugInfoSection> getServerInfo() {
        return server;
    }

    public static String getVersionOfMod(String id) {
        return ModList.get().getModContainerById(id).map(mod -> mod.getModInfo().getVersion().toString()).orElse("None");
    }

    public static Collection<InfoElement> listAllOtherMods() {
        ArrayList<InfoElement> mods = new ArrayList<InfoElement>();
        ModList.get().forEachModContainer((id, mod) -> {
            if (!(id.equals("create") || id.equals("forge") || id.equals("minecraft") || id.equals("flywheel"))) {
                IModInfo info = mod.getModInfo();
                String name = info.getDisplayName();
                String version = info.getVersion().toString();
                mods.add(new InfoEntry(name, version));
            }
        });
        return mods;
    }

    public static Collection<InfoElement> listAllGraphicsCards() {
        ArrayList<InfoElement> cards = new ArrayList<InfoElement>();
        for (int i = 0; i < 10; ++i) {
            String name = DebugInformation.getMcSystemInfo("Graphics card #" + i + " name");
            String vendor = DebugInformation.getMcSystemInfo("Graphics card #" + i + " vendor");
            String vram = DebugInformation.getMcSystemInfo("Graphics card #" + i + " VRAM (MB)");
            if (name == null || vendor == null || vram == null) break;
            String key = "Graphics card #" + i;
            String value = String.format("%s (%s); %s MB of VRAM", name, vendor, vram);
            cards.add(new InfoEntry(key, value));
        }
        return cards.isEmpty() ? List.of(new InfoEntry("Graphics cards", "none")) : cards;
    }

    public static String getCpuInfo() {
        String name = DebugInformation.tryTrim(DebugInformation.getMcSystemInfo("Processor Name"));
        String freq = DebugInformation.getMcSystemInfo("Frequency (GHz)");
        String sockets = DebugInformation.getMcSystemInfo("Number of physical packages");
        String cores = DebugInformation.getMcSystemInfo("Number of physical CPUs");
        String threads = DebugInformation.getMcSystemInfo("Number of logical CPUs");
        return String.format("%s @ %s GHz; %s cores / %s threads on %s socket(s)", name, freq, cores, threads, sockets);
    }

    @Nullable
    public static String getMcSystemInfo(String key) {
        return (String)mcSystemInfo.get((Object)key);
    }

    public static String getIndent(int depth) {
        return Stream.generate(() -> "\t").limit(depth).collect(Collectors.joining());
    }

    @Nullable
    public static String tryTrim(@Nullable String s) {
        return s == null ? null : s.trim();
    }

    static {
        DebugInfoSection.builder("Create").put("Mod Version", "0.5.1f").put("Forge Version", DebugInformation.getVersionOfMod("forge")).put("Minecraft Version", SharedConstants.m_183709_().getName()).buildTo(DebugInformation::registerBothInfo);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> DebugInfoSection.builder("Graphics").put("Flywheel Version", Flywheel.getVersion().toString()).put("Flywheel Backend", () -> Backend.getBackendType().toString()).put("OpenGL Renderer", GlUtil::m_84820_).put("OpenGL Version", GlUtil::m_84821_).put("Graphics Mode", () -> Minecraft.m_91087_().f_91066_.f_92115_.toString()).buildTo(DebugInformation::registerClientInfo));
        DebugInfoSection.builder("System Information").put("Operating System", SystemReportAccessor.getOPERATING_SYSTEM()).put("Java Version", SystemReportAccessor.getJAVA_VERSION()).put("JVM Flags", DebugInformation.getMcSystemInfo("JVM Flags")).put("Memory", () -> DebugInformation.getMcSystemInfo("Memory")).put("CPU", DebugInformation.getCpuInfo()).putAll(DebugInformation.listAllGraphicsCards()).buildTo(DebugInformation::registerBothInfo);
        DebugInfoSection.builder("Other Mods").putAll(DebugInformation.listAllOtherMods()).buildTo(DebugInformation::registerBothInfo);
    }
}

