/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.item;

import com.google.common.base.Strings;
import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Lang;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraftforge.client.MinecraftForgeClient;

public class TooltipHelper {
    public static final int MAX_WIDTH_PER_LINE = 200;

    public static MutableComponent holdShift(Palette palette, boolean highlighted) {
        return Lang.translateDirect("tooltip.holdForDescription", Lang.translateDirect("tooltip.keyShift", new Object[0]).m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY);
    }

    public static void addHint(List<Component> tooltip, String hintKey, Object ... messageParams) {
        Component spacing = IHaveGoggleInformation.componentSpacing;
        tooltip.add((Component)spacing.m_6879_().m_7220_((Component)Lang.translateDirect(hintKey + ".title", new Object[0])).m_130940_(ChatFormatting.GOLD));
        MutableComponent hint = Lang.translateDirect(hintKey, new Object[0]);
        List<Component> cutComponent = TooltipHelper.cutTextComponent((Component)hint, Palette.GRAY_AND_WHITE);
        for (Component component : cutComponent) {
            tooltip.add((Component)spacing.m_6879_().m_7220_(component));
        }
    }

    public static String makeProgressBar(int length, int filledLength) {
        int i;
        Object bar = " ";
        int emptySpaces = length - filledLength;
        for (i = 0; i < filledLength; ++i) {
            bar = (String)bar + "\u2588";
        }
        for (i = 0; i < emptySpaces; ++i) {
            bar = (String)bar + "\u2592";
        }
        return (String)bar + " ";
    }

    public static Style styleFromColor(ChatFormatting color) {
        return Style.f_131099_.m_131157_(color);
    }

    public static Style styleFromColor(int hex) {
        return Style.f_131099_.m_178520_(hex);
    }

    public static List<Component> cutStringTextComponent(String s, Palette palette) {
        return TooltipHelper.cutTextComponent((Component)Components.literal(s), palette);
    }

    public static List<Component> cutTextComponent(Component c, Palette palette) {
        return TooltipHelper.cutTextComponent(c, palette.primary(), palette.highlight());
    }

    public static List<Component> cutStringTextComponent(String s, Style primaryStyle, Style highlightStyle) {
        return TooltipHelper.cutTextComponent((Component)Components.literal(s), primaryStyle, highlightStyle);
    }

    public static List<Component> cutTextComponent(Component c, Style primaryStyle, Style highlightStyle) {
        return TooltipHelper.cutTextComponent(c, primaryStyle, highlightStyle, 0);
    }

    public static List<Component> cutStringTextComponent(String c, Style primaryStyle, Style highlightStyle, int indent) {
        return TooltipHelper.cutTextComponent((Component)Components.literal(c), primaryStyle, highlightStyle, indent);
    }

    public static List<Component> cutTextComponent(Component c, Style primaryStyle, Style highlightStyle, int indent) {
        String s = c.getString();
        LinkedList<String> words = new LinkedList<String>();
        BreakIterator iterator = BreakIterator.getLineInstance(MinecraftForgeClient.getLocale());
        iterator.setText(s);
        int start = iterator.first();
        int end = iterator.next();
        while (end != -1) {
            String word = s.substring(start, end);
            words.add(word);
            start = end;
            end = iterator.next();
        }
        Font font = Minecraft.m_91087_().f_91062_;
        LinkedList<String> lines = new LinkedList<String>();
        StringBuilder currentLine = new StringBuilder();
        int width = 0;
        for (String word : words) {
            int newWidth = font.m_92895_(word.replaceAll("_", ""));
            if (width + newWidth > 200) {
                if (width > 0) {
                    String line = currentLine.toString();
                    lines.add(line);
                    currentLine = new StringBuilder();
                    width = 0;
                } else {
                    lines.add(word);
                    continue;
                }
            }
            currentLine.append(word);
            width += newWidth;
        }
        if (width > 0) {
            lines.add(currentLine.toString());
        }
        MutableComponent lineStart = Components.literal(Strings.repeat((String)" ", (int)indent));
        lineStart.m_130948_(primaryStyle);
        ArrayList<Component> formattedLines = new ArrayList<Component>(lines.size());
        Couple<Style> styles = Couple.create(highlightStyle, primaryStyle);
        boolean currentlyHighlighted = false;
        for (String string : lines) {
            String[] split;
            MutableComponent currentComponent = lineStart.m_6879_();
            for (String part : split = string.split("_")) {
                currentComponent.m_7220_((Component)Components.literal(part).m_130948_(styles.get(currentlyHighlighted)));
                currentlyHighlighted = !currentlyHighlighted;
            }
            formattedLines.add((Component)currentComponent);
            currentlyHighlighted = !currentlyHighlighted;
        }
        return formattedLines;
    }

    public record Palette(Style primary, Style highlight) {
        public static final Palette STANDARD_CREATE = new Palette(TooltipHelper.styleFromColor(13211468), TooltipHelper.styleFromColor(15850873));
        public static final Palette BLUE = Palette.ofColors(ChatFormatting.BLUE, ChatFormatting.AQUA);
        public static final Palette GREEN = Palette.ofColors(ChatFormatting.DARK_GREEN, ChatFormatting.GREEN);
        public static final Palette YELLOW = Palette.ofColors(ChatFormatting.GOLD, ChatFormatting.YELLOW);
        public static final Palette RED = Palette.ofColors(ChatFormatting.DARK_RED, ChatFormatting.RED);
        public static final Palette PURPLE = Palette.ofColors(ChatFormatting.DARK_PURPLE, ChatFormatting.LIGHT_PURPLE);
        public static final Palette GRAY = Palette.ofColors(ChatFormatting.DARK_GRAY, ChatFormatting.GRAY);
        public static final Palette ALL_GRAY = Palette.ofColors(ChatFormatting.GRAY, ChatFormatting.GRAY);
        public static final Palette GRAY_AND_BLUE = Palette.ofColors(ChatFormatting.GRAY, ChatFormatting.BLUE);
        public static final Palette GRAY_AND_WHITE = Palette.ofColors(ChatFormatting.GRAY, ChatFormatting.WHITE);
        public static final Palette GRAY_AND_GOLD = Palette.ofColors(ChatFormatting.GRAY, ChatFormatting.GOLD);
        public static final Palette GRAY_AND_RED = Palette.ofColors(ChatFormatting.GRAY, ChatFormatting.RED);

        public static Palette ofColors(ChatFormatting primary, ChatFormatting highlight) {
            return new Palette(TooltipHelper.styleFromColor(primary), TooltipHelper.styleFromColor(highlight));
        }
    }
}

