/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions;

import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllEntityTypes;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.ContraptionRelocationPacket;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.contraptions.bearing.StabilizedContraption;
import com.simibubi.create.content.contraptions.minecart.MinecartSim2020;
import com.simibubi.create.content.contraptions.minecart.capability.CapabilityMinecartController;
import com.simibubi.create.content.contraptions.minecart.capability.MinecartController;
import com.simibubi.create.content.contraptions.mounted.CartAssemblerBlockEntity;
import com.simibubi.create.content.contraptions.mounted.MountedContraption;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.MinecartFurnace;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public class OrientedContraptionEntity
extends AbstractContraptionEntity {
    private static final Ingredient FUEL_ITEMS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42413_, Items.f_42414_});
    private static final EntityDataAccessor<Optional<UUID>> COUPLING = SynchedEntityData.m_135353_(OrientedContraptionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Direction> INITIAL_ORIENTATION = SynchedEntityData.m_135353_(OrientedContraptionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135040_);
    protected Vec3 motionBeforeStall = Vec3.f_82478_;
    protected boolean forceAngle;
    private boolean isSerializingFurnaceCart = false;
    private boolean attachedExtraInventories = false;
    private boolean manuallyPlaced;
    public float prevYaw;
    public float yaw;
    public float targetYaw;
    public float prevPitch;
    public float pitch;
    public int nonDamageTicks = 10;

    public OrientedContraptionEntity(EntityType<?> type, Level world) {
        super(type, world);
    }

    public static OrientedContraptionEntity create(Level world, Contraption contraption, Direction initialOrientation) {
        OrientedContraptionEntity entity = new OrientedContraptionEntity((EntityType)AllEntityTypes.ORIENTED_CONTRAPTION.get(), world);
        entity.setContraption(contraption);
        entity.setInitialOrientation(initialOrientation);
        entity.startAtInitialYaw();
        return entity;
    }

    public static OrientedContraptionEntity createAtYaw(Level world, Contraption contraption, Direction initialOrientation, float initialYaw) {
        OrientedContraptionEntity entity = OrientedContraptionEntity.create(world, contraption, initialOrientation);
        entity.startAtYaw(initialYaw);
        entity.manuallyPlaced = true;
        return entity;
    }

    public void setInitialOrientation(Direction direction) {
        this.f_19804_.m_135381_(INITIAL_ORIENTATION, (Object)direction);
    }

    public Direction getInitialOrientation() {
        return (Direction)this.f_19804_.m_135370_(INITIAL_ORIENTATION);
    }

    @Override
    public float getYawOffset() {
        return this.getInitialYaw();
    }

    public float getInitialYaw() {
        return (this.isInitialOrientationPresent() ? (Direction)this.f_19804_.m_135370_(INITIAL_ORIENTATION) : Direction.SOUTH).m_122435_();
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(COUPLING, Optional.empty());
        this.f_19804_.m_135372_(INITIAL_ORIENTATION, (Object)Direction.UP);
    }

    @Override
    public AbstractContraptionEntity.ContraptionRotationState getRotationState() {
        AbstractContraptionEntity.ContraptionRotationState crs = new AbstractContraptionEntity.ContraptionRotationState();
        float yawOffset = this.getYawOffset();
        crs.zRotation = this.pitch;
        crs.yRotation = -this.yaw + yawOffset;
        if (this.pitch != 0.0f && this.yaw != 0.0f) {
            crs.secondYRotation = -this.yaw;
            crs.yRotation = yawOffset;
        }
        return crs;
    }

    public void m_8127_() {
        if (!this.f_19853_.f_46443_ && this.m_6084_()) {
            this.disassemble();
        }
        super.m_8127_();
    }

    @Override
    protected void readAdditional(CompoundTag compound, boolean spawnPacket) {
        ListTag vecNBT;
        super.readAdditional(compound, spawnPacket);
        if (compound.m_128441_("InitialOrientation")) {
            this.setInitialOrientation(NBTHelper.readEnum(compound, "InitialOrientation", Direction.class));
        }
        this.yaw = compound.m_128457_("Yaw");
        this.pitch = compound.m_128457_("Pitch");
        this.manuallyPlaced = compound.m_128471_("Placed");
        if (compound.m_128441_("ForceYaw")) {
            this.startAtYaw(compound.m_128457_("ForceYaw"));
        }
        if (!(vecNBT = compound.m_128437_("CachedMotion", 6)).isEmpty()) {
            this.motionBeforeStall = new Vec3(vecNBT.m_128772_(0), vecNBT.m_128772_(1), vecNBT.m_128772_(2));
            if (!this.motionBeforeStall.equals((Object)Vec3.f_82478_)) {
                this.prevYaw = this.yaw += OrientedContraptionEntity.yawFromVector(this.motionBeforeStall);
                this.targetYaw = this.yaw;
            }
            this.m_20256_(Vec3.f_82478_);
        }
        this.setCouplingId(compound.m_128441_("OnCoupling") ? compound.m_128342_("OnCoupling") : null);
    }

    @Override
    protected void writeAdditional(CompoundTag compound, boolean spawnPacket) {
        Direction optional;
        super.writeAdditional(compound, spawnPacket);
        if (this.motionBeforeStall != null) {
            compound.m_128365_("CachedMotion", (Tag)this.m_20063_(new double[]{this.motionBeforeStall.f_82479_, this.motionBeforeStall.f_82480_, this.motionBeforeStall.f_82481_}));
        }
        if ((optional = (Direction)this.f_19804_.m_135370_(INITIAL_ORIENTATION)).m_122434_().m_122479_()) {
            NBTHelper.writeEnum(compound, "InitialOrientation", optional);
        }
        if (this.forceAngle) {
            compound.m_128350_("ForceYaw", this.yaw);
            this.forceAngle = false;
        }
        compound.m_128379_("Placed", this.manuallyPlaced);
        compound.m_128350_("Yaw", this.yaw);
        compound.m_128350_("Pitch", this.pitch);
        if (this.getCouplingId() != null) {
            compound.m_128362_("OnCoupling", this.getCouplingId());
        }
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        super.m_7350_(key);
        if (INITIAL_ORIENTATION.equals(key) && this.isInitialOrientationPresent() && !this.manuallyPlaced) {
            this.startAtInitialYaw();
        }
    }

    public boolean isInitialOrientationPresent() {
        return ((Direction)this.f_19804_.m_135370_(INITIAL_ORIENTATION)).m_122434_().m_122479_();
    }

    public void startAtInitialYaw() {
        this.startAtYaw(this.getInitialYaw());
    }

    public void startAtYaw(float yaw) {
        this.yaw = this.prevYaw = yaw;
        this.targetYaw = this.prevYaw;
        this.forceAngle = true;
    }

    @Override
    public Vec3 applyRotation(Vec3 localPos, float partialTicks) {
        localPos = VecHelper.rotate(localPos, this.getInitialYaw(), Direction.Axis.Y);
        localPos = VecHelper.rotate(localPos, this.m_5686_(partialTicks), Direction.Axis.Z);
        localPos = VecHelper.rotate(localPos, this.m_5675_(partialTicks), Direction.Axis.Y);
        return localPos;
    }

    @Override
    public Vec3 reverseRotation(Vec3 localPos, float partialTicks) {
        localPos = VecHelper.rotate(localPos, -this.m_5675_(partialTicks), Direction.Axis.Y);
        localPos = VecHelper.rotate(localPos, -this.m_5686_(partialTicks), Direction.Axis.Z);
        localPos = VecHelper.rotate(localPos, -this.getInitialYaw(), Direction.Axis.Y);
        return localPos;
    }

    public float m_5675_(float partialTicks) {
        return -(partialTicks == 1.0f ? this.yaw : AngleHelper.angleLerp(partialTicks, this.prevYaw, this.yaw));
    }

    public float m_5686_(float partialTicks) {
        return partialTicks == 1.0f ? this.pitch : AngleHelper.angleLerp(partialTicks, this.prevPitch, this.pitch);
    }

    @Override
    protected void tickContraption() {
        boolean rotating;
        Entity e;
        if (this.nonDamageTicks > 0) {
            --this.nonDamageTicks;
        }
        if ((e = this.m_20202_()) == null) {
            return;
        }
        boolean rotationLock = false;
        boolean pauseWhileRotating = false;
        boolean wasStalled = this.isStalled();
        if (this.contraption instanceof MountedContraption) {
            MountedContraption mountedContraption = (MountedContraption)this.contraption;
            rotationLock = mountedContraption.rotationMode == CartAssemblerBlockEntity.CartMovementMode.ROTATION_LOCKED;
            pauseWhileRotating = mountedContraption.rotationMode == CartAssemblerBlockEntity.CartMovementMode.ROTATE_PAUSED;
        }
        Entity riding = e;
        while (riding.m_20202_() != null && !(this.contraption instanceof StabilizedContraption)) {
            riding = riding.m_20202_();
        }
        boolean isOnCoupling = false;
        UUID couplingId = this.getCouplingId();
        boolean bl = isOnCoupling = couplingId != null && riding instanceof AbstractMinecart;
        if (!this.attachedExtraInventories) {
            this.attachInventoriesFromRidingCarts(riding, isOnCoupling, couplingId);
            this.attachedExtraInventories = true;
        }
        if (!(rotating = this.updateOrientation(rotationLock, wasStalled, riding, isOnCoupling)) || !pauseWhileRotating) {
            this.tickActors();
        }
        boolean isStalled = this.isStalled();
        LazyOptional capability = riding.getCapability(CapabilityMinecartController.MINECART_CONTROLLER_CAPABILITY);
        if (capability.isPresent()) {
            if (!this.f_19853_.m_5776_()) {
                ((MinecartController)capability.orElse(null)).setStalledExternally(isStalled);
            }
        } else {
            if (isStalled) {
                if (!wasStalled) {
                    this.motionBeforeStall = riding.m_20184_();
                }
                riding.m_20334_(0.0, 0.0, 0.0);
            }
            if (wasStalled && !isStalled) {
                riding.m_20256_(this.motionBeforeStall);
                this.motionBeforeStall = Vec3.f_82478_;
            }
        }
        if (this.f_19853_.f_46443_) {
            return;
        }
        if (!this.isStalled()) {
            if (isOnCoupling) {
                Couple<MinecartController> coupledCarts = this.getCoupledCartsIfPresent();
                if (coupledCarts == null) {
                    return;
                }
                coupledCarts.map(MinecartController::cart).forEach(this::powerFurnaceCartWithFuelFromStorage);
                return;
            }
            this.powerFurnaceCartWithFuelFromStorage(riding);
        }
    }

    protected boolean updateOrientation(boolean rotationLock, boolean wasStalled, Entity riding, boolean isOnCoupling) {
        if (isOnCoupling) {
            Couple<MinecartController> coupledCarts = this.getCoupledCartsIfPresent();
            if (coupledCarts == null) {
                return false;
            }
            Vec3 positionVec = ((MinecartController)coupledCarts.getFirst()).cart().m_20182_();
            Vec3 coupledVec = ((MinecartController)coupledCarts.getSecond()).cart().m_20182_();
            double diffX = positionVec.f_82479_ - coupledVec.f_82479_;
            double diffY = positionVec.f_82480_ - coupledVec.f_82480_;
            double diffZ = positionVec.f_82481_ - coupledVec.f_82481_;
            this.prevYaw = this.yaw;
            this.prevPitch = this.pitch;
            this.yaw = (float)(Mth.m_14136_((double)diffZ, (double)diffX) * 180.0 / Math.PI);
            this.pitch = (float)(Math.atan2(diffY, Math.sqrt(diffX * diffX + diffZ * diffZ)) * 180.0 / Math.PI);
            if (this.getCouplingId().equals(riding.m_142081_())) {
                this.pitch *= -1.0f;
                this.yaw += 180.0f;
            }
            return false;
        }
        if (this.contraption instanceof StabilizedContraption) {
            if (!(riding instanceof OrientedContraptionEntity)) {
                return false;
            }
            StabilizedContraption stabilized = (StabilizedContraption)this.contraption;
            Direction facing = stabilized.getFacing();
            if (facing.m_122434_().m_122478_()) {
                return false;
            }
            OrientedContraptionEntity parent = (OrientedContraptionEntity)riding;
            this.prevYaw = this.yaw;
            this.yaw = -parent.m_5675_(1.0f);
            return false;
        }
        this.prevYaw = this.yaw;
        if (wasStalled) {
            return false;
        }
        boolean rotating = false;
        Vec3 movementVector = riding.m_20184_();
        Vec3 locationDiff = riding.m_20182_().m_82492_(riding.f_19854_, riding.f_19855_, riding.f_19856_);
        if (!(riding instanceof AbstractMinecart)) {
            movementVector = locationDiff;
        }
        Vec3 motion = movementVector.m_82541_();
        if (!rotationLock) {
            AbstractMinecart minecartEntity;
            BlockPos railPosition;
            BlockState blockState;
            if (riding instanceof AbstractMinecart && (blockState = this.f_19853_.m_8055_(railPosition = (minecartEntity = (AbstractMinecart)riding).getCurrentRailPosition())).m_60734_() instanceof BaseRailBlock) {
                BaseRailBlock abstractRailBlock = (BaseRailBlock)blockState.m_60734_();
                RailShape railDirection = abstractRailBlock.getRailDirection(blockState, (BlockGetter)this.f_19853_, railPosition, minecartEntity);
                motion = VecHelper.project(motion, MinecartSim2020.getRailVec(railDirection));
            }
            if (motion.m_82553_() > 0.0) {
                this.targetYaw = OrientedContraptionEntity.yawFromVector(motion);
                if (this.targetYaw < 0.0f) {
                    this.targetYaw += 360.0f;
                }
                if (this.yaw < 0.0f) {
                    this.yaw += 360.0f;
                }
            }
            this.prevYaw = this.yaw;
            float maxApproachSpeed = (float)(motion.m_82553_() * 12.0 / Math.max(1.0, this.m_142469_().m_82362_() / 6.0));
            float yawHint = AngleHelper.getShortestAngleDiff(this.yaw, OrientedContraptionEntity.yawFromVector(locationDiff));
            float approach = AngleHelper.getShortestAngleDiff(this.yaw, this.targetYaw, yawHint);
            approach = Mth.m_14036_((float)approach, (float)(-maxApproachSpeed), (float)maxApproachSpeed);
            this.yaw += approach;
            if (Math.abs(AngleHelper.getShortestAngleDiff(this.yaw, this.targetYaw)) < 1.0f) {
                this.yaw = this.targetYaw;
            } else {
                rotating = true;
            }
        }
        return rotating;
    }

    protected void powerFurnaceCartWithFuelFromStorage(Entity riding) {
        ItemStack coal;
        int k;
        int j;
        int fuel;
        if (!(riding instanceof MinecartFurnace)) {
            return;
        }
        MinecartFurnace furnaceCart = (MinecartFurnace)riding;
        this.isSerializingFurnaceCart = true;
        CompoundTag nbt = furnaceCart.serializeNBT();
        this.isSerializingFurnaceCart = false;
        int fuelBefore = fuel = nbt.m_128451_("Fuel");
        double pushX = nbt.m_128459_("PushX");
        double pushZ = nbt.m_128459_("PushZ");
        int i = Mth.m_14107_((double)furnaceCart.m_20185_());
        if (furnaceCart.f_19853_.m_8055_(new BlockPos(i, (j = Mth.m_14107_((double)furnaceCart.m_20186_())) - 1, k = Mth.m_14107_((double)furnaceCart.m_20189_()))).m_204336_(BlockTags.f_13034_)) {
            --j;
        }
        BlockPos blockpos = new BlockPos(i, j, k);
        BlockState blockstate = this.f_19853_.m_8055_(blockpos);
        if (furnaceCart.canUseRail() && blockstate.m_204336_(BlockTags.f_13034_) && fuel > 1) {
            riding.m_20256_(riding.m_20184_().m_82541_().m_82490_(1.0));
        }
        if (fuel < 5 && this.contraption != null && !(coal = ItemHelper.extract((IItemHandler)this.contraption.getSharedInventory(), (Predicate<ItemStack>)FUEL_ITEMS, 1, false)).m_41619_()) {
            fuel += 3600;
        }
        if (fuel != fuelBefore || pushX != 0.0 || pushZ != 0.0) {
            nbt.m_128405_("Fuel", fuel);
            nbt.m_128347_("PushX", 0.0);
            nbt.m_128347_("PushZ", 0.0);
            furnaceCart.deserializeNBT(nbt);
        }
    }

    @Nullable
    public Couple<MinecartController> getCoupledCartsIfPresent() {
        UUID couplingId = this.getCouplingId();
        if (couplingId == null) {
            return null;
        }
        MinecartController controller = CapabilityMinecartController.getIfPresent(this.f_19853_, couplingId);
        if (controller == null || !controller.isPresent()) {
            return null;
        }
        UUID coupledCart = controller.getCoupledCart(true);
        MinecartController coupledController = CapabilityMinecartController.getIfPresent(this.f_19853_, coupledCart);
        if (coupledController == null || !coupledController.isPresent()) {
            return null;
        }
        return Couple.create(controller, coupledController);
    }

    protected void attachInventoriesFromRidingCarts(Entity riding, boolean isOnCoupling, UUID couplingId) {
        Contraption contraption = this.contraption;
        if (!(contraption instanceof MountedContraption)) {
            return;
        }
        MountedContraption mc = (MountedContraption)contraption;
        if (!isOnCoupling) {
            mc.addExtraInventories(riding);
            return;
        }
        Couple<MinecartController> coupledCarts = this.getCoupledCartsIfPresent();
        if (coupledCarts == null) {
            return;
        }
        coupledCarts.map(MinecartController::cart).forEach(mc::addExtraInventories);
    }

    @Override
    public CompoundTag m_20240_(CompoundTag nbt) {
        return this.isSerializingFurnaceCart ? nbt : super.m_20240_(nbt);
    }

    @Nullable
    public UUID getCouplingId() {
        Optional uuid = (Optional)this.f_19804_.m_135370_(COUPLING);
        return uuid == null ? null : (uuid.isPresent() ? (UUID)uuid.get() : null);
    }

    public void setCouplingId(UUID id) {
        this.f_19804_.m_135381_(COUPLING, Optional.ofNullable(id));
    }

    @Override
    public Vec3 getAnchorVec() {
        Vec3 anchorVec = super.getAnchorVec();
        return anchorVec.m_82492_(0.5, 0.0, 0.5);
    }

    @Override
    public Vec3 getPrevAnchorVec() {
        Vec3 prevAnchorVec = super.getPrevAnchorVec();
        return prevAnchorVec.m_82492_(0.5, 0.0, 0.5);
    }

    @Override
    protected StructureTransform makeStructureTransform() {
        BlockPos offset = new BlockPos(this.getAnchorVec().m_82520_(0.5, 0.5, 0.5));
        return new StructureTransform(offset, 0.0f, -this.yaw + this.getInitialYaw(), 0.0f);
    }

    @Override
    protected float getStalledAngle() {
        return this.yaw;
    }

    @Override
    protected void handleStallInformation(double x, double y, double z, float angle) {
        this.yaw = angle;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void applyLocalTransforms(PoseStack matrixStack, float partialTicks) {
        float angleInitialYaw = this.getInitialYaw();
        float angleYaw = this.m_5675_(partialTicks);
        float anglePitch = this.m_5686_(partialTicks);
        matrixStack.m_85837_(-0.5, 0.0, -0.5);
        Entity ridingEntity = this.m_20202_();
        if (ridingEntity instanceof AbstractMinecart) {
            this.repositionOnCart(matrixStack, partialTicks, ridingEntity);
        } else if (ridingEntity instanceof AbstractContraptionEntity) {
            if (ridingEntity.m_20202_() instanceof AbstractMinecart) {
                this.repositionOnCart(matrixStack, partialTicks, ridingEntity.m_20202_());
            } else {
                this.repositionOnContraption(matrixStack, partialTicks, ridingEntity);
            }
        }
        ((TransformStack)((TransformStack)((TransformStack)((TransformStack)((TransformStack)TransformStack.cast((PoseStack)matrixStack).nudge(this.m_142049_())).centre()).rotateY((double)angleYaw)).rotateZ((double)anglePitch)).rotateY((double)angleInitialYaw)).unCentre();
    }

    @OnlyIn(value=Dist.CLIENT)
    private void repositionOnContraption(PoseStack matrixStack, float partialTicks, Entity ridingEntity) {
        Vec3 pos = this.getContraptionOffset(partialTicks, ridingEntity);
        matrixStack.m_85837_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void repositionOnCart(PoseStack matrixStack, float partialTicks, Entity ridingEntity) {
        Vec3 cartPos = this.getCartOffset(partialTicks, ridingEntity);
        if (cartPos == Vec3.f_82478_) {
            return;
        }
        matrixStack.m_85837_(cartPos.f_82479_, cartPos.f_82480_, cartPos.f_82481_);
    }

    @OnlyIn(value=Dist.CLIENT)
    private Vec3 getContraptionOffset(float partialTicks, Entity ridingEntity) {
        AbstractContraptionEntity parent = (AbstractContraptionEntity)ridingEntity;
        Vec3 passengerPosition = parent.getPassengerPosition(this, partialTicks);
        if (passengerPosition == null) {
            return Vec3.f_82478_;
        }
        double x = passengerPosition.f_82479_ - Mth.m_14139_((double)partialTicks, (double)this.f_19790_, (double)this.m_20185_());
        double y = passengerPosition.f_82480_ - Mth.m_14139_((double)partialTicks, (double)this.f_19791_, (double)this.m_20186_());
        double z = passengerPosition.f_82481_ - Mth.m_14139_((double)partialTicks, (double)this.f_19792_, (double)this.m_20189_());
        return new Vec3(x, y, z);
    }

    @OnlyIn(value=Dist.CLIENT)
    private Vec3 getCartOffset(float partialTicks, Entity ridingEntity) {
        double cartZ;
        double cartY;
        AbstractMinecart cart = (AbstractMinecart)ridingEntity;
        double cartX = Mth.m_14139_((double)partialTicks, (double)cart.f_19790_, (double)cart.m_20185_());
        Vec3 cartPos = cart.m_38179_(cartX, cartY = Mth.m_14139_((double)partialTicks, (double)cart.f_19791_, (double)cart.m_20186_()), cartZ = Mth.m_14139_((double)partialTicks, (double)cart.f_19792_, (double)cart.m_20189_()));
        if (cartPos != null) {
            Vec3 cartPosFront = cart.m_38096_(cartX, cartY, cartZ, (double)0.3f);
            Vec3 cartPosBack = cart.m_38096_(cartX, cartY, cartZ, (double)-0.3f);
            if (cartPosFront == null) {
                cartPosFront = cartPos;
            }
            if (cartPosBack == null) {
                cartPosBack = cartPos;
            }
            cartX = cartPos.f_82479_ - cartX;
            cartY = (cartPosFront.f_82480_ + cartPosBack.f_82480_) / 2.0 - cartY;
            cartZ = cartPos.f_82481_ - cartZ;
            return new Vec3(cartX, cartY, cartZ);
        }
        return Vec3.f_82478_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void handleRelocationPacket(ContraptionRelocationPacket packet) {
        Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(packet.entityID);
        if (entity instanceof OrientedContraptionEntity) {
            OrientedContraptionEntity oce = (OrientedContraptionEntity)entity;
            oce.nonDamageTicks = 10;
        }
    }
}

