/*
 * Decompiled with CFR 0.152.
 */
package de.mari_023.ae2wtlib.forge;

import appeng.menu.locator.MenuLocator;
import de.mari_023.ae2wtlib.AE2wtlib;
import de.mari_023.ae2wtlib.forge.AE2wtlibForge;
import de.mari_023.ae2wtlib.forge.curio.CurioHelper;
import de.mari_023.ae2wtlib.forge.recipes.ForgeCombineSerializer;
import de.mari_023.ae2wtlib.forge.recipes.ForgeUpgradeSerializer;
import de.mari_023.ae2wtlib.wut.recipe.Combine;
import de.mari_023.ae2wtlib.wut.recipe.Upgrade;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fml.ModList;
import org.jetbrains.annotations.Nullable;

public class PlatformImpl {
    public static boolean trinketsPresent() {
        return ModList.get().isLoaded("curios");
    }

    public static boolean isStillPresentTrinkets(Player player, ItemStack terminal) {
        return CurioHelper.isStillPresent(player, terminal);
    }

    public static ItemStack getItemStackFromTrinketsLocator(Player player, MenuLocator locator) {
        return CurioHelper.getItemStack(player, locator);
    }

    @Nullable
    public static MenuLocator findTerminalFromAccessory(Player player, String terminalName) {
        if (PlatformImpl.trinketsPresent()) {
            return CurioHelper.findTerminal(player, terminalName);
        }
        return null;
    }

    public static CreativeModeTab getCreativeModeTab() {
        return new CreativeModeTab("ae2wtlib"){

            public ItemStack m_6976_() {
                return new ItemStack((ItemLike)AE2wtlib.UNIVERSAL_TERMINAL);
            }
        };
    }

    public static void registerItem(String name, Item item) {
        AE2wtlibForge.ITEMS.register(name, () -> item);
    }

    private static void registerRecipe(String name, RecipeSerializer<?> serializer) {
        AE2wtlibForge.RECIPES.register(name, () -> serializer);
    }

    public static void registerRecipes() {
        Upgrade.serializer = new ForgeUpgradeSerializer();
        PlatformImpl.registerRecipe("upgrade", Upgrade.serializer);
        Combine.serializer = new ForgeCombineSerializer();
        PlatformImpl.registerRecipe("combine", Combine.serializer);
    }

    public static boolean preventRemoteMovement(ItemEntity item) {
        return item.getPersistentData().m_128441_("PreventRemoteMovement");
    }
}

