/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.defense;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.data.ModifierMaxLevel;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.utils.TooltipKey;
import slimeknights.tconstruct.tools.modifiers.defense.AbstractProtectionModifier;

public class BlastProtectionModifier
extends AbstractProtectionModifier<BlastData> {
    private static final TinkerDataCapability.TinkerDataKey<BlastData> BLAST_DATA = TConstruct.createKey("blast_protection");

    public BlastProtectionModifier() {
        super(BLAST_DATA);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, ExplosionEvent.Detonate.class, BlastProtectionModifier::onExplosionDetonate);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, LivingEvent.LivingUpdateEvent.class, BlastProtectionModifier::livingTick);
    }

    @Override
    public float getProtectionModifier(IToolStackView tool, int level, EquipmentContext context, EquipmentSlot slotType, DamageSource source, float modifierValue) {
        if (!source.m_19379_() && !source.m_19378_() && source.m_19372_()) {
            modifierValue += this.getScaledLevel(tool, level) * 2.5f;
        }
        return modifierValue;
    }

    @Override
    public void addInformation(IToolStackView tool, int level, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        AbstractProtectionModifier.addResistanceTooltip(this, tool, level, 2.5f, tooltip);
    }

    @Override
    protected BlastData createData() {
        return new BlastData();
    }

    @Override
    protected void reset(BlastData data) {
        data.wasKnockback = false;
    }

    private static void onExplosionDetonate(ExplosionEvent.Detonate event) {
        Explosion explosion = event.getExplosion();
        Vec3 center = explosion.getPosition();
        float diameter = explosion.f_46017_ * 2.0f;
        for (Entity entity : event.getAffectedEntities()) {
            if (entity.m_6128_()) continue;
            entity.getCapability(TinkerDataCapability.CAPABILITY).ifPresent(data -> {
                BlastData blastData = data.get(BLAST_DATA);
                if (blastData != null && blastData.getMax() > 0.0f) {
                    double y;
                    double distance;
                    double x = entity.m_20185_() - center.f_82479_;
                    double z = entity.m_20189_() - center.f_82481_;
                    if ((x != 0.0 || z != 0.0 || entity.m_20188_() - center.f_82480_ != 0.0) && (distance = (double)(Mth.m_14116_((float)((float)(x * x + (y = entity.m_20186_() - center.f_82480_) * y + z * z))) / diameter)) <= 1.0) {
                        blastData.wasKnockback = true;
                    }
                }
            });
        }
    }

    private static void livingTick(LivingEvent.LivingUpdateEvent event) {
        LivingEntity living = event.getEntityLiving();
        if (!living.f_19853_.f_46443_ && !living.m_5833_()) {
            living.getCapability(TinkerDataCapability.CAPABILITY).ifPresent(data -> {
                BlastData blastData = data.get(BLAST_DATA);
                if (blastData != null && blastData.wasKnockback) {
                    blastData.wasKnockback = false;
                    float max = blastData.getMax();
                    if (max > 0.0f) {
                        double scale = 1.0f - blastData.getMax() * 0.15f;
                        if (scale <= 0.0) {
                            living.m_20256_(Vec3.f_82478_);
                        } else {
                            living.m_20256_(living.m_20184_().m_82542_(scale, scale, scale));
                        }
                        living.f_19864_ = true;
                    }
                }
            });
        }
    }

    protected static class BlastData
    extends ModifierMaxLevel {
        boolean wasKnockback = false;

        protected BlastData() {
        }
    }
}

