/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.item;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import slimeknights.tconstruct.smeltery.block.entity.component.TankBlockEntity;
import slimeknights.tconstruct.smeltery.item.TankItem;

public class TankItemFluidHandler
implements IFluidHandlerItem,
ICapabilityProvider {
    private final LazyOptional<IFluidHandlerItem> holder = LazyOptional.of(() -> this);
    private final ItemStack container;

    private FluidTank getTank() {
        return TankItem.getFluidTank(this.container);
    }

    private void updateContainer(FluidTank tank) {
        TankItem.setTank(this.container, tank);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        return CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY.orEmpty(cap, this.holder);
    }

    public int getTanks() {
        return 1;
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        return this.getTank().getFluidInTank(tank);
    }

    public int getTankCapacity(int tank) {
        return TankBlockEntity.getCapacity(this.container.m_41720_());
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return true;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        FluidTank tank = this.getTank();
        int didFill = tank.fill(resource, action);
        if (didFill > 0 && action.execute()) {
            this.updateContainer(tank);
        }
        return didFill;
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        FluidTank tank = this.getTank();
        FluidStack didDrain = tank.drain(resource, action);
        if (!didDrain.isEmpty() && action.execute()) {
            this.updateContainer(tank);
        }
        return didDrain;
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        FluidTank tank = this.getTank();
        FluidStack didDrain = tank.drain(maxDrain, action);
        if (!didDrain.isEmpty() && action.execute()) {
            this.updateContainer(tank);
        }
        return didDrain;
    }

    public TankItemFluidHandler(ItemStack container) {
        this.container = container;
    }

    public ItemStack getContainer() {
        return this.container;
    }
}

