/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block.controller;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import slimeknights.mantle.block.RetexturedBlock;
import slimeknights.mantle.util.BlockEntityHelper;
import slimeknights.tconstruct.common.network.TinkerNetwork;
import slimeknights.tconstruct.smeltery.block.controller.ControllerBlock;
import slimeknights.tconstruct.smeltery.block.entity.controller.HeatingStructureBlockEntity;
import slimeknights.tconstruct.smeltery.block.entity.multiblock.MultiblockResult;
import slimeknights.tconstruct.smeltery.network.StructureErrorPositionPacket;

public abstract class HeatingControllerBlock
extends ControllerBlock {
    protected HeatingControllerBlock(BlockBehaviour.Properties builder) {
        super(builder);
    }

    @Override
    protected boolean openGui(Player player, Level world, BlockPos pos) {
        super.openGui(player, world, pos);
        if (!world.f_46443_) {
            BlockEntityHelper.get(HeatingStructureBlockEntity.class, (BlockGetter)world, (BlockPos)pos).ifPresent(te -> {
                MultiblockResult result = te.getStructureResult();
                if (!result.isSuccess() && te.showDebugBlockBorder(player)) {
                    TinkerNetwork.getInstance().sendTo(new StructureErrorPositionPacket(pos, result.getPos()), player);
                }
            });
        }
        return true;
    }

    @Override
    protected boolean displayStatus(Player player, Level world, BlockPos pos, BlockState state) {
        if (!world.f_46443_) {
            BlockEntityHelper.get(HeatingStructureBlockEntity.class, (BlockGetter)world, (BlockPos)pos).ifPresent(te -> {
                MultiblockResult result = te.getStructureResult();
                if (!result.isSuccess()) {
                    player.m_5661_(result.getMessage(), true);
                    TinkerNetwork.getInstance().sendTo(new StructureErrorPositionPacket(pos, result.getPos()), player);
                }
            });
        }
        return true;
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(world, pos, state, placer, stack);
        RetexturedBlock.updateTextureBlock((Level)world, (BlockPos)pos, (ItemStack)stack);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        return RetexturedBlock.getPickBlock((BlockGetter)world, (BlockPos)pos, (BlockState)state);
    }
}

