/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block.controller;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import slimeknights.mantle.block.InventoryBlock;
import slimeknights.tconstruct.smeltery.block.component.SearedBlock;

public abstract class ControllerBlock
extends InventoryBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty ACTIVE = BooleanProperty.m_61465_((String)"active");
    public static final BooleanProperty IN_STRUCTURE = SearedBlock.IN_STRUCTURE;

    protected ControllerBlock(BlockBehaviour.Properties builder) {
        super(builder);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)IN_STRUCTURE, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, ACTIVE, IN_STRUCTURE});
    }

    @Nullable
    public BlockPathTypes getAiPathNodeType(BlockState state, BlockGetter world, BlockPos pos, @Nullable Mob entity) {
        return (Boolean)state.m_61143_((Property)IN_STRUCTURE) != false ? BlockPathTypes.DAMAGE_FIRE : BlockPathTypes.OPEN;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    @Deprecated
    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @Deprecated
    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)mirror.m_54848_((Direction)state.m_61143_((Property)FACING)));
    }

    protected boolean canOpenGui(BlockState state) {
        return (Boolean)state.m_61143_((Property)IN_STRUCTURE);
    }

    protected boolean displayStatus(Player player, Level world, BlockPos pos, BlockState state) {
        return false;
    }

    protected boolean openGui(Player player, Level world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        if (state.m_60734_() == this) {
            if (this.canOpenGui(state)) {
                return super.openGui(player, world, pos);
            }
            return this.displayStatus(player, world, pos, state);
        }
        return false;
    }

    protected void spawnFireParticles(LevelAccessor world, BlockState state, double x, double y, double z, double front, double side) {
        this.spawnFireParticles(world, state, x, y, z, front, side, (ParticleOptions)ParticleTypes.f_123744_);
    }

    protected void spawnFireParticles(LevelAccessor world, BlockState state, double x, double y, double z, double front, double side, ParticleOptions particle) {
        switch ((Direction)state.m_61143_((Property)FACING)) {
            case WEST: {
                world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x - front, y, z + side, 0.0, 0.0, 0.0);
                world.m_7106_(particle, x - front, y, z + side, 0.0, 0.0, 0.0);
                break;
            }
            case EAST: {
                world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x + front, y, z + side, 0.0, 0.0, 0.0);
                world.m_7106_(particle, x + front, y, z + side, 0.0, 0.0, 0.0);
                break;
            }
            case NORTH: {
                world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x + side, y, z - front, 0.0, 0.0, 0.0);
                world.m_7106_(particle, x + side, y, z - front, 0.0, 0.0, 0.0);
                break;
            }
            case SOUTH: {
                world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x + side, y, z + front, 0.0, 0.0, 0.0);
                world.m_7106_(particle, x + side, y, z + front, 0.0, 0.0, 0.0);
            }
        }
    }
}

