/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.tinkerstation.repairing;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.recipe.modifiers.adding.IncrementalModifierRecipe;
import slimeknights.tconstruct.library.recipe.tinkerstation.IMutableTinkerStationContainer;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationContainer;
import slimeknights.tconstruct.library.recipe.tinkerstation.ITinkerStationRecipe;
import slimeknights.tconstruct.library.recipe.tinkerstation.ValidatedResult;
import slimeknights.tconstruct.library.recipe.tinkerstation.repairing.ModifierRepairRecipeSerializer;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class ModifierRepairTinkerStationRecipe
implements ITinkerStationRecipe,
ModifierRepairRecipeSerializer.IModifierRepairRecipe {
    private final ResourceLocation id;
    private final ModifierId modifier;
    private final Ingredient ingredient;
    private final int repairAmount;

    @Override
    public boolean matches(ITinkerStationContainer inv, Level world) {
        ItemStack tinkerable = inv.getTinkerableStack();
        if (!tinkerable.m_204117_(TinkerTags.Items.DURABILITY)) {
            return false;
        }
        ToolStack tool = ToolStack.from(tinkerable);
        if (tool.getModifierLevel(this.modifier) == 0) {
            return false;
        }
        return IncrementalModifierRecipe.containsOnlyIngredient(inv, this.ingredient);
    }

    @Override
    public ValidatedResult getValidatedResult(ITinkerStationContainer inv) {
        ToolStack tool = ToolStack.from(inv.getTinkerableStack());
        int amountPerItem = tool.getModifierLevel(this.modifier) * this.repairAmount;
        if (amountPerItem <= 0) {
            return ValidatedResult.PASS;
        }
        float repairFactor = 1.0f;
        for (ModifierEntry entry : tool.getModifierList()) {
            repairFactor = entry.getModifier().getRepairFactor(tool, entry.getLevel(), repairFactor);
            if (!(repairFactor <= 0.0f)) continue;
            return ValidatedResult.PASS;
        }
        int available = IncrementalModifierRecipe.getAvailableAmount(inv, this.ingredient, amountPerItem = (int)((float)amountPerItem * repairFactor));
        if (available <= 0) {
            return ValidatedResult.PASS;
        }
        tool = tool.copy();
        ToolDamageUtil.repair(tool, available);
        return ValidatedResult.success(tool.createStack());
    }

    @Override
    public int shrinkToolSlotBy() {
        return 1;
    }

    @Override
    public void updateInputs(ItemStack result, IMutableTinkerStationContainer inv, boolean isServer) {
        ToolStack tool = ToolStack.from(inv.getTinkerableStack());
        float repairFactor = 1.0f;
        for (ModifierEntry entry : tool.getModifierList()) {
            repairFactor = entry.getModifier().getRepairFactor(tool, entry.getLevel(), repairFactor);
            if (!(repairFactor <= 0.0f)) continue;
            return;
        }
        int amountPerItem = (int)((float)(tool.getModifierLevel(this.modifier) * this.repairAmount) * repairFactor);
        if (amountPerItem < 0) {
            return;
        }
        int repairRemaining = tool.getDamage() - ToolStack.from(result).getDamage();
        IncrementalModifierRecipe.updateInputs(inv, this.ingredient, repairRemaining, amountPerItem, ItemStack.f_41583_);
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerModifiers.modifierRepair.get();
    }

    public ItemStack m_8043_() {
        return ItemStack.f_41583_;
    }

    public ModifierRepairTinkerStationRecipe(ResourceLocation id, ModifierId modifier, Ingredient ingredient, int repairAmount) {
        this.id = id;
        this.modifier = modifier;
        this.ingredient = ingredient;
        this.repairAmount = repairAmount;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    @Override
    public ModifierId getModifier() {
        return this.modifier;
    }

    @Override
    public Ingredient getIngredient() {
        return this.ingredient;
    }

    @Override
    public int getRepairAmount() {
        return this.repairAmount;
    }
}

