/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.util.handler.event;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SplashPotionItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.anointment.Anointment;
import wayoftime.bloodmagic.anointment.AnointmentHolder;
import wayoftime.bloodmagic.common.item.BloodOrb;
import wayoftime.bloodmagic.common.item.IBindable;
import wayoftime.bloodmagic.common.item.IBloodOrb;
import wayoftime.bloodmagic.common.item.ItemExperienceBook;
import wayoftime.bloodmagic.common.item.ItemLavaCrystal;
import wayoftime.bloodmagic.common.item.ItemRitualDiviner;
import wayoftime.bloodmagic.core.AnointmentRegistrar;
import wayoftime.bloodmagic.core.LivingArmorRegistrar;
import wayoftime.bloodmagic.core.data.Binding;
import wayoftime.bloodmagic.core.data.SoulNetwork;
import wayoftime.bloodmagic.core.living.LivingStats;
import wayoftime.bloodmagic.core.living.LivingUpgrade;
import wayoftime.bloodmagic.core.living.LivingUtil;
import wayoftime.bloodmagic.demonaura.WorldDemonWillHandler;
import wayoftime.bloodmagic.event.ItemBindEvent;
import wayoftime.bloodmagic.event.SacrificeKnifeUsedEvent;
import wayoftime.bloodmagic.network.BloodMagicPacketHandler;
import wayoftime.bloodmagic.network.CycleRitualDivinerPacket;
import wayoftime.bloodmagic.network.DemonAuraClientPacket;
import wayoftime.bloodmagic.potion.BloodMagicPotions;
import wayoftime.bloodmagic.util.helper.BindableHelper;
import wayoftime.bloodmagic.util.helper.InventoryHelper;
import wayoftime.bloodmagic.util.helper.NetworkHelper;
import wayoftime.bloodmagic.util.helper.PlayerHelper;
import wayoftime.bloodmagic.will.DemonWillHolder;

@Mod.EventBusSubscriber(modid="bloodmagic", bus=Mod.EventBusSubscriber.Bus.MOD)
public class GenericHandler {
    public static Map<UUID, Double> bounceMap = new HashMap<UUID, Double>();
    public static Map<UUID, Double> posXMap = new HashMap<UUID, Double>();
    public static Map<UUID, Double> posZMap = new HashMap<UUID, Double>();
    public static Map<UUID, Integer> foodMap = new HashMap<UUID, Integer>();
    public static Map<UUID, Float> prevFlySpeedMap = new HashMap<UUID, Float>();
    Map<UUID, TargetGoal> goalMap = new HashMap<UUID, TargetGoal>();
    Map<UUID, MeleeAttackGoal> attackGoalMap = new HashMap<UUID, MeleeAttackGoal>();
    private static final Map<ItemStack, Double> rollMap = new HashMap<ItemStack, Double>();
    public static Map<UUID, Integer> curiosLevelMap = new HashMap<UUID, Integer>();

    @SubscribeEvent
    public void onItemBurn(FurnaceFuelBurnTimeEvent event) {
        ItemStack burnStack = event.getItemStack();
        if (!burnStack.m_41619_() && burnStack.m_41720_() instanceof ItemLavaCrystal) {
            event.setBurnTime(((ItemLavaCrystal)burnStack.m_41720_()).getBurnTime(burnStack));
        }
    }

    @SubscribeEvent
    public void onLivingFall(LivingFallEvent event) {
        LivingEntity eventEntityLiving = event.getEntityLiving();
        if (eventEntityLiving.m_21023_(BloodMagicPotions.HEAVY_HEART)) {
            int i = eventEntityLiving.m_21124_(BloodMagicPotions.HEAVY_HEART).m_19564_() + 1;
            event.setDamageMultiplier(event.getDamageMultiplier() + (float)i);
            event.setDistance(event.getDistance() + (float)i);
        }
        if (eventEntityLiving.m_21023_(BloodMagicPotions.BOUNCE) && eventEntityLiving instanceof Player) {
            Player player = (Player)eventEntityLiving;
            event.setDamageMultiplier(0.0f);
            if (!player.m_6144_() && (double)event.getDistance() > 1.5) {
                if (player.f_19853_.f_46443_) {
                    player.m_20256_(player.m_20184_().m_82542_(1.0, -1.0, 1.0));
                    bounceMap.put(player.m_142081_(), player.m_20184_().m_7098_());
                } else {
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public void playerTickPost(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && bounceMap.containsKey(event.player.m_142081_())) {
            double motionY = bounceMap.remove(event.player.m_142081_());
            event.player.m_20256_(event.player.m_20184_().m_82542_(1.0, 0.0, 1.0).m_82520_(0.0, motionY, 0.0));
        }
    }

    @SubscribeEvent
    public void onInteract(PlayerInteractEvent.RightClickItem event) {
        if (event.getWorld().f_46443_) {
            return;
        }
        Player player = event.getPlayer();
        if (PlayerHelper.isFakePlayer(player)) {
            return;
        }
        ItemStack held = event.getItemStack();
        if (!held.m_41619_() && held.m_41720_() instanceof IBindable) {
            IBindable bindable = (IBindable)held.m_41720_();
            Binding binding = bindable.getBinding(held);
            if (binding == null) {
                if (bindable.onBind(player, held)) {
                    ItemBindEvent toPost = new ItemBindEvent(player, held);
                    if (MinecraftForge.EVENT_BUS.post((Event)toPost)) {
                        return;
                    }
                    BindableHelper.applyBinding(held, player);
                }
            } else if (binding.getOwnerId().equals(player.m_36316_().getId()) && !binding.getOwnerName().equals(player.m_36316_().getName())) {
                binding.setOwnerName(player.m_36316_().getName());
                BindableHelper.applyBinding(held, binding);
            }
        }
        if (!held.m_41619_() && held.m_41720_() instanceof IBloodOrb) {
            IBloodOrb bloodOrb = (IBloodOrb)held.m_41720_();
            SoulNetwork network = NetworkHelper.getSoulNetwork(player);
            BloodOrb orb = bloodOrb.getOrb(held);
            if (orb == null) {
                return;
            }
            if (orb.getTier() > network.getOrbTier()) {
                network.setOrbTier(orb.getTier());
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLeftClickAir(PlayerInteractEvent.LeftClickEmpty event) {
        if (event.getItemStack().m_41720_() instanceof ItemRitualDiviner) {
            BloodMagicPacketHandler.INSTANCE.sendToServer((Object)new CycleRitualDivinerPacket(event.getPlayer().m_150109_().f_35977_));
        }
    }

    @SubscribeEvent
    public void onLivingHurt(LivingHurtEvent event) {
        Player player;
        Entity sourceEntity = event.getSource().m_7639_();
        LivingEntity living = event.getEntityLiving();
        if (sourceEntity instanceof Player) {
            ItemStack heldStack;
            AnointmentHolder holder;
            Player sourcePlayer = (Player)sourceEntity;
            if (LivingUtil.hasFullSet(sourcePlayer)) {
                ItemStack mainWeapon = sourcePlayer.m_21211_();
                double additionalDamage = LivingUtil.getAdditionalDamage(sourcePlayer, mainWeapon, living, event.getAmount());
                event.setAmount((float)((double)event.getAmount() + additionalDamage));
            }
            if ((holder = AnointmentHolder.fromItemStack(heldStack = sourcePlayer.m_21205_())) != null) {
                double additionalDamage = holder.getAdditionalDamage(sourcePlayer, heldStack, event.getAmount(), living);
                event.setAmount((float)((double)event.getAmount() + additionalDamage));
            }
        }
        if (living instanceof Player && LivingUtil.hasFullSet(player = (Player)living)) {
            event.setAmount((float)LivingUtil.getDamageReceivedForArmour(player, event.getSource(), event.getAmount()));
            double factor = 1.6;
            if (event.getSource().m_19360_()) {
                LivingUtil.applyNewExperience(player, (LivingUpgrade)((Object)LivingArmorRegistrar.UPGRADE_ARROW_PROTECT.get()), (double)event.getAmount() / factor);
            } else {
                LivingUtil.applyNewExperience(player, (LivingUpgrade)((Object)LivingArmorRegistrar.UPGRADE_PHYSICAL_PROTECT.get()), (double)event.getAmount() / factor);
            }
            if (event.getSource() == DamageSource.f_19315_) {
                LivingUtil.applyNewExperience(player, (LivingUpgrade)((Object)LivingArmorRegistrar.UPGRADE_FALL_PROTECT.get()), (double)event.getAmount() / factor);
            }
        }
        if (!event.getSource().m_19387_() && living.m_21023_(BloodMagicPotions.OBSIDIAN_CLOAK)) {
            float modifier = (float)(1.0 - 0.2 * (double)(1 + living.m_21124_(BloodMagicPotions.OBSIDIAN_CLOAK).m_19564_()));
            event.setAmount(event.getAmount() * Math.max(0.0f, modifier));
        }
    }

    @SubscribeEvent
    public void onPlayerClick(PlayerInteractEvent event) {
        if (!event.isCancelable()) {
            return;
        }
        Player sourcePlayer = event.getPlayer();
        if (LivingUtil.hasFullSet(sourcePlayer)) {
            int level;
            ItemStack drinkStack;
            int level2;
            LivingStats stats = LivingStats.fromPlayer(sourcePlayer, true);
            if (event.getHand() == InteractionHand.OFF_HAND && (level2 = stats.getLevel(((LivingUpgrade)((Object)LivingArmorRegistrar.DOWNGRADE_CRIPPLED_ARM.get())).getKey())) > 0) {
                event.setCanceled(true);
                return;
            }
            if (event.getItemStack().m_41780_() == UseAnim.DRINK && !((drinkStack = event.getItemStack()).m_41720_() instanceof SplashPotionItem) && (level = stats.getLevel(((LivingUpgrade)((Object)LivingArmorRegistrar.DOWNGRADE_QUENCHED.get())).getKey())) > 0) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onLivingDamage(LivingDamageEvent event) {
        Entity sourceEntity = event.getSource().m_7639_();
        LivingEntity living = event.getEntityLiving();
        if (sourceEntity instanceof Player) {
            ItemStack heldStack;
            AnointmentHolder holder;
            Player sourcePlayer = (Player)sourceEntity;
            if (LivingUtil.hasFullSet(sourcePlayer)) {
                int battleHungryLevel;
                LivingStats stats = LivingStats.fromPlayer(sourcePlayer, true);
                ItemStack chestStack = sourcePlayer.m_6844_(EquipmentSlot.CHEST);
                if (sourcePlayer.m_20142_()) {
                    LivingUtil.applyNewExperience(sourcePlayer, (LivingUpgrade)((Object)LivingArmorRegistrar.UPGRADE_SPRINT_ATTACK.get()), event.getAmount());
                }
                if (!event.getSource().m_19360_()) {
                    LivingUtil.applyNewExperience(sourcePlayer, (LivingUpgrade)((Object)LivingArmorRegistrar.UPGRADE_MELEE_DAMAGE.get()), event.getAmount());
                }
                if ((battleHungryLevel = stats.getLevel(((LivingUpgrade)((Object)LivingArmorRegistrar.DOWNGRADE_BATTLE_HUNGRY.get())).getKey())) > 0) {
                    int delay = ((LivingUpgrade)((Object)LivingArmorRegistrar.DOWNGRADE_BATTLE_HUNGRY.get())).getBonusValue("delay", battleHungryLevel).intValue();
                    chestStack.m_41783_().m_128405_("battle_cooldown", delay);
                }
            }
            if ((holder = AnointmentHolder.fromItemStack(heldStack = sourcePlayer.m_21205_())) != null && holder.consumeAnointmentDurabilityOnHit(heldStack, EquipmentSlot.MAINHAND, (LivingEntity)sourcePlayer)) {
                holder.toItemStack(heldStack);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onExperiencePickupHighest(PlayerXpEvent.PickupXp event) {
        Player player;
        LivingEntity living = event.getEntityLiving();
        if (living instanceof Player && LivingUtil.hasFullSet(player = (Player)living)) {
            LivingStats stats = LivingStats.fromPlayer(player, true);
            double expModifier = 1.0 + ((LivingUpgrade)((Object)LivingArmorRegistrar.UPGRADE_EXPERIENCE.get())).getBonusValue("exp", stats.getLevel(((LivingUpgrade)((Object)LivingArmorRegistrar.UPGRADE_EXPERIENCE.get())).getKey())).doubleValue();
            int xp = event.getOrb().f_20770_;
            event.getOrb().f_20770_ = (int)Math.floor((double)xp * expModifier) + (player.f_19853_.f_46441_.nextDouble() < (double)xp * expModifier % 1.0 ? 1 : 0);
            LivingUtil.applyNewExperience(player, (LivingUpgrade)((Object)LivingArmorRegistrar.UPGRADE_EXPERIENCE.get()), event.getOrb().m_20801_());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onExperiencePickup(PlayerXpEvent.PickupXp event) {
        ItemStack itemStack;
        Player player = event.getPlayer();
        Map.Entry entry = EnchantmentHelper.m_44906_((Enchantment)Enchantments.f_44962_, (LivingEntity)player);
        if (entry != null && !(itemStack = (ItemStack)entry.getValue()).m_41619_() && itemStack.m_41768_()) {
            int i = Math.min(GenericHandler.xpToDurability(event.getOrb().f_20770_), itemStack.m_41773_());
            event.getOrb().f_20770_ -= GenericHandler.durabilityToXp(i);
            itemStack.m_41721_(itemStack.m_41773_() - i);
        }
        if (!player.m_20193_().f_46443_) {
            for (ItemStack stack : InventoryHelper.getAllInventories(player)) {
                if (!(stack.m_41720_() instanceof ItemExperienceBook)) continue;
                ItemExperienceBook.addExperience(stack, event.getOrb().f_20770_);
                event.getOrb().f_20770_ = 0;
                break;
            }
        }
    }

    private static int xpToDurability(int xp) {
        return xp * 2;
    }

    private static int durabilityToXp(int durability) {
        return durability / 2;
    }

    public static void sendPlayerDemonWillAura(Player player) {
        if (player instanceof ServerPlayer) {
            BlockPos pos = player.m_142538_();
            DemonWillHolder holder = WorldDemonWillHandler.getWillHolder(WorldDemonWillHandler.getDimensionResourceLocation(player.f_19853_), pos.m_123341_() >> 4, pos.m_123343_() >> 4);
            if (holder != null) {
                BloodMagic.packetHandler.sendTo(new DemonAuraClientPacket(holder), (ServerPlayer)player);
            } else {
                BloodMagic.packetHandler.sendTo(new DemonAuraClientPacket(new DemonWillHolder()), (ServerPlayer)player);
            }
        }
    }

    @SubscribeEvent
    public void onHeal(LivingHealEvent event) {
        Player player;
        LivingEntity living = event.getEntityLiving();
        if (living instanceof Player && LivingUtil.hasFullSet(player = (Player)living)) {
            LivingStats stats = LivingStats.fromPlayer(player, true);
            float healModifier = 1.0f + ((LivingUpgrade)((Object)LivingArmorRegistrar.DOWNGRADE_SLOW_HEAL.get())).getBonusValue("heal_modifier", stats.getLevel(((LivingUpgrade)((Object)LivingArmorRegistrar.DOWNGRADE_SLOW_HEAL.get())).getKey())).floatValue();
            event.setAmount(event.getAmount() * healModifier);
            LivingUtil.applyNewExperience(player, (LivingUpgrade)((Object)LivingArmorRegistrar.UPGRADE_HEALTH.get()), event.getAmount());
        }
    }

    @SubscribeEvent
    public void onSelfSacrifice(SacrificeKnifeUsedEvent event) {
        if (LivingUtil.hasFullSet(event.player)) {
            LivingStats stats = LivingStats.fromPlayer(event.player, true);
            double bonus = ((LivingUpgrade)((Object)LivingArmorRegistrar.UPGRADE_SELF_SACRIFICE.get())).getBonusValue("self_mod", stats.getLevel(((LivingUpgrade)((Object)LivingArmorRegistrar.UPGRADE_SELF_SACRIFICE.get())).getKey())).doubleValue();
            event.lpAdded = (int)Math.round((double)event.lpAdded * (1.0 + bonus));
            LivingUtil.applyNewExperience(event.player, (LivingUpgrade)((Object)LivingArmorRegistrar.UPGRADE_SELF_SACRIFICE.get()), event.healthDrained);
        }
    }

    @SubscribeEvent
    public void onPotionAdded(PotionEvent.PotionAddedEvent event) {
        if (event.getPotionEffect().m_19544_() == BloodMagicPotions.FLIGHT && event.getEntityLiving() instanceof Player) {
            Player player = (Player)event.getEntityLiving();
            player.m_150110_().f_35936_ = true;
            if (!prevFlySpeedMap.containsKey(player.m_142081_())) {
                prevFlySpeedMap.put(player.m_142081_(), Float.valueOf(player.m_150110_().m_35942_()));
            }
            if (event.getEntity().f_19853_.f_46443_) {
                player.m_150110_().m_35943_(this.getFlySpeedForFlightLevel(event.getPotionEffect().m_19564_()));
            }
            player.m_6885_();
        }
    }

    @SubscribeEvent
    public void onPotionExpired(PotionEvent.PotionExpiryEvent event) {
        if (event.getPotionEffect().m_19544_() == BloodMagicPotions.FLIGHT && event.getEntityLiving() instanceof Player) {
            ((Player)event.getEntityLiving()).m_150110_().f_35936_ = ((Player)event.getEntityLiving()).m_7500_();
            ((Player)event.getEntityLiving()).m_150110_().f_35935_ = false;
            if (event.getEntity().f_19853_.f_46443_) {
                ((Player)event.getEntityLiving()).m_150110_().m_35943_(prevFlySpeedMap.getOrDefault(((Player)event.getEntityLiving()).m_142081_(), Float.valueOf(this.getFlySpeedForFlightLevel(-1))).floatValue());
                prevFlySpeedMap.remove(((Player)event.getEntityLiving()).m_142081_());
            }
            ((Player)event.getEntityLiving()).m_6885_();
        }
    }

    private float getFlySpeedForFlightLevel(int level) {
        if (level >= 0) {
            return 0.05f * (float)(level + 1);
        }
        return 0.05f;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        Player player;
        if (event.getEntity().f_19853_.f_46443_ && event.getEntityLiving() instanceof Player && LivingUtil.hasFullSet(player = (Player)event.getEntityLiving())) {
            LivingStats stats = LivingStats.fromPlayer(player, true);
            if (!player.m_20096_() && player.m_20184_().m_7098_() < 0.0) {
                int jumpLevel = stats.getLevel(((LivingUpgrade)((Object)LivingArmorRegistrar.UPGRADE_JUMP.get())).getKey());
                double fallDistanceMultiplier = ((LivingUpgrade)((Object)LivingArmorRegistrar.UPGRADE_JUMP.get())).getBonusValue("fall", jumpLevel).doubleValue();
                player.f_19789_ = (float)Math.max(0.0, (double)player.f_19789_ + fallDistanceMultiplier * player.m_20184_().m_7098_());
            }
        }
        if (event.getEntityLiving() instanceof Player) {
            player = (Player)event.getEntityLiving();
            if (player.m_21023_(BloodMagicPotions.FLIGHT)) {
                player.f_19789_ = 0.0f;
                if (!player.m_150110_().f_35936_ || !prevFlySpeedMap.containsKey(player.m_142081_())) {
                    prevFlySpeedMap.put(player.m_142081_(), Float.valueOf(player.m_150110_().m_35942_()));
                    player.m_150110_().f_35936_ = true;
                    if (player.f_19853_.f_46443_) {
                        player.m_150110_().m_35943_(this.getFlySpeedForFlightLevel(player.m_21124_(BloodMagicPotions.FLIGHT).m_19564_()));
                    }
                    player.m_6885_();
                }
            }
            float percentIncrease = 0.0f;
            if (LivingUtil.hasFullSet(player)) {
                int repairingLevel;
                int currentArmourDamage;
                int pastArmourDamage;
                int battleHungryLevel;
                int fireCooldown;
                int fireLevel;
                int speedTime;
                LivingStats stats = LivingStats.fromPlayer(player, true);
                ItemStack chestStack = player.m_6844_(EquipmentSlot.CHEST);
                if (player.m_20142_() && (speedTime = ((LivingUpgrade)((Object)LivingArmorRegistrar.UPGRADE_SPEED.get())).getBonusValue("speed_time", stats.getLevel(((LivingUpgrade)((Object)LivingArmorRegistrar.UPGRADE_SPEED.get())).getKey())).intValue()) > 0) {
                    int speedLevel = ((LivingUpgrade)((Object)LivingArmorRegistrar.UPGRADE_SPEED.get())).getBonusValue("speed_level", stats.getLevel(((LivingUpgrade)((Object)LivingArmorRegistrar.UPGRADE_SPEED.get())).getKey())).intValue();
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19596_, speedTime, speedLevel, true, false));
                }
                double distance = 0.0;
                if (posXMap.containsKey(player.m_142081_())) {
                    distance = Math.sqrt((player.m_20185_() - posXMap.get(player.m_142081_())) * (player.m_20185_() - posXMap.get(player.m_142081_())) + (player.m_20189_() - posZMap.get(player.m_142081_())) * (player.m_20189_() - posZMap.get(player.m_142081_())));
                }
                int currentFood = player.m_36324_().m_38702_();
                if (foodMap.getOrDefault(player.m_142081_(), 19) < currentFood) {
                    LivingUtil.applyNewExperience(player, (LivingUpgrade)((Object)LivingArmorRegistrar.UPGRADE_KNOCKBACK_RESIST.get()), currentFood - foodMap.getOrDefault(player.m_142081_(), 19));
                }
                foodMap.put(player.m_142081_(), currentFood);
                if (player.m_20096_() && distance > 0.0 && distance < 50.0) {
                    LivingUtil.applyNewExperience(player, (LivingUpgrade)((Object)LivingArmorRegistrar.UPGRADE_SPEED.get()), distance *= (double)(1.0f + percentIncrease));
                }
                if (!player.m_20096_() && player.m_20184_().m_7098_() < 0.0) {
                    int jumpLevel = stats.getLevel(((LivingUpgrade)((Object)LivingArmorRegistrar.UPGRADE_JUMP.get())).getKey());
                    double fallDistanceMultiplier = ((LivingUpgrade)((Object)LivingArmorRegistrar.UPGRADE_JUMP.get())).getBonusValue("fall", jumpLevel).doubleValue();
                    player.f_19789_ = (float)Math.max(0.0, (double)player.f_19789_ + fallDistanceMultiplier * player.m_20184_().m_7098_());
                }
                if ((fireLevel = stats.getLevel(((LivingUpgrade)((Object)LivingArmorRegistrar.UPGRADE_FIRE_RESIST.get())).getKey())) > 0) {
                    boolean hasChanged = false;
                    fireCooldown = chestStack.m_41783_().m_128451_("fire_cooldown");
                    if (fireCooldown > 0) {
                        --fireCooldown;
                        hasChanged = true;
                    }
                    if (hasChanged) {
                        chestStack.m_41783_().m_128405_("fire_cooldown", fireCooldown);
                    }
                }
                if (player.m_20094_() > 0) {
                    LivingUtil.applyNewExperience(player, (LivingUpgrade)((Object)LivingArmorRegistrar.UPGRADE_FIRE_RESIST.get()), 1.0);
                    if (fireLevel > 0) {
                        boolean hasChanged = false;
                        fireCooldown = chestStack.m_41783_().m_128451_("fire_cooldown");
                        if (player.m_20094_() > 0 && fireCooldown <= 0) {
                            fireCooldown = ((LivingUpgrade)((Object)LivingArmorRegistrar.UPGRADE_FIRE_RESIST.get())).getBonusValue("cooldown_time", fireLevel).intValue();
                            player.m_7292_(new MobEffectInstance(MobEffects.f_19607_, ((LivingUpgrade)((Object)LivingArmorRegistrar.UPGRADE_FIRE_RESIST.get())).getBonusValue("resist_duration", fireLevel).intValue(), 0, true, false));
                            hasChanged = true;
                        }
                        if (hasChanged) {
                            chestStack.m_41783_().m_128405_("fire_cooldown", fireCooldown);
                        }
                    }
                }
                int poisonLevel = stats.getLevel(((LivingUpgrade)((Object)LivingArmorRegistrar.UPGRADE_POISON_RESIST.get())).getKey());
                if (player.m_21023_(MobEffects.f_19614_)) {
                    LivingUtil.applyNewExperience(player, (LivingUpgrade)((Object)LivingArmorRegistrar.UPGRADE_POISON_RESIST.get()), 1.0);
                }
                if (poisonLevel > 0) {
                    boolean hasChanged = false;
                    int poisonCooldown = chestStack.m_41783_().m_128451_("poison_cooldown");
                    if (poisonCooldown > 0) {
                        --poisonCooldown;
                        hasChanged = true;
                    }
                    if (player.m_21023_(MobEffects.f_19614_) && poisonCooldown <= 0 && ((LivingUpgrade)((Object)LivingArmorRegistrar.UPGRADE_POISON_RESIST.get())).getBonusValue("max_cure", poisonLevel).intValue() >= player.m_21124_(MobEffects.f_19614_).m_19564_()) {
                        poisonCooldown = ((LivingUpgrade)((Object)LivingArmorRegistrar.UPGRADE_POISON_RESIST.get())).getBonusValue("cooldown", poisonLevel).intValue();
                        player.m_21195_(MobEffects.f_19614_);
                        hasChanged = true;
                    }
                    if (hasChanged) {
                        chestStack.m_41783_().m_128405_("poison_cooldown", poisonCooldown);
                    }
                }
                if ((battleHungryLevel = stats.getLevel(((LivingUpgrade)((Object)LivingArmorRegistrar.DOWNGRADE_BATTLE_HUNGRY.get())).getKey())) > 0) {
                    boolean hasChanged = false;
                    int battleCooldown = chestStack.m_41783_().m_128451_("battle_cooldown");
                    if (battleCooldown > 0) {
                        --battleCooldown;
                        hasChanged = true;
                    }
                    if (battleCooldown <= 0) {
                        battleCooldown = 20;
                        float exhaustionAdded = ((LivingUpgrade)((Object)LivingArmorRegistrar.DOWNGRADE_BATTLE_HUNGRY.get())).getBonusValue("exhaustion", battleHungryLevel).floatValue();
                        player.m_36399_(exhaustionAdded);
                        hasChanged = true;
                    }
                    if (hasChanged) {
                        chestStack.m_41783_().m_128405_("battle_cooldown", battleCooldown);
                    }
                }
                if ((pastArmourDamage = chestStack.m_41783_().m_128451_("past_damage")) > (currentArmourDamage = chestStack.m_41773_())) {
                    LivingUtil.applyNewExperience(player, (LivingUpgrade)((Object)LivingArmorRegistrar.UPGRADE_REPAIR.get()), pastArmourDamage - currentArmourDamage);
                }
                if (currentArmourDamage != pastArmourDamage) {
                    chestStack.m_41783_().m_128405_("past_damage", currentArmourDamage);
                }
                if (!player.f_19853_.f_46443_ && (repairingLevel = stats.getLevel(((LivingUpgrade)((Object)LivingArmorRegistrar.UPGRADE_REPAIR.get())).getKey())) > 0) {
                    boolean hasChanged = false;
                    int repairCooldown = chestStack.m_41783_().m_128451_("repair_cooldown");
                    if (repairCooldown > 0) {
                        --repairCooldown;
                        hasChanged = true;
                    }
                    if (repairCooldown <= 0) {
                        int maxDurabilityRepaired;
                        int toRepair;
                        repairCooldown = ((LivingUpgrade)((Object)LivingArmorRegistrar.UPGRADE_REPAIR.get())).getBonusValue("interval", repairingLevel).intValue();
                        hasChanged = true;
                        EquipmentSlot randomSlot = EquipmentSlot.values()[2 + player.f_19853_.f_46441_.nextInt(4)];
                        ItemStack repairStack = player.m_6844_(randomSlot);
                        if (!repairStack.m_41619_() && repairStack.m_41763_() && repairStack.m_41768_() && (toRepair = Math.min(maxDurabilityRepaired = ((LivingUpgrade)((Object)LivingArmorRegistrar.UPGRADE_REPAIR.get())).getBonusValue("max", repairingLevel).intValue(), repairStack.m_41773_())) > 0) {
                            repairStack.m_41721_(repairStack.m_41773_() - toRepair);
                        }
                    }
                    if (hasChanged) {
                        chestStack.m_41783_().m_128405_("repair_cooldown", repairCooldown);
                    }
                }
            }
            posXMap.put(player.m_142081_(), player.m_20185_());
            posZMap.put(player.m_142081_(), player.m_20189_());
        }
    }

    @SubscribeEvent
    public void onMiningSpeedCheck(PlayerEvent.BreakSpeed event) {
        Player player = event.getPlayer();
        float speedModifier = 1.0f;
        if (LivingUtil.hasFullSet(player)) {
            LivingStats stats = LivingStats.fromPlayer(player, true);
            speedModifier = (float)((double)speedModifier * (1.0 + ((LivingUpgrade)((Object)LivingArmorRegistrar.UPGRADE_DIGGING.get())).getBonusValue("speed_modifier", stats.getLevel(((LivingUpgrade)((Object)LivingArmorRegistrar.UPGRADE_DIGGING.get())).getKey())).doubleValue()));
            speedModifier = (float)((double)speedModifier * (1.0 + ((LivingUpgrade)((Object)LivingArmorRegistrar.DOWNGRADE_DIG_SLOWDOWN.get())).getBonusValue("speed_modifier", stats.getLevel(((LivingUpgrade)((Object)LivingArmorRegistrar.DOWNGRADE_DIG_SLOWDOWN.get())).getKey())).doubleValue()));
        }
        event.setNewSpeed(speedModifier * event.getNewSpeed());
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onBreakBlock(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        if (player != null) {
            ItemStack heldStack;
            AnointmentHolder holder;
            if (LivingUtil.hasFullSet(player)) {
                LivingUtil.applyNewExperience(player, (LivingUpgrade)((Object)LivingArmorRegistrar.UPGRADE_DIGGING.get()), 1.0);
                LivingStats stats = LivingStats.fromPlayer(player);
                int mineTime = ((LivingUpgrade)((Object)LivingArmorRegistrar.UPGRADE_DIGGING.get())).getBonusValue("speed_time", stats.getLevel(((LivingUpgrade)((Object)LivingArmorRegistrar.UPGRADE_DIGGING.get())).getKey())).intValue();
                if (mineTime > 0) {
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19598_, mineTime, ((LivingUpgrade)((Object)LivingArmorRegistrar.UPGRADE_DIGGING.get())).getBonusValue("speed_level", stats.getLevel(((LivingUpgrade)((Object)LivingArmorRegistrar.UPGRADE_DIGGING.get())).getKey())).intValue(), true, false));
                }
            }
            if ((holder = AnointmentHolder.fromItemStack(heldStack = player.m_21205_())) != null) {
                int hiddenLevel;
                if (holder.getAnointmentLevel((Anointment)((Object)AnointmentRegistrar.ANOINTMENT_SILK_TOUCH.get())) >= 1) {
                    int bonusLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44987_, (ItemStack)player.m_21205_());
                    int exp = event.getState().getExpDrop((LevelReader)event.getWorld(), event.getPos(), bonusLevel, holder.getAnointmentLevel((Anointment)((Object)AnointmentRegistrar.ANOINTMENT_SILK_TOUCH.get())));
                    event.setExpToDrop(exp);
                }
                if ((hiddenLevel = holder.getAnointmentLevel((Anointment)((Object)AnointmentRegistrar.ANOINTMENT_HIDDEN_KNOWLEDGE.get()))) > 0) {
                    double expBonus = ((Anointment)((Object)AnointmentRegistrar.ANOINTMENT_HIDDEN_KNOWLEDGE.get())).getBonusValue("exp", hiddenLevel).doubleValue();
                    int expAdded = (int)expBonus + (expBonus % 1.0 > event.getWorld().m_5822_().nextDouble() ? 1 : 0);
                    event.setExpToDrop(event.getExpToDrop() + expAdded);
                }
                if (holder.consumeAnointmentDurabilityOnHarvest(heldStack, EquipmentSlot.MAINHAND, (LivingEntity)player)) {
                    holder.toItemStack(heldStack);
                }
            }
        }
    }

    @SubscribeEvent
    public void onJump(LivingEvent.LivingJumpEvent event) {
        Player player;
        if (event.getEntityLiving().m_21023_(BloodMagicPotions.GROUNDED)) {
            Vec3 motion = event.getEntityLiving().m_20184_();
            motion = motion.m_82542_(1.0, 0.0, 1.0);
            event.getEntityLiving().m_20256_(motion);
            return;
        }
        if (event.getEntityLiving() instanceof Player && LivingUtil.hasFullSet(player = (Player)event.getEntityLiving())) {
            LivingUtil.applyNewExperience(player, (LivingUpgrade)((Object)LivingArmorRegistrar.UPGRADE_JUMP.get()), 1.0);
            if (!player.m_6144_()) {
                LivingStats stats = LivingStats.fromPlayer(player);
                double jumpModifier = ((LivingUpgrade)((Object)LivingArmorRegistrar.UPGRADE_JUMP.get())).getBonusValue("jump", stats.getLevel(((LivingUpgrade)((Object)LivingArmorRegistrar.UPGRADE_JUMP.get())).getKey())).doubleValue();
                player.m_20256_(player.m_20184_().m_82520_(0.0, jumpModifier, 0.0));
            }
        }
    }

    @SubscribeEvent
    public void onEntityUseTick(LivingEntityUseItemEvent.Tick event) {
        ItemStack stack = event.getItem();
        if (stack.m_41720_() instanceof BowItem || stack.m_41720_() instanceof CrossbowItem) {
            AnointmentHolder holder = AnointmentHolder.fromItemStack(stack);
            if (holder == null) {
                return;
            }
            int quickDrawLevel = holder.getAnointmentLevel((Anointment)((Object)AnointmentRegistrar.ANOINTMENT_QUICK_DRAW.get()));
            if (quickDrawLevel > 0) {
                double amount = rollMap.getOrDefault(stack, 0.0) + ((Anointment)((Object)AnointmentRegistrar.ANOINTMENT_QUICK_DRAW.get())).getBonusValue("speed", quickDrawLevel).doubleValue();
                if (amount >= 1.0) {
                    int drawReduction = (int)amount;
                    event.setDuration(event.getDuration() - drawReduction);
                } else {
                    rollMap.put(stack, amount);
                }
            }
        }
    }

    @SubscribeEvent
    public void onEntityFinishUse(LivingEntityUseItemEvent.Stop event) {
        int i;
        float f;
        ItemStack stack = event.getItem();
        if (stack.m_41720_() instanceof CrossbowItem && (f = GenericHandler.getCharge(i = stack.m_41779_() - event.getDuration(), stack)) < 0.0f) {
            return;
        }
        AnointmentHolder holder = AnointmentHolder.fromItemStack(stack);
        if (holder != null && holder.consumeAnointmentDurabilityOnUseFinish(stack, EquipmentSlot.MAINHAND, event.getEntityLiving())) {
            holder.toItemStack(stack);
        }
    }

    @SubscribeEvent
    public void onEntityJoinEvent(EntityJoinWorldEvent event) {
        Arrow arrowEntity;
        Entity shooter;
        Entity owner = null;
        Entity entity = event.getEntity();
        if (entity instanceof Arrow) {
            owner = ((Arrow)event.getEntity()).m_37282_();
        } else if (entity instanceof ThrowableProjectile) {
            owner = ((ThrowableProjectile)entity).m_37282_();
        }
        if (owner instanceof Player) {
            Entity projectile = event.getEntity();
            Player player = (Player)owner;
            if (LivingUtil.hasFullSet(player)) {
                LivingStats stats = LivingStats.fromPlayer(player, true);
                double arrowJiggle = ((LivingUpgrade)((Object)LivingArmorRegistrar.DOWNGRADE_STORM_TROOPER.get())).getBonusValue("inaccuracy", stats.getLevel(((LivingUpgrade)((Object)LivingArmorRegistrar.DOWNGRADE_STORM_TROOPER.get())).getKey())).doubleValue();
                if (arrowJiggle > 0.0) {
                    Vec3 motion = projectile.m_20184_();
                    float velocityModifier = (float)(arrowJiggle * Math.sqrt(motion.f_82479_ * motion.f_82479_ + motion.f_82480_ * motion.f_82480_ + motion.f_82481_ * motion.f_82481_));
                    Vec3 newMotion = motion.m_82520_(2.0 * (event.getWorld().f_46441_.nextDouble() - 0.5) * (double)velocityModifier, 2.0 * (event.getWorld().f_46441_.nextDouble() - 0.5) * (double)velocityModifier, 2.0 * (event.getWorld().f_46441_.nextDouble() - 0.5) * (double)velocityModifier);
                    projectile.m_20256_(newMotion);
                }
            }
        }
        if (entity instanceof Arrow && entity.f_19797_ <= 0 && (shooter = (arrowEntity = (Arrow)entity).m_37282_()) instanceof Player) {
            Player playerShooter = (Player)shooter;
            for (InteractionHand hand : InteractionHand.values()) {
                int velocityLevel;
                ItemStack heldStack = playerShooter.m_21120_(hand);
                AnointmentHolder holder = AnointmentHolder.fromItemStack(heldStack);
                if (holder == null) continue;
                int powerLevel = holder.getAnointmentLevel((Anointment)((Object)AnointmentRegistrar.ANOINTMENT_BOW_POWER.get()));
                if (powerLevel > 0) {
                    arrowEntity.m_36781_(arrowEntity.m_36789_() * ((Anointment)((Object)AnointmentRegistrar.ANOINTMENT_BOW_POWER.get())).getBonusValue("damage", powerLevel).doubleValue());
                }
                if ((velocityLevel = holder.getAnointmentLevel((Anointment)((Object)AnointmentRegistrar.ANOINTMENT_BOW_VELOCITY.get()))) <= 0) break;
                Vec3 motion = arrowEntity.m_20184_();
                double multiplier = (float)((Anointment)((Object)AnointmentRegistrar.ANOINTMENT_BOW_VELOCITY.get())).getBonusValue("multiplier", velocityLevel).doubleValue();
                arrowEntity.m_20256_(motion.m_82490_(multiplier));
                arrowEntity.m_36781_(arrowEntity.m_36789_() / multiplier);
                break;
            }
        }
    }

    @SubscribeEvent
    public void onCheckLooting(LootingLevelEvent event) {
        DamageSource source = event.getDamageSource();
        if (source == null) {
            return;
        }
        Entity entity = source.m_7639_();
        if (entity instanceof Player) {
            ItemStack heldStack = ((Player)entity).m_21205_();
            AnointmentHolder holder = AnointmentHolder.fromItemStack(heldStack);
            if (holder == null) {
                return;
            }
            int plunderLevel = holder.getAnointmentLevel((Anointment)((Object)AnointmentRegistrar.ANOINTMENT_LOOTING.get()));
            if (plunderLevel > 0) {
                event.setLootingLevel(event.getLootingLevel() + plunderLevel);
            }
        }
    }

    @SubscribeEvent
    public void onLivingEquipmentChange(LivingEquipmentChangeEvent event) {
    }

    private static float getCharge(int useTime, ItemStack stack) {
        float f = (float)useTime / (float)GenericHandler.getChargeTime(stack);
        if (f > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public static int getChargeTime(ItemStack stack) {
        int i = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44960_, (ItemStack)stack);
        return i == 0 ? 25 : 25 - 5 * i;
    }
}

