/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.structures;

import com.google.common.reflect.TypeToken;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import org.apache.commons.lang3.tuple.Pair;
import wayoftime.bloodmagic.common.block.BloodMagicBlocks;
import wayoftime.bloodmagic.common.tile.TileDungeonController;
import wayoftime.bloodmagic.common.tile.TileDungeonSeal;
import wayoftime.bloodmagic.common.tile.TileSpecialRoomDungeonSeal;
import wayoftime.bloodmagic.gson.Serializers;
import wayoftime.bloodmagic.ritual.AreaDescriptor;
import wayoftime.bloodmagic.structures.DungeonDoor;
import wayoftime.bloodmagic.structures.DungeonRoom;
import wayoftime.bloodmagic.structures.DungeonRoomRegistry;
import wayoftime.bloodmagic.structures.SpecialDungeonRoomPoolRegistry;
import wayoftime.bloodmagic.structures.StoneToOreProcessor;
import wayoftime.bloodmagic.structures.rooms.DungeonRoomPlacement;

public class DungeonSynthesizer {
    public static boolean displayDetailedInformation = false;
    public Map<String, Map<Direction, List<BlockPos>>> availableDoorMasterMap = new HashMap<String, Map<Direction, List<BlockPos>>>();
    public List<AreaDescriptor> descriptorList = new ArrayList<AreaDescriptor>();
    private int activatedDoors = 0;
    private List<ResourceLocation> specialRoomBuffer = new ArrayList<ResourceLocation>();
    private Map<ResourceLocation, Integer> placementsSinceLastSpecial = new HashMap<ResourceLocation, Integer>();

    public void writeToNBT(CompoundTag tag) {
        CompoundTag compoundnbt;
        String json = Serializers.GSON.toJson(this.availableDoorMasterMap);
        tag.m_128359_("dungeon_door_map", json);
        ListTag listnbt = new ListTag();
        for (int i = 0; i < this.descriptorList.size(); ++i) {
            AreaDescriptor desc = this.descriptorList.get(i);
            compoundnbt = new CompoundTag();
            desc.writeToNBT(compoundnbt);
            listnbt.add((Object)compoundnbt);
        }
        if (!listnbt.isEmpty()) {
            tag.m_128365_("area_descriptors", (Tag)listnbt);
        }
        ListTag bufferNBTList = new ListTag();
        for (int i = 0; i < this.specialRoomBuffer.size(); ++i) {
            compoundnbt = new CompoundTag();
            compoundnbt.m_128359_("room_pool", this.specialRoomBuffer.get(i).toString());
            bufferNBTList.add((Object)compoundnbt);
        }
        if (!bufferNBTList.isEmpty()) {
            tag.m_128365_("room_pool_buffer", (Tag)bufferNBTList);
        }
        ListTag placementNBTList = new ListTag();
        for (Map.Entry<ResourceLocation, Integer> entry : this.placementsSinceLastSpecial.entrySet()) {
            CompoundTag compoundnbt2 = new CompoundTag();
            compoundnbt2.m_128359_("room_pool", entry.getKey().toString());
            compoundnbt2.m_128405_("value", entry.getValue().intValue());
            placementNBTList.add((Object)compoundnbt2);
        }
        if (!placementNBTList.isEmpty()) {
            tag.m_128365_("room_pool_tracker", (Tag)placementNBTList);
        }
    }

    public void readFromNBT(CompoundTag tag) {
        String testJson = tag.m_128461_("dungeon_door_map");
        if (!testJson.isEmpty()) {
            this.availableDoorMasterMap = (Map)Serializers.GSON.fromJson(testJson, new TypeToken<Map<String, Map<Direction, List<BlockPos>>>>(){}.getType());
        }
        ListTag listnbt = tag.m_128437_("area_descriptors", 10);
        for (int i = 0; i < listnbt.size(); ++i) {
            CompoundTag compoundnbt = listnbt.m_128728_(i);
            AreaDescriptor.Rectangle rec = new AreaDescriptor.Rectangle(BlockPos.f_121853_, 0);
            rec.readFromNBT(compoundnbt);
            this.descriptorList.add(rec);
        }
        ListTag bufferNBTList = tag.m_128437_("room_pool_buffer", 10);
        for (int i = 0; i < bufferNBTList.size(); ++i) {
            CompoundTag compoundnbt = bufferNBTList.m_128728_(i);
            this.specialRoomBuffer.add(new ResourceLocation(compoundnbt.m_128461_("room_pool")));
        }
        ListTag trackerNBTList = tag.m_128437_("room_pool_tracker", 10);
        for (int i = 0; i < trackerNBTList.size(); ++i) {
            CompoundTag compoundnbt = trackerNBTList.m_128728_(i);
            this.placementsSinceLastSpecial.put(new ResourceLocation(compoundnbt.m_128461_("room_pool")), compoundnbt.m_128451_("value"));
        }
    }

    public BlockPos[] generateInitialRoom(ResourceLocation initialType, Random rand, ServerLevel world, BlockPos spawningPosition) {
        StructurePlaceSettings settings = new StructurePlaceSettings();
        Mirror mir = Mirror.NONE;
        settings.m_74377_(mir);
        Rotation rot = Rotation.NONE;
        settings.m_74379_(rot);
        settings.m_74392_(true);
        settings.m_74402_(true);
        DungeonRoom initialRoom = DungeonRoomRegistry.getRandomDungeonRoom(initialType, rand);
        BlockPos roomPlacementPosition = initialRoom.getInitialSpawnOffsetForControllerPos(settings, spawningPosition);
        this.descriptorList.addAll(initialRoom.getAreaDescriptors(settings, roomPlacementPosition));
        for (Direction facing : Direction.values()) {
            Map<String, List<BlockPos>> doorTypeMap = initialRoom.getAllDoorOffsetsForFacing(settings, facing, roomPlacementPosition);
            for (Map.Entry<String, List<BlockPos>> entry : doorTypeMap.entrySet()) {
                Map<Direction, List<BlockPos>> doorDirectionMap;
                if (!this.availableDoorMasterMap.containsKey(entry.getKey())) {
                    this.availableDoorMasterMap.put(entry.getKey(), new HashMap());
                }
                if (!(doorDirectionMap = this.availableDoorMasterMap.get(entry.getKey())).containsKey(facing)) {
                    doorDirectionMap.put(facing, new ArrayList());
                }
                doorDirectionMap.get(facing).addAll((Collection<BlockPos>)entry.getValue());
            }
        }
        initialRoom.placeStructureAtPosition(rand, settings, world, roomPlacementPosition);
        this.addNewControllerBlock(world, spawningPosition);
        List<DungeonDoor> doorTypeMap = initialRoom.getPotentialConnectedRoomTypes(settings, roomPlacementPosition);
        for (DungeonDoor dungeonDoor : doorTypeMap) {
            this.addNewDoorBlock(dungeonDoor, world, spawningPosition, dungeonDoor.doorPos, dungeonDoor.doorDir, dungeonDoor.doorType, 0, 0, dungeonDoor.getRoomList(), dungeonDoor.getSpecialRoomList());
        }
        BlockPos playerPos = initialRoom.getPlayerSpawnLocationForPlacement(settings, roomPlacementPosition);
        BlockPos portalLocation = initialRoom.getPortalOffsetLocationForPlacement(settings, roomPlacementPosition);
        return new BlockPos[]{playerPos, portalLocation};
    }

    public void addNewControllerBlock(ServerLevel world, BlockPos controllerPos) {
        world.m_7731_(controllerPos, ((Block)BloodMagicBlocks.DUNGEON_CONTROLLER.get()).m_49966_(), 3);
        BlockEntity tile = world.m_7702_(controllerPos);
        if (tile instanceof TileDungeonController) {
            ((TileDungeonController)tile).setDungeonSynthesizer(this);
        }
    }

    public boolean isBlockInDescriptor(BlockPos blockPos) {
        for (AreaDescriptor descriptor : this.descriptorList) {
            if (!descriptor.isWithinArea(blockPos)) continue;
            return true;
        }
        return false;
    }

    public boolean isAnyBlockInDescriptor(List<BlockPos> posList) {
        for (BlockPos pos : posList) {
            if (!this.isBlockInDescriptor(pos)) continue;
            return true;
        }
        return false;
    }

    public boolean doesDescriptorIntersect(AreaDescriptor desc) {
        for (AreaDescriptor descriptor : this.descriptorList) {
            if (!descriptor.intersects(desc)) continue;
            return true;
        }
        return false;
    }

    public boolean addNewDoorBlock(DungeonDoor door, ServerLevel world, BlockPos controllerPos, BlockPos doorBlockPos, Direction doorFacing, String doorType, int newRoomDepth, int highestBranchRoomDepth, List<ResourceLocation> potentialRoomTypes, List<ResourceLocation> specialRoomTypes) {
        boolean doPlaceDoor;
        if (highestBranchRoomDepth < newRoomDepth) {
            highestBranchRoomDepth = newRoomDepth;
        }
        BlockPos doorBlockOffsetPos = doorBlockPos.m_142300_(doorFacing).m_5484_(Direction.UP, 2);
        AreaDescriptor desc = door.descriptor;
        List<BlockPos> fillerList = desc.getContainedPositions(doorBlockOffsetPos);
        boolean bl = doPlaceDoor = !this.doesDescriptorIntersect(desc);
        if (!doPlaceDoor) {
            for (BlockPos fillerPos : fillerList) {
                world.m_46597_(fillerPos.m_142300_(doorFacing.m_122424_()), ((Block)BloodMagicBlocks.DUNGEON_BRICK_ASSORTED.get()).m_49966_());
            }
            world.m_46597_(doorBlockOffsetPos.m_142300_(doorFacing.m_122424_()), ((Block)BloodMagicBlocks.DUNGEON_BRICK_ASSORTED.get()).m_49966_());
            return false;
        }
        for (BlockPos fillerPos : fillerList) {
            world.m_46597_(fillerPos, ((Block)BloodMagicBlocks.DUNGEON_BRICK_ASSORTED.get()).m_49966_());
        }
        ResourceLocation specialRoomType = this.getSpecialRoom(newRoomDepth, specialRoomTypes);
        if (specialRoomType != null) {
            DungeonRoom randomRoom = DungeonSynthesizer.getRandomRoom(specialRoomType, world.f_46441_);
            if (randomRoom != null) {
                if (this.checkRequiredRoom(world, controllerPos, specialRoomType, doorBlockOffsetPos, randomRoom, world.f_46441_, doorBlockPos, doorFacing, doorType, newRoomDepth, highestBranchRoomDepth)) {
                    this.removeSpecialRoom(specialRoomType);
                    return true;
                }
            } else if (displayDetailedInformation) {
                System.out.println("Uh oh.");
            }
        }
        potentialRoomTypes = this.modifyRoomTypes(potentialRoomTypes);
        world.m_7731_(doorBlockOffsetPos, ((Block)BloodMagicBlocks.DUNGEON_SEAL.get()).m_49966_(), 3);
        BlockEntity tile = world.m_7702_(doorBlockOffsetPos);
        if (tile instanceof TileDungeonSeal) {
            ((TileDungeonSeal)tile).acceptDoorInformation(controllerPos, doorBlockPos, doorFacing, doorType, newRoomDepth, highestBranchRoomDepth, potentialRoomTypes);
        }
        return true;
    }

    public List<ResourceLocation> modifyRoomTypes(List<ResourceLocation> potentialRoomTypes) {
        ArrayList<ResourceLocation> modifiedRoomTypes = new ArrayList<ResourceLocation>(potentialRoomTypes);
        return modifiedRoomTypes;
    }

    public ResourceLocation getSpecialRoom(int currentRoomDepth, List<ResourceLocation> potentialSpecialRoomTypes) {
        if (potentialSpecialRoomTypes.isEmpty() || this.specialRoomBuffer.isEmpty()) {
            return null;
        }
        for (ResourceLocation resource : potentialSpecialRoomTypes) {
            if (!this.specialRoomBuffer.contains(resource)) continue;
            return resource;
        }
        return potentialSpecialRoomTypes.get(0);
    }

    public void removeSpecialRoom(ResourceLocation resource) {
        if (this.specialRoomBuffer.contains(resource)) {
            this.specialRoomBuffer.remove(resource);
        }
        this.placementsSinceLastSpecial.put(resource, 0);
    }

    public boolean checkRequiredRoom(ServerLevel world, BlockPos controllerPos, ResourceLocation specialRoomType, BlockPos doorBlockOffsetPos, DungeonRoom room, Random rand, BlockPos activatedDoorPos, Direction doorFacing, String activatedDoorType, int newRoomDepth, int highestBranchRoomDepth) {
        StructurePlaceSettings settings = new StructurePlaceSettings();
        Mirror mir = Mirror.NONE;
        settings.m_74377_(mir);
        Rotation rot = Rotation.NONE;
        settings.m_74379_(rot);
        settings.m_74392_(false);
        settings.m_74402_(true);
        DungeonRoom placedRoom = null;
        Pair activatedDoor = Pair.of((Object)doorFacing, (Object)activatedDoorPos);
        Pair addedDoor = null;
        BlockPos roomLocation = null;
        Direction oppositeDoorFacing = doorFacing.m_122424_();
        List rotationList = Rotation.m_55958_((Random)rand);
        Rotation finalRotation = null;
        block0: for (Rotation initialRotation : rotationList) {
            settings.m_74379_(initialRotation);
            List<BlockPos> otherDoorList = room.getDoorOffsetsForFacing(settings, activatedDoorType, oppositeDoorFacing, BlockPos.f_121853_);
            if (otherDoorList == null || otherDoorList.isEmpty()) continue;
            int doorIndex = rand.nextInt(otherDoorList.size());
            BlockPos testDoor = otherDoorList.get(doorIndex);
            roomLocation = activatedDoorPos.m_141950_((Vec3i)testDoor).m_141952_(doorFacing.m_122436_());
            List<AreaDescriptor> descriptors = room.getAreaDescriptors(settings, roomLocation);
            for (AreaDescriptor testDesc : descriptors) {
                for (AreaDescriptor currentDesc : this.descriptorList) {
                    if (!testDesc.intersects(currentDesc)) continue;
                    break block0;
                }
            }
            this.descriptorList.addAll(descriptors);
            addedDoor = Pair.of((Object)oppositeDoorFacing, (Object)testDoor.m_141952_((Vec3i)roomLocation));
            placedRoom = room;
            finalRotation = initialRotation;
            break;
        }
        if (placedRoom == null) {
            return false;
        }
        this.spawnDoorBlock(world, controllerPos, specialRoomType, doorBlockOffsetPos, doorFacing, activatedDoorPos, activatedDoorType, newRoomDepth, highestBranchRoomDepth, room, finalRotation, roomLocation);
        return true;
    }

    public void spawnDoorBlock(ServerLevel world, BlockPos controllerPos, ResourceLocation specialRoomType, BlockPos doorBlockOffsetPos, Direction doorFacing, BlockPos activatedDoorPos, String activatedDoorType, int roomDepth, int highestBranchRoomDepth, DungeonRoom room, Rotation rotation, BlockPos roomLocation) {
        world.m_7731_(doorBlockOffsetPos, SpecialDungeonRoomPoolRegistry.getSealBlockState(specialRoomType), 3);
        BlockEntity tile = world.m_7702_(doorBlockOffsetPos);
        if (tile instanceof TileSpecialRoomDungeonSeal) {
            ((TileSpecialRoomDungeonSeal)tile).acceptSpecificDoorInformation(world, controllerPos, specialRoomType, doorFacing, activatedDoorPos, activatedDoorType, roomDepth, highestBranchRoomDepth, room, rotation, roomLocation);
        }
    }

    public int addNewRoomToExistingDungeon(ServerLevel world, BlockPos controllerPos, ResourceLocation roomType, Random rand, BlockPos activatedDoorPos, Direction doorFacing, String activatedDoorType, List<ResourceLocation> potentialRooms, int activatedRoomDepth, int highestBranchRoomDepth) {
        for (int i = 0; i < 10; ++i) {
            boolean testPlacement = this.attemptPlacementOfRandomRoom(world, controllerPos, roomType, rand, activatedDoorPos, doorFacing, activatedDoorType, activatedRoomDepth, highestBranchRoomDepth, potentialRooms, false);
            if (!testPlacement) continue;
            return 0;
        }
        ResourceLocation pathPool = new ResourceLocation("bloodmagic:room_pools/connective_corridors");
        if (this.attemptPlacementOfRandomRoom(world, controllerPos, pathPool, rand, activatedDoorPos, doorFacing, activatedDoorType, activatedRoomDepth, highestBranchRoomDepth, potentialRooms, true)) {
            return 1;
        }
        return 2;
    }

    public boolean forcePlacementOfRoom(ServerLevel world, BlockPos controllerPos, Direction doorFacing, BlockPos activatedDoorPos, String activatedDoorType, int previousRoomDepth, int previousMaxDepth, DungeonRoom room, Rotation rotation, BlockPos roomLocation) {
        if (displayDetailedInformation) {
            System.out.println("Forcing room! Room is: " + room);
        }
        if (room == null) {
            return false;
        }
        StructurePlaceSettings settings = new StructurePlaceSettings();
        Mirror mir = Mirror.NONE;
        settings.m_74377_(mir);
        Rotation rot = Rotation.NONE;
        settings.m_74379_(rot);
        settings.m_74392_(false);
        settings.m_74402_(true);
        settings.m_74379_(rotation);
        DungeonRoom placedRoom = room;
        Pair activatedDoor = Pair.of((Object)doorFacing, (Object)activatedDoorPos);
        Pair addedDoor = null;
        Direction oppositeDoorFacing = doorFacing.m_122424_();
        addedDoor = Pair.of((Object)oppositeDoorFacing, (Object)activatedDoorPos.m_142300_(doorFacing));
        settings.m_74394_();
        settings.m_74383_((StructureProcessor)new StoneToOreProcessor(room.oreDensity));
        placedRoom.placeStructureAtPosition(world.f_46441_, settings, world, roomLocation);
        for (String doorType : placedRoom.doorMap.keySet()) {
            Direction addedDoorFace;
            if (!this.availableDoorMasterMap.containsKey(doorType)) {
                this.availableDoorMasterMap.put(doorType, new HashMap());
            }
            Map<Direction, List<BlockPos>> availableDoorMap = this.availableDoorMasterMap.get(doorType);
            for (Direction facing : Direction.values()) {
                if (!availableDoorMap.containsKey(facing)) {
                    availableDoorMap.put(facing, new ArrayList());
                }
                List<BlockPos> doorList = availableDoorMap.get(facing);
                doorList.addAll(placedRoom.getDoorOffsetsForFacing(settings, doorType, facing, roomLocation));
            }
            if (!doorType.equals(activatedDoorType)) continue;
            Direction activatedDoorFace = (Direction)activatedDoor.getKey();
            if (availableDoorMap.containsKey(activatedDoorFace)) {
                availableDoorMap.get(activatedDoorFace).remove(activatedDoor.getRight());
            }
            if (!availableDoorMap.containsKey(addedDoorFace = (Direction)addedDoor.getKey())) continue;
            availableDoorMap.get(addedDoorFace).remove(addedDoor.getRight());
        }
        List<DungeonDoor> doorTypeMap = placedRoom.getPotentialConnectedRoomTypes(settings, roomLocation);
        Collections.shuffle(doorTypeMap);
        boolean addedHigherPath = false;
        for (DungeonDoor dungeonDoor : doorTypeMap) {
            if (((Direction)addedDoor.getKey()).equals((Object)dungeonDoor.doorDir) && ((BlockPos)addedDoor.getRight()).equals((Object)dungeonDoor.doorPos)) continue;
            int newRoomDepth = previousRoomDepth + (addedHigherPath ? world.f_46441_.nextInt(2) * 2 - 1 : 1);
            addedHigherPath = true;
            if (displayDetailedInformation) {
                System.out.println("Room list: " + dungeonDoor.getRoomList());
            }
            this.addNewDoorBlock(dungeonDoor, world, controllerPos, dungeonDoor.doorPos, dungeonDoor.doorDir, dungeonDoor.doorType, newRoomDepth, previousMaxDepth, dungeonDoor.getRoomList(), dungeonDoor.getSpecialRoomList());
        }
        return true;
    }

    public DungeonRoomPlacement getRandomPlacement(ServerLevel world, BlockPos controllerPos, ResourceLocation roomType, Random rand, BlockPos activatedDoorPos, Direction doorFacing, String activatedDoorType, int previousRoomDepth, int previousMaxDepth, List<ResourceLocation> potentialRooms, boolean extendCorriDoors) {
        StructurePlaceSettings settings = new StructurePlaceSettings();
        Mirror mir = Mirror.NONE;
        settings.m_74377_(mir);
        Rotation rot = Rotation.NONE;
        settings.m_74379_(rot);
        settings.m_74392_(false);
        settings.m_74402_(true);
        DungeonRoom placedRoom = null;
        Pair addedDoor = null;
        BlockPos roomLocation = null;
        Direction oppositeDoorFacing = doorFacing.m_122424_();
        DungeonRoom testingRoom = DungeonSynthesizer.getRandomRoom(roomType, rand);
        if (displayDetailedInformation) {
            System.out.println("Room type: " + roomType);
        }
        List rotationList = Rotation.m_55958_((Random)rand);
        block0: for (Rotation initialRotation : rotationList) {
            settings.m_74379_(initialRotation);
            List<BlockPos> otherDoorList = testingRoom.getDoorOffsetsForFacing(settings, activatedDoorType, oppositeDoorFacing, BlockPos.f_121853_);
            if (otherDoorList == null || otherDoorList.isEmpty()) continue;
            int doorIndex = rand.nextInt(otherDoorList.size());
            BlockPos testDoor = otherDoorList.get(doorIndex);
            roomLocation = activatedDoorPos.m_141950_((Vec3i)testDoor).m_141952_(doorFacing.m_122436_());
            List<AreaDescriptor> descriptors = testingRoom.getAreaDescriptors(settings, roomLocation);
            for (AreaDescriptor testDesc : descriptors) {
                for (AreaDescriptor currentDesc : this.descriptorList) {
                    if (!testDesc.intersects(currentDesc)) continue;
                    break block0;
                }
            }
            settings.m_74394_();
            settings.m_74383_((StructureProcessor)new StoneToOreProcessor(testingRoom.oreDensity));
            addedDoor = Pair.of((Object)oppositeDoorFacing, (Object)testDoor.m_141952_((Vec3i)roomLocation));
            placedRoom = testingRoom;
            return new DungeonRoomPlacement(testingRoom, world, settings, roomLocation, (Pair<Direction, BlockPos>)addedDoor);
        }
        if (placedRoom == null) {
            return null;
        }
        return null;
    }

    public boolean attemptPlacementOfRandomRoom(ServerLevel world, BlockPos controllerPos, ResourceLocation roomType, Random rand, BlockPos activatedDoorPos, Direction doorFacing, String activatedDoorType, int previousRoomDepth, int previousMaxDepth, List<ResourceLocation> potentialRooms, boolean extendCorriDoors) {
        Pair activatedDoor = Pair.of((Object)doorFacing, (Object)activatedDoorPos);
        DungeonRoomPlacement placement = this.getRandomPlacement(world, controllerPos, roomType, rand, activatedDoorPos, doorFacing, activatedDoorType, previousRoomDepth, previousMaxDepth, potentialRooms, extendCorriDoors);
        if (placement == null) {
            return false;
        }
        Pair<Direction, BlockPos> addedDoor = placement.getEntrance();
        this.descriptorList.addAll(placement.getAreaDescriptors());
        placement.placeStructure();
        ++this.activatedDoors;
        this.checkSpecialRoomRequirements(previousRoomDepth);
        for (String doorType : placement.getAllRoomTypes()) {
            Direction addedDoorFace;
            if (!this.availableDoorMasterMap.containsKey(doorType)) {
                this.availableDoorMasterMap.put(doorType, new HashMap());
            }
            Map<Direction, List<BlockPos>> availableDoorMap = this.availableDoorMasterMap.get(doorType);
            for (Direction facing : Direction.values()) {
                if (!availableDoorMap.containsKey(facing)) {
                    availableDoorMap.put(facing, new ArrayList());
                }
                List<BlockPos> doorList = availableDoorMap.get(facing);
                doorList.addAll(placement.getDoorOffsetsForFacing(doorType, facing));
            }
            if (!doorType.equals(activatedDoorType)) continue;
            Direction activatedDoorFace = (Direction)activatedDoor.getKey();
            if (availableDoorMap.containsKey(activatedDoorFace)) {
                availableDoorMap.get(activatedDoorFace).remove(activatedDoor.getRight());
            }
            if (!availableDoorMap.containsKey(addedDoorFace = (Direction)addedDoor.getKey())) continue;
            availableDoorMap.get(addedDoorFace).remove(addedDoor.getRight());
        }
        List<DungeonDoor> doorTypeMap = placement.getPotentialConnectedRoomTypes();
        Collections.shuffle(doorTypeMap);
        boolean addedHigherPath = false;
        for (DungeonDoor dungeonDoor : doorTypeMap) {
            List<ResourceLocation> roomList;
            if (((Direction)addedDoor.getKey()).equals((Object)dungeonDoor.doorDir) && ((BlockPos)addedDoor.getRight()).equals((Object)dungeonDoor.doorPos)) continue;
            if (extendCorriDoors) {
                this.addNewDoorBlock(dungeonDoor, world, controllerPos, dungeonDoor.doorPos, dungeonDoor.doorDir, activatedDoorType, previousRoomDepth, previousMaxDepth, potentialRooms, new ArrayList<ResourceLocation>());
                continue;
            }
            int newRoomDepth = previousRoomDepth + (addedHigherPath ? world.f_46441_.nextInt(2) * 2 - 1 : 1);
            if (displayDetailedInformation) {
                System.out.println("Room list: " + dungeonDoor.getRoomList());
            }
            if (!this.addNewDoorBlock(dungeonDoor, world, controllerPos, dungeonDoor.doorPos, dungeonDoor.doorDir, dungeonDoor.doorType, newRoomDepth, previousMaxDepth, roomList = dungeonDoor.isDeadend(newRoomDepth, previousMaxDepth) ? dungeonDoor.getDeadendRoomList() : dungeonDoor.getRoomList(), dungeonDoor.getSpecialRoomList())) continue;
            addedHigherPath = true;
        }
        return true;
    }

    public void checkSpecialRoomRequirements(int currentRoomDepth) {
        for (ResourceLocation res : this.placementsSinceLastSpecial.keySet()) {
            this.placementsSinceLastSpecial.put(res, this.placementsSinceLastSpecial.get(res) + 1);
        }
        List<ResourceLocation> newSpecialPools = SpecialDungeonRoomPoolRegistry.getSpecialRooms(this.activatedDoors, currentRoomDepth, this.placementsSinceLastSpecial, this.specialRoomBuffer);
        for (ResourceLocation newSpecialPool : newSpecialPools) {
            if (this.specialRoomBuffer.contains(newSpecialPool)) continue;
            this.specialRoomBuffer.add(newSpecialPool);
        }
    }

    public static DungeonRoom getRandomRoom(ResourceLocation roomType, Random rand) {
        return DungeonRoomRegistry.getRandomDungeonRoom(roomType, rand);
    }

    public static DungeonRoom getDungeonRoom(ResourceLocation dungeonName) {
        return DungeonRoomRegistry.getDungeonRoom(dungeonName);
    }
}

