/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.ritual.types;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import wayoftime.bloodmagic.ConfigManager;
import wayoftime.bloodmagic.common.block.BlockInversionPillarEnd;
import wayoftime.bloodmagic.common.block.BloodMagicBlocks;
import wayoftime.bloodmagic.common.block.type.PillarCapType;
import wayoftime.bloodmagic.common.dimension.DungeonDimensionHelper;
import wayoftime.bloodmagic.common.item.ItemActivationCrystal;
import wayoftime.bloodmagic.common.tile.TileInversionPillar;
import wayoftime.bloodmagic.ritual.EnumRuneType;
import wayoftime.bloodmagic.ritual.IMasterRitualStone;
import wayoftime.bloodmagic.ritual.Ritual;
import wayoftime.bloodmagic.ritual.RitualComponent;
import wayoftime.bloodmagic.structures.DungeonSynthesizer;
import wayoftime.bloodmagic.util.helper.NetworkHelper;

public class RitualStandardDungeon
extends Ritual {
    public RitualStandardDungeon() {
        super("ritualStandardDungeon", 0, 80000, "ritual.bloodmagic.standardDungeonRitual");
    }

    @Override
    public boolean activateRitual(IMasterRitualStone masterRitualStone, Player player, UUID owner) {
        if (((Boolean)ConfigManager.COMMON.makeDungeonRitualCreativeOnly.get()).booleanValue()) {
            ItemStack heldStack = player.m_21211_();
            if (heldStack.m_41720_() instanceof ItemActivationCrystal) {
                int crystalLevel = ((ItemActivationCrystal)heldStack.m_41720_()).getCrystalLevel(heldStack);
                return crystalLevel == Integer.MAX_VALUE;
            }
            return false;
        }
        return true;
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        Level world = masterRitualStone.getWorldObj();
        int currentEssence = masterRitualStone.getOwnerNetwork().getCurrentEssence();
        BlockPos masterPos = masterRitualStone.getMasterBlockPos();
        if (!world.f_46443_ && world instanceof ServerLevel) {
            ServerLevel dungeonWorld = DungeonDimensionHelper.getDungeonWorld(world);
            if (dungeonWorld != null) {
                ArrayList components = Lists.newArrayList();
                this.gatherComponents(components::add);
                for (RitualComponent component : components) {
                    BlockPos newPos = masterPos.m_141952_((Vec3i)component.getOffset(masterRitualStone.getDirection()));
                    world.m_46597_(newPos, Blocks.f_50470_.m_49966_());
                }
                BlockPos dungeonSpawnLocation = NetworkHelper.getSpawnPositionOfDungeon();
                DungeonSynthesizer dungeon = new DungeonSynthesizer();
                ResourceLocation initialType = new ResourceLocation("bloodmagic:room_pools/entrances/standard_dungeon_entrances");
                BlockPos[] positions = dungeon.generateInitialRoom(initialType, world.f_46441_, dungeonWorld, dungeonSpawnLocation);
                BlockPos pillarPos = masterPos.m_5484_(Direction.UP, 2);
                BlockPos safePlayerPosition = positions[0];
                BlockPos dungeonPortalPos = positions[1];
                BlockPos overworldPlayerPos = masterPos.m_142300_(Direction.UP).m_5484_(masterRitualStone.getDirection(), 2);
                this.spawnPortalPillar(world, (Level)dungeonWorld, pillarPos, safePlayerPosition);
                this.spawnPortalPillar((Level)dungeonWorld, world, dungeonPortalPos, overworldPlayerPos);
                LightningBolt lightningboltentity = (LightningBolt)EntityType.f_20465_.m_20615_(world);
                lightningboltentity.m_6034_((double)masterPos.m_123341_(), (double)(masterPos.m_123342_() + 1), (double)masterPos.m_123343_());
                lightningboltentity.m_20874_(true);
                world.m_7967_((Entity)lightningboltentity);
                NetworkHelper.incrementDungeonCounter();
            }
            world.m_46597_(masterPos, Blocks.f_50016_.m_49966_());
        }
    }

    public void spawnPortalPillar(Level spawnWorld, Level destinationWorld, BlockPos pillarPos, BlockPos safePlayerPos) {
        spawnWorld.m_46597_(pillarPos, ((Block)BloodMagicBlocks.INVERSION_PILLAR.get()).m_49966_());
        BlockEntity tile = spawnWorld.m_7702_(pillarPos);
        if (tile instanceof TileInversionPillar) {
            TileInversionPillar tileInversion = (TileInversionPillar)tile;
            tileInversion.setDestination(destinationWorld, safePlayerPos);
            spawnWorld.m_46597_(pillarPos.m_142300_(Direction.DOWN), (BlockState)((Block)BloodMagicBlocks.INVERSION_PILLAR_CAP.get()).m_49966_().m_61124_(BlockInversionPillarEnd.TYPE, (Comparable)((Object)PillarCapType.BOTTOM)));
            spawnWorld.m_46597_(pillarPos.m_142300_(Direction.UP), (BlockState)((Block)BloodMagicBlocks.INVERSION_PILLAR_CAP.get()).m_49966_().m_61124_(BlockInversionPillarEnd.TYPE, (Comparable)((Object)PillarCapType.TOP)));
        }
    }

    @Override
    public int getRefreshTime() {
        return 1;
    }

    @Override
    public int getRefreshCost() {
        return 0;
    }

    @Override
    public void gatherComponents(Consumer<RitualComponent> components) {
        this.addParallelRunes(components, 1, 4, EnumRuneType.AIR);
        this.addParallelRunes(components, 2, 4, EnumRuneType.EARTH);
        this.addCornerRunes(components, 1, 0, EnumRuneType.EARTH);
        this.addParallelRunes(components, 2, 0, EnumRuneType.EARTH);
        this.addCornerRunes(components, 2, 0, EnumRuneType.FIRE);
        for (int i = -1; i <= 1; ++i) {
            this.addRune(components, i, 0, 3, EnumRuneType.WATER);
            this.addRune(components, i, 0, -3, EnumRuneType.WATER);
            this.addRune(components, 3, 0, i, EnumRuneType.FIRE);
            this.addRune(components, -3, 0, i, EnumRuneType.FIRE);
        }
        for (int j = 1; j <= 4; ++j) {
            this.addRune(components, 0, j, 0, EnumRuneType.DUSK);
        }
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualStandardDungeon();
    }
}

