/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.ritual.harvest;

import java.util.Collection;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AttachedStemBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import wayoftime.bloodmagic.ritual.harvest.HarvestRegistry;
import wayoftime.bloodmagic.ritual.harvest.IHarvestHandler;

public class HarvestHandlerStem
implements IHarvestHandler {
    private static final ItemStack mockHoe = new ItemStack((ItemLike)Items.f_42392_, 1);

    public HarvestHandlerStem() {
        for (int i = 0; i < 4; ++i) {
            Direction facing = Direction.m_122407_((int)i);
            HarvestRegistry.registerStemCrop(Blocks.f_50133_.m_49966_(), (BlockState)Blocks.f_50187_.m_49966_().m_61124_((Property)AttachedStemBlock.f_48830_, (Comparable)facing));
            HarvestRegistry.registerStemCrop(Blocks.f_50186_.m_49966_(), (BlockState)Blocks.f_50188_.m_49966_().m_61124_((Property)AttachedStemBlock.f_48830_, (Comparable)facing));
        }
    }

    @Override
    public boolean harvest(Level world, BlockPos pos, BlockState state, List<ItemStack> drops) {
        Direction cropDir = (Direction)state.m_61143_((Property)AttachedStemBlock.f_48830_);
        if (cropDir != Direction.UP) {
            BlockPos cropPos = pos.m_142300_(cropDir);
            BlockState probableCrop = world.m_8055_(cropPos);
            Collection registeredCrops = HarvestRegistry.getStemCrops().get((Object)state);
            for (BlockState registeredCrop : registeredCrops) {
                if (registeredCrop != probableCrop) continue;
                LootContext.Builder lootBuilder = new LootContext.Builder((ServerLevel)world);
                Vec3 blockCenter = new Vec3((double)cropPos.m_123341_() + 0.5, (double)cropPos.m_123342_() + 0.5, (double)cropPos.m_123343_() + 0.5);
                List blockDrops = registeredCrop.m_60724_(lootBuilder.m_78972_(LootContextParams.f_81460_, (Object)blockCenter).m_78972_(LootContextParams.f_81463_, (Object)mockHoe));
                drops.addAll(blockDrops);
                world.m_46961_(cropPos, false);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean test(Level world, BlockPos pos, BlockState state) {
        return HarvestRegistry.getStemCrops().containsKey((Object)state);
    }
}

