/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.ritual.harvest;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import wayoftime.bloodmagic.common.block.BloodMagicBlocks;
import wayoftime.bloodmagic.ritual.harvest.HarvestRegistry;
import wayoftime.bloodmagic.ritual.harvest.IHarvestHandler;
import wayoftime.bloodmagic.util.BMLog;

public class HarvestHandlerPlantable
implements IHarvestHandler {
    private static final ItemStack mockHoe = new ItemStack((ItemLike)Items.f_42392_, 1);

    public HarvestHandlerPlantable() {
        HarvestRegistry.registerStandardCrop(Blocks.f_50249_, 7);
        HarvestRegistry.registerStandardCrop(Blocks.f_50092_, 7);
        HarvestRegistry.registerStandardCrop(Blocks.f_50250_, 7);
        HarvestRegistry.registerStandardCrop(Blocks.f_50444_, 3);
        HarvestRegistry.registerStandardCrop(Blocks.f_50200_, 3);
        HarvestRegistry.registerStandardCrop((Block)BloodMagicBlocks.GROWING_DOUBT.get(), 7);
        HarvestRegistry.registerStandardCrop((Block)BloodMagicBlocks.WEAK_TAU.get(), 7);
        HarvestRegistry.registerStandardCrop((Block)BloodMagicBlocks.STRONG_TAU.get(), 7);
        HarvestHandlerPlantable.addThirdPartyCrop("actuallyadditions", "flax_block", 7);
        HarvestHandlerPlantable.addThirdPartyCrop("actuallyadditions", "canola_block", 7);
        HarvestHandlerPlantable.addThirdPartyCrop("actuallyadditions", "rice_block", 7);
        HarvestHandlerPlantable.addThirdPartyCrop("extrautils2", "redorchid", 6);
        HarvestHandlerPlantable.addThirdPartyCrop("extrautils2", "enderlily", 7);
        HarvestHandlerPlantable.addThirdPartyCrop("roots", "moonglow", 7);
        HarvestHandlerPlantable.addThirdPartyCrop("roots", "terra_moss", 7);
        HarvestHandlerPlantable.addThirdPartyCrop("roots", "pereskia", 7);
        HarvestHandlerPlantable.addThirdPartyCrop("roots", "wildroot", 7);
        HarvestHandlerPlantable.addThirdPartyCrop("roots", "aubergine", 7);
        HarvestHandlerPlantable.addThirdPartyCrop("roots", "spirit_herb", 7);
        HarvestHandlerPlantable.addPamCrops();
        HarvestHandlerPlantable.addMysticalCrops();
    }

    @Override
    public boolean harvest(Level world, BlockPos pos, BlockState state, List<ItemStack> drops) {
        boolean foundSeed = false;
        LootContext.Builder lootBuilder = new LootContext.Builder((ServerLevel)world);
        Vec3 blockCenter = new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
        List blockDrops = state.m_60724_(lootBuilder.m_78972_(LootContextParams.f_81460_, (Object)blockCenter).m_78972_(LootContextParams.f_81463_, (Object)mockHoe));
        for (ItemStack stack : blockDrops) {
            if (stack.m_41619_() || !(stack.m_41720_() instanceof BlockItem) || ((BlockItem)stack.m_41720_()).m_40614_() != state.m_60734_()) continue;
            stack.m_41774_(1);
            foundSeed = true;
            break;
        }
        if (foundSeed) {
            world.m_46597_(pos, state.m_60734_().m_49966_());
            world.m_46796_(2001, pos, Block.m_49956_((BlockState)state));
            for (ItemStack stack : blockDrops) {
                if (stack.m_41619_()) continue;
                drops.add(stack);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean test(Level world, BlockPos pos, BlockState state) {
        return HarvestRegistry.getStandardCrops().containsKey(state.m_60734_()) && state.m_60734_() instanceof CropBlock && ((CropBlock)state.m_60734_()).m_52307_(state);
    }

    private static void addThirdPartyCrop(String modid, String regName, int matureMeta) {
        if (!ModList.get().isLoaded(modid)) {
            return;
        }
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(modid, regName));
        if (block != null && block != Blocks.f_50016_) {
            HarvestRegistry.registerStandardCrop(block, matureMeta);
        }
    }

    private static void addPamCrops() {
        if (!ModList.get().isLoaded("harvestcraft")) {
            return;
        }
        try {
            Class<?> pamRegistry = Class.forName("com.pam.harvestcraft.blocks.CropRegistry");
            Field names = pamRegistry.getDeclaredField("cropNames");
            Method getCrop = pamRegistry.getMethod("getCrop", String.class);
            for (String name : (String[])names.get(null)) {
                CropBlock crop = (CropBlock)getCrop.invoke(null, name);
                HarvestRegistry.registerStandardCrop((Block)crop, crop.m_7419_());
            }
        }
        catch (ClassNotFoundException e) {
            BMLog.DEFAULT.error("HarvestCraft integration cancelled; unable to find registry class", new Object[0]);
        }
        catch (NoSuchFieldException | NoSuchMethodException e) {
            BMLog.DEFAULT.error("HarvestCraft integration cancelled; unable to find crop name mapper", new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            BMLog.DEFAULT.error("HarvestCraft integration cancelled; crop name lookup broke", new Object[0]);
        }
    }

    private static void addMysticalCrops() {
        if (!ModList.get().isLoaded("mysticalagriculture")) {
            return;
        }
        try {
            Class<?> mysticalAPI = Class.forName("com.blakebr0.mysticalagriculture.api.MysticalAgricultureAPI");
            Method getRegistry = mysticalAPI.getMethod("getCropRegistry", new Class[0]);
            Object registry = getRegistry.invoke(null, new Object[0]);
            Class<?> mysticalRegistry = Class.forName("com.blakebr0.mysticalagriculture.api.registry.ICropRegistry");
            Method getCrops = mysticalRegistry.getMethod("getCrops", new Class[0]);
            List crops = (List)getCrops.invoke(registry, new Object[0]);
            Class<?> mysticalCrop = Class.forName("com.blakebr0.mysticalagriculture.api.crop.ICrop");
            Method getCrop = mysticalCrop.getMethod("getCrop", new Class[0]);
            for (Object maCrop : crops) {
                CropBlock crop = (CropBlock)getCrop.invoke(maCrop, new Object[0]);
                HarvestRegistry.registerStandardCrop((Block)crop, crop.m_7419_());
            }
        }
        catch (ClassNotFoundException e) {
            BMLog.DEFAULT.error("MysticalAgriculture integration cancelled: unable to find a class: " + e.getMessage(), new Object[0]);
        }
        catch (NoSuchMethodException e) {
            BMLog.DEFAULT.error("MysticalAgriculture integration cancelled: unable to find a method: " + e.getMessage(), new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            BMLog.DEFAULT.error("MysticalAgriculture integration cancelled: failed to invoke a method: " + e.getMessage(), new Object[0]);
        }
    }
}

