/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;
import wayoftime.bloodmagic.common.tile.TileAlchemicalReactionChamber;

public class ARCTanksPacket {
    private BlockPos pos;
    private CompoundTag inputNBT;
    private CompoundTag outputNBT;

    public ARCTanksPacket() {
        this.pos = BlockPos.f_121853_;
        this.inputNBT = new CompoundTag();
        this.outputNBT = new CompoundTag();
    }

    public ARCTanksPacket(TileAlchemicalReactionChamber tile) {
        this(tile.m_58899_(), tile.inputTank.writeToNBT(new CompoundTag()), tile.outputTank.writeToNBT(new CompoundTag()));
    }

    public ARCTanksPacket(BlockPos pos, CompoundTag inputNBT, CompoundTag outputNBT) {
        this.pos = pos;
        this.inputNBT = inputNBT;
        this.outputNBT = outputNBT;
    }

    public static void encode(ARCTanksPacket pkt, FriendlyByteBuf buf) {
        buf.m_130064_(pkt.pos);
        buf.m_130079_(pkt.inputNBT);
        buf.m_130079_(pkt.outputNBT);
    }

    public static ARCTanksPacket decode(FriendlyByteBuf buf) {
        ARCTanksPacket pkt = new ARCTanksPacket(buf.m_130135_(), buf.m_130260_(), buf.m_130260_());
        return pkt;
    }

    public static void handle(ARCTanksPacket message, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> ARCTanksPacket.updateTanks(message.pos, message.inputNBT, message.outputNBT));
        context.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void updateTanks(BlockPos pos, CompoundTag inputNBT, CompoundTag outputNBT) {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof TileAlchemicalReactionChamber) {
            ((TileAlchemicalReactionChamber)tile).inputTank.readFromNBT(inputNBT);
            ((TileAlchemicalReactionChamber)tile).outputTank.readFromNBT(outputNBT);
        }
    }
}

