/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.loot;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import wayoftime.bloodmagic.anointment.Anointment;
import wayoftime.bloodmagic.anointment.AnointmentHolder;
import wayoftime.bloodmagic.core.AnointmentRegistrar;

public class GlobalLootModifier {
    public static final DeferredRegister<GlobalLootModifierSerializer<?>> GLM = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.LOOT_MODIFIER_SERIALIZERS, (String)"bloodmagic");
    public static final RegistryObject<SilkTouchTestModifier.Serializer> SILKTOUCH = GLM.register("silk_touch_bamboo", SilkTouchTestModifier.Serializer::new);
    public static final RegistryObject<FortuneModifier.Serializer> FORTUNE = GLM.register("fortune", FortuneModifier.Serializer::new);
    public static final RegistryObject<LootingModifier.Serializer> LOOTING = GLM.register("looting", LootingModifier.Serializer::new);
    public static final RegistryObject<SmeltingModifier.Serializer> SMELT = GLM.register("smelt", SmeltingModifier.Serializer::new);

    private static class SmeltingModifier
    extends LootModifier {
        public SmeltingModifier(LootItemCondition[] conditionsIn) {
            super(conditionsIn);
        }

        @Nonnull
        public List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
            ItemStack ctxTool = (ItemStack)context.m_78953_(LootContextParams.f_81463_);
            if (ctxTool.m_41783_() == null) {
                return generatedLoot;
            }
            AnointmentHolder holder = AnointmentHolder.fromItemStack(ctxTool);
            if (holder == null) {
                return generatedLoot;
            }
            int smeltingLevel = holder.getAnointmentLevel((Anointment)((Object)AnointmentRegistrar.ANOINTMENT_SMELTING.get()));
            if (smeltingLevel <= 0) {
                return generatedLoot;
            }
            ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
            generatedLoot.forEach(stack -> ret.add(SmeltingModifier.smelt(stack, context)));
            return ret;
        }

        private static ItemStack smelt(ItemStack stack, LootContext context) {
            return context.m_78952_().m_7465_().m_44015_(RecipeType.f_44108_, (Container)new SimpleContainer(new ItemStack[]{stack}), (Level)context.m_78952_()).map(AbstractCookingRecipe::m_8043_).filter(itemStack -> !itemStack.m_41619_()).map(itemStack -> ItemHandlerHelper.copyStackWithSize((ItemStack)itemStack, (int)(stack.m_41613_() * itemStack.m_41613_()))).orElse(stack);
        }

        private static class Serializer
        extends GlobalLootModifierSerializer<SmeltingModifier> {
            private Serializer() {
            }

            public SmeltingModifier read(ResourceLocation name, JsonObject json, LootItemCondition[] conditionsIn) {
                return new SmeltingModifier(conditionsIn);
            }

            public JsonObject write(SmeltingModifier instance) {
                return this.makeConditions(instance.conditions);
            }
        }
    }

    private static class LootingModifier
    extends LootModifier {
        public LootingModifier(LootItemCondition[] conditionsIn) {
            super(conditionsIn);
        }

        @Nonnull
        public List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
            return generatedLoot;
        }

        private static class Serializer
        extends GlobalLootModifierSerializer<LootingModifier> {
            private Serializer() {
            }

            public LootingModifier read(ResourceLocation name, JsonObject json, LootItemCondition[] conditionsIn) {
                return new LootingModifier(conditionsIn);
            }

            public JsonObject write(LootingModifier instance) {
                return this.makeConditions(instance.conditions);
            }
        }
    }

    private static class FortuneModifier
    extends LootModifier {
        public FortuneModifier(LootItemCondition[] conditionsIn) {
            super(conditionsIn);
        }

        @Nonnull
        public List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
            ItemStack ctxTool = (ItemStack)context.m_78953_(LootContextParams.f_81463_);
            if (ctxTool.m_41783_() != null && ctxTool.m_41783_().m_128471_("bloodmagic:checked_fortune")) {
                return generatedLoot;
            }
            if (EnchantmentHelper.m_44831_((ItemStack)ctxTool).containsKey(Enchantments.f_44985_)) {
                return generatedLoot;
            }
            AnointmentHolder holder = AnointmentHolder.fromItemStack(ctxTool);
            if (holder == null) {
                return generatedLoot;
            }
            int additionalFortune = holder.getAnointmentLevel((Anointment)((Object)AnointmentRegistrar.ANOINTMENT_FORTUNE.get()));
            if (additionalFortune <= 0) {
                return generatedLoot;
            }
            ItemStack fakeTool = ctxTool.m_41777_();
            fakeTool.m_41784_().m_128379_("bloodmagic:checked_fortune", true);
            int baseFortuneLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44987_, (ItemStack)ctxTool);
            fakeTool.m_41663_(Enchantments.f_44987_, baseFortuneLevel + additionalFortune);
            LootContext.Builder builder = new LootContext.Builder(context);
            builder.m_78972_(LootContextParams.f_81463_, (Object)fakeTool);
            LootContext ctx = builder.m_78975_(LootContextParamSets.f_81421_);
            LootTable loottable = context.m_78952_().m_142572_().m_129898_().m_79217_(((BlockState)context.m_78953_(LootContextParams.f_81461_)).m_60734_().m_60589_());
            return loottable.m_79129_(ctx);
        }

        private static class Serializer
        extends GlobalLootModifierSerializer<FortuneModifier> {
            private Serializer() {
            }

            public FortuneModifier read(ResourceLocation name, JsonObject json, LootItemCondition[] conditionsIn) {
                return new FortuneModifier(conditionsIn);
            }

            public JsonObject write(FortuneModifier instance) {
                return this.makeConditions(instance.conditions);
            }
        }
    }

    private static class SilkTouchTestModifier
    extends LootModifier {
        public SilkTouchTestModifier(LootItemCondition[] conditionsIn) {
            super(conditionsIn);
        }

        @Nonnull
        public List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
            ItemStack ctxTool = (ItemStack)context.m_78953_(LootContextParams.f_81463_);
            if (EnchantmentHelper.m_44831_((ItemStack)ctxTool).containsKey(Enchantments.f_44985_)) {
                return generatedLoot;
            }
            AnointmentHolder holder = AnointmentHolder.fromItemStack(ctxTool);
            if (holder == null || holder.getAnointmentLevel((Anointment)((Object)AnointmentRegistrar.ANOINTMENT_SILK_TOUCH.get())) <= 0) {
                return generatedLoot;
            }
            ItemStack fakeTool = ctxTool.m_41777_();
            fakeTool.m_41663_(Enchantments.f_44985_, 1);
            LootContext.Builder builder = new LootContext.Builder(context);
            builder.m_78972_(LootContextParams.f_81463_, (Object)fakeTool);
            LootContext ctx = builder.m_78975_(LootContextParamSets.f_81421_);
            LootTable loottable = context.m_78952_().m_142572_().m_129898_().m_79217_(((BlockState)context.m_78953_(LootContextParams.f_81461_)).m_60734_().m_60589_());
            return loottable.m_79129_(ctx);
        }

        private static class Serializer
        extends GlobalLootModifierSerializer<SilkTouchTestModifier> {
            private Serializer() {
            }

            public SilkTouchTestModifier read(ResourceLocation name, JsonObject json, LootItemCondition[] conditionsIn) {
                return new SilkTouchTestModifier(conditionsIn);
            }

            public JsonObject write(SilkTouchTestModifier instance) {
                return this.makeConditions(instance.conditions);
            }
        }
    }
}

