/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.gson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import wayoftime.bloodmagic.api.compat.EnumDemonWillType;
import wayoftime.bloodmagic.gson.SerializerBase;

public class Serializers {
    public static final EntityDataSerializer<EnumDemonWillType> WILL_TYPE_SERIALIZER = new EntityDataSerializer<EnumDemonWillType>(){

        public void write(FriendlyByteBuf buf, EnumDemonWillType value) {
            buf.m_130068_((Enum)value);
        }

        public EnumDemonWillType read(FriendlyByteBuf buf) {
            return (EnumDemonWillType)buf.m_130066_(EnumDemonWillType.class);
        }

        public EntityDataAccessor<EnumDemonWillType> m_135021_(int id) {
            return new EntityDataAccessor(id, (EntityDataSerializer)this);
        }

        public EnumDemonWillType copy(EnumDemonWillType value) {
            return EnumDemonWillType.valueOf(value.name());
        }
    };
    public static final SerializerBase<Direction> FACING_SERIALIZER = new SerializerBase<Direction>(){

        @Override
        public Class<Direction> getType() {
            return Direction.class;
        }

        @Override
        public Direction deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return Direction.m_122402_((String)json.getAsString());
        }
    };
    public static final SerializerBase<ResourceLocation> RESOURCELOCATION_SERIALIZER = new SerializerBase<ResourceLocation>(){

        @Override
        public Class<ResourceLocation> getType() {
            return ResourceLocation.class;
        }

        @Override
        public ResourceLocation deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            String domain = json.getAsJsonObject().get("domain").getAsString();
            String path = json.getAsJsonObject().get("path").getAsString();
            return new ResourceLocation(domain, path);
        }

        @Override
        public JsonElement serialize(ResourceLocation src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject object = new JsonObject();
            object.addProperty("domain", src.m_135827_());
            object.addProperty("path", src.m_135815_());
            return object;
        }
    };
    public static final SerializerBase<ItemStack> ITEMMETA_SERIALIZER = new SerializerBase<ItemStack>(){

        @Override
        public Class<ItemStack> getType() {
            return ItemStack.class;
        }

        @Override
        public ItemStack deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            ResourceLocation registryName = (ResourceLocation)context.deserialize((JsonElement)json.getAsJsonObject().get("registryName").getAsJsonObject(), ResourceLocation.class);
            int meta = json.getAsJsonObject().get("meta").getAsInt();
            return new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(registryName), 1);
        }

        @Override
        public JsonElement serialize(ItemStack src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.add("registryName", context.serialize((Object)src.m_41720_().getRegistryName()));
            jsonObject.addProperty("meta", (Number)src.m_41773_());
            return jsonObject;
        }
    };
    public static final SerializerBase<BlockPos> BLOCKPOS_SERIALIZER = new SerializerBase<BlockPos>(){

        @Override
        public Class<BlockPos> getType() {
            return BlockPos.class;
        }

        @Override
        public BlockPos deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            int x = json.getAsJsonObject().get("x").getAsInt();
            int y = json.getAsJsonObject().get("y").getAsInt();
            int z = json.getAsJsonObject().get("z").getAsInt();
            return new BlockPos(x, y, z);
        }

        @Override
        public JsonElement serialize(BlockPos src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject object = new JsonObject();
            object.addProperty("x", (Number)src.m_123341_());
            object.addProperty("y", (Number)src.m_123342_());
            object.addProperty("z", (Number)src.m_123343_());
            return object;
        }
    };
    public static final Gson GSON = new GsonBuilder().serializeNulls().setPrettyPrinting().disableHtmlEscaping().registerTypeAdapter(FACING_SERIALIZER.getType(), FACING_SERIALIZER).registerTypeAdapter(RESOURCELOCATION_SERIALIZER.getType(), RESOURCELOCATION_SERIALIZER).registerTypeAdapter(ITEMMETA_SERIALIZER.getType(), ITEMMETA_SERIALIZER).registerTypeAdapter(BLOCKPOS_SERIALIZER.getType(), BLOCKPOS_SERIALIZER).create();

    static {
        EntityDataSerializers.m_135050_(WILL_TYPE_SERIALIZER);
    }
}

