/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.entity.projectile;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;
import wayoftime.bloodmagic.api.compat.EnumDemonWillType;
import wayoftime.bloodmagic.common.item.BloodMagicItems;
import wayoftime.bloodmagic.will.PlayerDemonWillHandler;

public class AbstractEntityThrowingDagger
extends ThrowableItemProjectile {
    @Nullable
    private BlockState inBlockState;
    protected boolean inGround;
    protected int timeInGround;
    public AbstractArrow.Pickup pickupStatus = AbstractArrow.Pickup.ALLOWED;
    public int arrowShake;
    private int ticksInGround;
    private double damage = 2.0;
    private int knockbackStrength;
    private SoundEvent hitSound = this.getHitEntitySound();
    private IntOpenHashSet piercedEntities;
    private List<Entity> hitEntities;
    private double willDrop = 0.0;
    private EnumDemonWillType willType = EnumDemonWillType.DEFAULT;

    public AbstractEntityThrowingDagger(EntityType<? extends AbstractEntityThrowingDagger> type, Level world) {
        super(type, world);
    }

    public AbstractEntityThrowingDagger(EntityType<? extends AbstractEntityThrowingDagger> type, ItemStack stack, Level worldIn, LivingEntity throwerIn) {
        super(type, throwerIn, worldIn);
        this.m_37446_(stack);
        if (throwerIn instanceof Player) {
            this.pickupStatus = AbstractArrow.Pickup.ALLOWED;
        }
    }

    public AbstractEntityThrowingDagger(EntityType<? extends AbstractEntityThrowingDagger> type, ItemStack stack, Level worldIn, double x, double y, double z) {
        super(type, x, y, z, worldIn);
        this.m_37446_(stack);
    }

    public void m_37446_(ItemStack stack) {
        super.m_37446_(stack);
    }

    protected Item m_7881_() {
        return (Item)BloodMagicItems.THROWING_DAGGER.get();
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void m_8119_() {
        VoxelShape voxelshape;
        BlockPos blockpos;
        BlockState blockstate;
        this.m_6075_();
        boolean flag = this.getNoClip();
        Vec3 vec3 = this.m_20184_();
        if (this.f_19860_ == 0.0f && this.f_19859_ == 0.0f) {
            double d0 = vec3.m_165924_();
            this.m_146922_((float)(Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_) * 57.2957763671875));
            this.m_146926_((float)(Mth.m_14136_((double)vec3.f_82480_, (double)d0) * 57.2957763671875));
            this.f_19859_ = this.m_146908_();
            this.f_19860_ = this.m_146909_();
        }
        if (!((blockstate = this.f_19853_.m_8055_(blockpos = this.m_142538_())).m_60795_() || flag || (voxelshape = blockstate.m_60812_((BlockGetter)this.f_19853_, blockpos)).m_83281_())) {
            Vec3 vec31 = this.m_20182_();
            for (AABB aabb : voxelshape.m_83299_()) {
                if (!aabb.m_82338_(blockpos).m_82390_(vec31)) continue;
                this.inGround = true;
                break;
            }
        }
        if (this.arrowShake > 0) {
            --this.arrowShake;
        }
        if (this.m_20070_() || blockstate.m_60713_(Blocks.f_152499_)) {
            this.m_20095_();
        }
        if (this.inGround && !flag) {
            if (this.inBlockState != blockstate && this.shouldFall()) {
                this.startFalling();
            } else if (!this.f_19853_.f_46443_) {
                this.tickDespawn();
            }
            ++this.timeInGround;
        } else {
            Vec3 vec33;
            this.timeInGround = 0;
            Vec3 vec32 = this.m_20182_();
            BlockHitResult hitresult = this.f_19853_.m_45547_(new ClipContext(vec32, vec33 = vec32.m_82549_(vec3), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
            if (hitresult.m_6662_() != HitResult.Type.MISS) {
                vec33 = hitresult.m_82450_();
            }
            while (!this.m_146910_()) {
                EntityHitResult entityhitresult = this.rayTraceEntities(vec32, vec33);
                if (entityhitresult != null) {
                    hitresult = entityhitresult;
                }
                if (hitresult != null && hitresult.m_6662_() == HitResult.Type.ENTITY) {
                    Entity entity = ((EntityHitResult)hitresult).m_82443_();
                    Entity entity1 = this.m_37282_();
                    if (entity instanceof Player && entity1 instanceof Player && !((Player)entity1).m_7099_((Player)entity)) {
                        hitresult = null;
                        entityhitresult = null;
                    }
                }
                if (hitresult != null && hitresult.m_6662_() != HitResult.Type.MISS && !flag && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)hitresult)) {
                    this.m_6532_((HitResult)hitresult);
                    this.f_19812_ = true;
                }
                if (entityhitresult == null || this.getPierceLevel() <= 0) break;
                hitresult = null;
            }
            vec3 = this.m_20184_();
            double d5 = vec3.f_82479_;
            double d6 = vec3.f_82480_;
            double d1 = vec3.f_82481_;
            if (this.getIsCritical()) {
                for (int i = 0; i < 4; ++i) {
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123797_, this.m_20185_() + d5 * (double)i / 4.0, this.m_20186_() + d6 * (double)i / 4.0, this.m_20189_() + d1 * (double)i / 4.0, -d5, -d6 + 0.2, -d1);
                }
            }
            double d7 = this.m_20185_() + d5;
            double d2 = this.m_20186_() + d6;
            double d3 = this.m_20189_() + d1;
            double d4 = vec3.m_165924_();
            if (flag) {
                this.m_146922_((float)(Mth.m_14136_((double)(-d5), (double)(-d1)) * 57.2957763671875));
            } else {
                this.m_146922_((float)(Mth.m_14136_((double)d5, (double)d1) * 57.2957763671875));
            }
            this.m_146926_((float)(Mth.m_14136_((double)d6, (double)d4) * 57.2957763671875));
            this.m_146926_(AbstractEntityThrowingDagger.m_37273_((float)this.f_19860_, (float)this.m_146909_()));
            this.m_146922_(AbstractEntityThrowingDagger.m_37273_((float)this.f_19859_, (float)this.m_146908_()));
            float f = 0.99f;
            float f1 = 0.05f;
            if (this.m_20069_()) {
                for (int j = 0; j < 4; ++j) {
                    float f2 = 0.25f;
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123795_, d7 - d5 * 0.25, d2 - d6 * 0.25, d3 - d1 * 0.25, d5, d6, d1);
                }
                f = this.getWaterDrag();
            }
            this.m_20256_(vec3.m_82490_((double)f));
            if (!this.m_20068_() && !flag) {
                Vec3 vec34 = this.m_20184_();
                this.m_20334_(vec34.f_82479_, vec34.f_82480_ - (double)0.05f, vec34.f_82481_);
            }
            this.m_6034_(d7, d2, d3);
            this.m_20101_();
        }
    }

    public void m_6478_(MoverType typeIn, Vec3 pos) {
        super.m_6478_(typeIn, pos);
        if (typeIn != MoverType.SELF && this.shouldFall()) {
            this.startFalling();
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128376_("life", (short)this.ticksInGround);
        if (this.inBlockState != null) {
            compound.m_128365_("inBlockState", (Tag)NbtUtils.m_129202_((BlockState)this.inBlockState));
        }
        compound.m_128344_("shake", (byte)this.arrowShake);
        compound.m_128379_("inGround", this.inGround);
        compound.m_128344_("pickup", (byte)this.pickupStatus.ordinal());
        compound.m_128347_("damage", this.damage);
        compound.m_128359_("SoundEvent", Registry.f_122821_.m_7981_((Object)this.hitSound).toString());
        compound.m_128347_("willDrop", this.willDrop);
        compound.m_128359_("willType", this.willType.name);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.ticksInGround = compound.m_128448_("life");
        if (compound.m_128425_("inBlockState", 10)) {
            this.inBlockState = NbtUtils.m_129241_((CompoundTag)compound.m_128469_("inBlockState"));
        }
        this.arrowShake = compound.m_128445_("shake") & 0xFF;
        this.inGround = compound.m_128471_("inGround");
        if (compound.m_128425_("damage", 99)) {
            this.damage = compound.m_128459_("damage");
        }
        if (compound.m_128425_("pickup", 99)) {
            this.pickupStatus = AbstractArrow.Pickup.m_36808_((int)compound.m_128445_("pickup"));
        } else if (compound.m_128425_("player", 99)) {
            this.pickupStatus = compound.m_128471_("player") ? AbstractArrow.Pickup.ALLOWED : AbstractArrow.Pickup.DISALLOWED;
        }
        this.willDrop = compound.m_128459_("willDrop");
        this.willType = EnumDemonWillType.getType(compound.m_128461_("willType"));
    }

    public void setDamage(double damage) {
        this.damage = damage;
    }

    public double getDamage() {
        return this.damage;
    }

    protected void m_5790_(EntityHitResult p_213868_1_) {
        DamageSource damagesource;
        Entity entity1;
        super.m_5790_(p_213868_1_);
        Entity entity = p_213868_1_.m_82443_();
        float f = (float)this.m_20184_().m_82553_();
        int i = Mth.m_14165_((double)Mth.m_14008_((double)this.damage, (double)0.0, (double)2.147483647E9));
        if (this.getPierceLevel() > 0) {
            if (this.piercedEntities == null) {
                this.piercedEntities = new IntOpenHashSet(5);
            }
            if (this.hitEntities == null) {
                this.hitEntities = Lists.newArrayListWithCapacity((int)5);
            }
            if (this.piercedEntities.size() >= this.getPierceLevel() + 1) {
                this.m_146870_();
                return;
            }
            this.piercedEntities.add(entity.m_142049_());
        }
        if (this.getIsCritical()) {
            long j = this.f_19796_.nextInt(i / 2 + 2);
            i = (int)Math.min(j + (long)i, Integer.MAX_VALUE);
        }
        if ((entity1 = this.m_37282_()) == null) {
            damagesource = DamageSource.m_19361_((Entity)this, (Entity)this);
        } else {
            damagesource = DamageSource.m_19361_((Entity)this, (Entity)entity1);
            if (entity1 instanceof LivingEntity) {
                ((LivingEntity)entity1).m_21335_(entity);
            }
        }
        boolean flag = entity.m_6095_() == EntityType.f_20566_;
        int k = entity.m_20094_();
        if (this.m_6060_() && !flag) {
            entity.m_20254_(5);
        }
        if (entity.m_6469_(damagesource, (float)i)) {
            if (flag) {
                return;
            }
            if (!entity.m_6084_() && entity1 instanceof Player && entity instanceof LivingEntity) {
                PlayerDemonWillHandler.addDemonWill(this.willType, (Player)entity1, this.getWillDropForMobHealth(((LivingEntity)entity).m_21233_()));
            }
            if (entity instanceof LivingEntity) {
                Vec3 vector3d;
                LivingEntity livingentity = (LivingEntity)entity;
                if (this.knockbackStrength > 0 && (vector3d = this.m_20184_().m_82542_(1.0, 0.0, 1.0).m_82541_().m_82490_((double)this.knockbackStrength * 0.6)).m_82556_() > 0.0) {
                    livingentity.m_5997_(vector3d.f_82479_, 0.1, vector3d.f_82481_);
                }
                if (!this.f_19853_.f_46443_ && entity1 instanceof LivingEntity) {
                    EnchantmentHelper.m_44823_((LivingEntity)livingentity, (Entity)entity1);
                    EnchantmentHelper.m_44896_((LivingEntity)((LivingEntity)entity1), (Entity)livingentity);
                }
                this.daggerHit(livingentity);
                if (entity1 != null && livingentity != entity1 && livingentity instanceof Player && entity1 instanceof ServerPlayer && !this.m_20067_()) {
                    ((ServerPlayer)entity1).f_8906_.m_141995_((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.f_132159_, 0.0f));
                }
                if (!entity.m_6084_() && this.hitEntities != null) {
                    this.hitEntities.add((Entity)livingentity);
                }
            }
            this.m_5496_(this.hitSound, 1.0f, 1.2f / (this.f_19796_.nextFloat() * 0.2f + 0.9f));
            if (this.getPierceLevel() <= 0) {
                this.m_146870_();
            }
        } else {
            entity.m_7311_(k);
            this.m_20256_(this.m_20184_().m_82490_(-0.1));
            this.m_146922_(this.m_146908_() + 180.0f);
            this.f_19859_ += 180.0f;
            if (!this.f_19853_.f_46443_ && this.m_20184_().m_82556_() < 1.0E-7) {
                if (this.pickupStatus == AbstractArrow.Pickup.ALLOWED) {
                    this.m_5552_(this.getArrowStack(), 0.1f);
                }
                this.m_146870_();
            }
        }
    }

    public void m_6123_(Player entityIn) {
        if (!this.f_19853_.f_46443_ && (this.inGround || this.getNoClip()) && this.arrowShake <= 0) {
            boolean flag;
            boolean bl = flag = this.pickupStatus == AbstractArrow.Pickup.ALLOWED || this.pickupStatus == AbstractArrow.Pickup.CREATIVE_ONLY && entityIn.m_150110_().f_35937_ || this.getNoClip() && this.m_37282_().m_142081_() == entityIn.m_142081_();
            if (this.pickupStatus == AbstractArrow.Pickup.ALLOWED && !entityIn.m_150109_().m_36054_(this.getArrowStack())) {
                flag = false;
            }
            if (flag) {
                this.f_19853_.m_6263_(null, entityIn.m_20185_(), entityIn.m_20186_() + 0.5, entityIn.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, ((this.f_19853_.f_46441_.nextFloat() - this.f_19853_.f_46441_.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                this.m_146870_();
            }
        }
    }

    protected ItemStack getArrowStack() {
        return this.m_7846_();
    }

    protected void m_8060_(BlockHitResult p_230299_1_) {
        this.inBlockState = this.f_19853_.m_8055_(p_230299_1_.m_82425_());
        super.m_8060_(p_230299_1_);
        Vec3 vector3d = p_230299_1_.m_82450_().m_82492_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        this.m_20256_(vector3d);
        Vec3 vector3d1 = vector3d.m_82541_().m_82490_((double)0.05f);
        this.m_20343_(this.m_20185_() - vector3d1.f_82479_, this.m_20186_() - vector3d1.f_82480_, this.m_20189_() - vector3d1.f_82481_);
        this.m_5496_(this.getHitGroundSound(), 1.0f, 1.2f / (this.f_19796_.nextFloat() * 0.2f + 0.9f));
        this.inGround = true;
        this.arrowShake = 7;
        this.setHitSound(SoundEvents.f_11685_);
        this.resetPiercedEntities();
    }

    private void startFalling() {
        this.inGround = false;
        Vec3 vector3d = this.m_20184_();
        this.m_20256_(vector3d.m_82542_((double)(this.f_19796_.nextFloat() * 0.2f), (double)(this.f_19796_.nextFloat() * 0.2f), (double)(this.f_19796_.nextFloat() * 0.2f)));
        this.ticksInGround = 0;
    }

    private boolean shouldFall() {
        return this.inGround && this.f_19853_.m_45772_(new AABB(this.m_20182_(), this.m_20182_()).m_82400_(0.06));
    }

    protected void tickDespawn() {
        ++this.ticksInGround;
        if (this.ticksInGround >= 1200) {
            this.m_146870_();
        }
    }

    protected void daggerHit(LivingEntity living) {
    }

    protected SoundEvent getHitEntitySound() {
        return SoundEvents.f_11685_;
    }

    protected final SoundEvent getHitGroundSound() {
        return this.hitSound;
    }

    private void resetPiercedEntities() {
        if (this.hitEntities != null) {
            this.hitEntities.clear();
        }
        if (this.piercedEntities != null) {
            this.piercedEntities.clear();
        }
    }

    public void setHitSound(SoundEvent soundIn) {
        this.hitSound = soundIn;
    }

    public boolean getNoClip() {
        if (!this.f_19853_.f_46443_) {
            return this.f_19794_;
        }
        return false;
    }

    public boolean getIsCritical() {
        return false;
    }

    public byte getPierceLevel() {
        return 0;
    }

    protected float getWaterDrag() {
        return 0.6f;
    }

    @Nullable
    protected EntityHitResult rayTraceEntities(Vec3 startVec, Vec3 endVec) {
        return ProjectileUtil.m_37304_((Level)this.f_19853_, (Entity)this, (Vec3)startVec, (Vec3)endVec, (AABB)this.m_142469_().m_82369_(this.m_20184_()).m_82400_(1.0), this::m_5603_);
    }

    protected boolean m_5603_(Entity p_230298_1_) {
        return super.m_5603_(p_230298_1_) && (this.piercedEntities == null || !this.piercedEntities.contains(p_230298_1_.m_142049_()));
    }

    public void setWillDrop(double willDrop) {
        this.willDrop = willDrop;
    }

    public double getWillDropForMobHealth(double hp) {
        return this.willDrop * hp / 20.0;
    }

    public void setWillType(EnumDemonWillType type) {
        this.willType = type;
    }

    @OnlyIn(value=Dist.CLIENT)
    private ParticleOptions makeParticle() {
        ItemStack itemstack = this.m_37454_();
        return itemstack.m_41619_() ? ParticleTypes.f_123756_ : new ItemParticleOption(ParticleTypes.f_123752_, itemstack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        if (id == 3) {
            ParticleOptions iparticledata = this.makeParticle();
            for (int i = 0; i < 8; ++i) {
                this.f_19853_.m_7106_(iparticledata, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
            }
        }
    }
}

