/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.core;

import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.anointment.Anointment;
import wayoftime.bloodmagic.common.registration.impl.AnointmentDeferredRegister;
import wayoftime.bloodmagic.common.registration.impl.AnointmentRegistryObject;
import wayoftime.bloodmagic.gson.Serializers;

public class AnointmentRegistrar {
    public static final AnointmentDeferredRegister ANOINTMENTS = new AnointmentDeferredRegister("bloodmagic");
    public static final Map<ResourceLocation, Anointment> ANOINTMENT_MAP = new HashMap<ResourceLocation, Anointment>();
    private static final Map<String, ResourceLocation> DEFINITIONS = ((Supplier<Map>)() -> {
        HashMap<String, ResourceLocation> def = new HashMap<String, ResourceLocation>();
        def.put("melee_damage", BloodMagic.rl("melee_damage"));
        def.put("holy_water", BloodMagic.rl("holy_water"));
        def.put("hidden_knowledge", BloodMagic.rl("hidden_knowledge"));
        def.put("quick_draw", BloodMagic.rl("quick_draw"));
        def.put("bow_power", BloodMagic.rl("bow_power"));
        def.put("bow_velocity", BloodMagic.rl("bow_velocity"));
        return def;
    }).get();
    public static final AnointmentRegistryObject<Anointment> ANOINTMENT_MELEE_DAMAGE = ANOINTMENTS.register("melee_damage", () -> AnointmentRegistrar.parseDefinition("melee_damage").withDamageProvider((player, weapon, damage, holder, attacked, anoint, level) -> anoint.getBonusValue("damage", level).doubleValue()).setConsumeOnAttack().addIncompatibility(BloodMagic.rl("holy_water"), new ResourceLocation[0]));
    public static final AnointmentRegistryObject<Anointment> ANOINTMENT_SILK_TOUCH = ANOINTMENTS.register("silk_touch", () -> new Anointment(BloodMagic.rl("silk_touch")).setConsumeOnHarvest().addIncompatibility(BloodMagic.rl("fortune"), new ResourceLocation[0]));
    public static final AnointmentRegistryObject<Anointment> ANOINTMENT_FORTUNE = ANOINTMENTS.register("fortune", () -> new Anointment(BloodMagic.rl("fortune")).setConsumeOnHarvest().addIncompatibility(BloodMagic.rl("silk_touch"), new ResourceLocation[0]));
    public static final AnointmentRegistryObject<Anointment> ANOINTMENT_HOLY_WATER = ANOINTMENTS.register("holy_water", () -> AnointmentRegistrar.parseDefinition("holy_water").withDamageProvider((player, weapon, damage, holder, attacked, anoint, level) -> {
        if (attacked.m_21222_()) {
            return anoint.getBonusValue("damage", level).doubleValue();
        }
        return 0.0;
    }).setConsumeOnAttack().addIncompatibility(BloodMagic.rl("melee_damage"), new ResourceLocation[0]));
    public static final AnointmentRegistryObject<Anointment> ANOINTMENT_HIDDEN_KNOWLEDGE = ANOINTMENTS.register("hidden_knowledge", () -> AnointmentRegistrar.parseDefinition("hidden_knowledge").setConsumeOnHarvest());
    public static final AnointmentRegistryObject<Anointment> ANOINTMENT_QUICK_DRAW = ANOINTMENTS.register("quick_draw", () -> AnointmentRegistrar.parseDefinition("quick_draw").setConsumeOnUseFinish());
    public static final AnointmentRegistryObject<Anointment> ANOINTMENT_LOOTING = ANOINTMENTS.register("looting", () -> new Anointment(BloodMagic.rl("looting")).setConsumeOnAttack());
    public static final AnointmentRegistryObject<Anointment> ANOINTMENT_BOW_POWER = ANOINTMENTS.register("bow_power", () -> AnointmentRegistrar.parseDefinition("bow_power").setConsumeOnUseFinish());
    public static final AnointmentRegistryObject<Anointment> ANOINTMENT_WILL_POWER = ANOINTMENTS.register("will_power", () -> new Anointment(BloodMagic.rl("will_power")).setConsumeOnAttack());
    public static final AnointmentRegistryObject<Anointment> ANOINTMENT_SMELTING = ANOINTMENTS.register("smelting", () -> new Anointment(BloodMagic.rl("smelting")).setConsumeOnHarvest());
    public static final AnointmentRegistryObject<Anointment> ANOINTMENT_BOW_VELOCITY = ANOINTMENTS.register("bow_velocity", () -> AnointmentRegistrar.parseDefinition("bow_velocity").setConsumeOnUseFinish());

    public static void register() {
        AnointmentRegistrar.registerAnointment((Anointment)((Object)ANOINTMENT_MELEE_DAMAGE.get()));
        AnointmentRegistrar.registerAnointment((Anointment)((Object)ANOINTMENT_SILK_TOUCH.get()));
        AnointmentRegistrar.registerAnointment((Anointment)((Object)ANOINTMENT_FORTUNE.get()));
        AnointmentRegistrar.registerAnointment((Anointment)((Object)ANOINTMENT_HOLY_WATER.get()));
        AnointmentRegistrar.registerAnointment((Anointment)((Object)ANOINTMENT_HIDDEN_KNOWLEDGE.get()));
        AnointmentRegistrar.registerAnointment((Anointment)((Object)ANOINTMENT_QUICK_DRAW.get()));
        AnointmentRegistrar.registerAnointment((Anointment)((Object)ANOINTMENT_LOOTING.get()));
        AnointmentRegistrar.registerAnointment((Anointment)((Object)ANOINTMENT_BOW_POWER.get()));
        AnointmentRegistrar.registerAnointment((Anointment)((Object)ANOINTMENT_WILL_POWER.get()));
        AnointmentRegistrar.registerAnointment((Anointment)((Object)ANOINTMENT_SMELTING.get()));
        AnointmentRegistrar.registerAnointment((Anointment)((Object)ANOINTMENT_BOW_VELOCITY.get()));
    }

    public static void registerAnointment(Anointment anoint) {
        ANOINTMENT_MAP.put(anoint.getKey(), anoint);
    }

    public static Anointment parseDefinition(String fileName) {
        ResourceLocation path = DEFINITIONS.get(fileName);
        if (path == null) {
            return Anointment.DUMMY;
        }
        try {
            URL schematicURL = Anointment.class.getResource(AnointmentRegistrar.resLocToResourcePath(path));
            System.out.println("Attempting to load Anointment: " + schematicURL + ", path: " + AnointmentRegistrar.resLocToResourcePath(path));
            return (Anointment)((Object)Serializers.GSON.fromJson(Resources.toString((URL)schematicURL, (Charset)Charsets.UTF_8), Anointment.class));
        }
        catch (Exception e) {
            e.printStackTrace();
            return Anointment.DUMMY;
        }
    }

    public static String resLocToResourcePath(ResourceLocation resourceLocation) {
        return "/data/" + resourceLocation.m_135827_() + "/anointment/" + resourceLocation.m_135815_() + ".json";
    }
}

