/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.compat.jei.forge;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.common.block.BloodMagicBlocks;
import wayoftime.bloodmagic.common.item.BloodMagicItems;
import wayoftime.bloodmagic.recipe.RecipeTartaricForge;
import wayoftime.bloodmagic.util.ChatUtil;

public class TartaricForgeRecipeCategory
implements IRecipeCategory<RecipeTartaricForge> {
    private static final int OUTPUT_SLOT = 0;
    private static final int GEM_SLOT = 1;
    private static final int INPUT_SLOT = 2;
    public static final ResourceLocation UID = BloodMagic.rl("soulforge");
    @Nonnull
    private final IDrawable background;
    private final IDrawable icon;

    public TartaricForgeRecipeCategory(IGuiHelper guiHelper) {
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((ItemLike)BloodMagicBlocks.SOUL_FORGE.get()));
        this.background = guiHelper.createDrawable(BloodMagic.rl("gui/jei/soulforge.png"), 0, 0, 100, 40);
    }

    @Nonnull
    public ResourceLocation getUid() {
        return UID;
    }

    public List<Component> getTooltipStrings(RecipeTartaricForge recipe, double mouseX, double mouseY) {
        ArrayList tooltip = Lists.newArrayList();
        if (mouseX >= 40.0 && mouseX <= 60.0 && mouseY >= 21.0 && mouseY <= 34.0) {
            tooltip.add(new TranslatableComponent("jei.bloodmagic.recipe.minimumsouls", new Object[]{ChatUtil.DECIMAL_FORMAT.format(recipe.getMinimumSouls())}));
            tooltip.add(new TranslatableComponent("jei.bloodmagic.recipe.soulsdrained", new Object[]{ChatUtil.DECIMAL_FORMAT.format(recipe.getSoulDrain())}));
        }
        return tooltip;
    }

    @Nonnull
    public Component getTitle() {
        return new TranslatableComponent("jei.bloodmagic.recipe.soulforge");
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull RecipeTartaricForge recipe, @Nonnull IIngredients ingredients) {
        ArrayList validGems = Lists.newArrayList();
        for (DefaultWill will : DefaultWill.values()) {
            if (!(will.minSouls >= recipe.getMinimumSouls())) continue;
            validGems.add(will.willStack);
        }
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, false, 73, 13);
        guiItemStacks.init(1, true, 42, 0);
        for (int y = 0; y < 2; ++y) {
            for (int x = 0; x < 2; ++x) {
                int index = 2 + x + y * 2;
                guiItemStacks.init(index, true, x * 18, y * 18);
            }
        }
        guiItemStacks.set(1, (List)validGems);
        guiItemStacks.set(0, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
        guiItemStacks.set(ingredients);
    }

    public Class<? extends RecipeTartaricForge> getRecipeClass() {
        return RecipeTartaricForge.class;
    }

    public void setIngredients(RecipeTartaricForge recipe, IIngredients ingredients) {
        ArrayList validGems = Lists.newArrayList();
        for (DefaultWill will : DefaultWill.values()) {
            if (!(will.minSouls >= recipe.getMinimumSouls())) continue;
            validGems.add(will.willStack);
        }
        ItemStack[] validGemStacks = new ItemStack[validGems.size()];
        for (int i = 0; i < validGemStacks.length; ++i) {
            validGemStacks[i] = (ItemStack)validGems.get(i);
        }
        ArrayList ingList = Lists.newArrayList();
        ingList.add(Ingredient.m_43927_((ItemStack[])validGemStacks));
        ingList.addAll(recipe.getInput());
        ingredients.setInputIngredients((List)ingList);
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.getOutput());
    }

    public static enum DefaultWill {
        SOUL(new ItemStack((ItemLike)BloodMagicItems.MONSTER_SOUL_RAW.get()), 16.0),
        PETTY(new ItemStack((ItemLike)BloodMagicItems.PETTY_GEM.get()), 64.0),
        LESSER(new ItemStack((ItemLike)BloodMagicItems.LESSER_GEM.get()), 256.0),
        COMMON(new ItemStack((ItemLike)BloodMagicItems.COMMON_GEM.get()), 1024.0),
        GREATER(new ItemStack((ItemLike)BloodMagicItems.GREATER_GEM.get()), 4096.0);

        public final ItemStack willStack;
        public final double minSouls;

        private DefaultWill(ItemStack willStack, double minSouls) {
            this.willStack = willStack;
            this.minSouls = minSouls;
        }
    }
}

