/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.compat.jei.alchemytable;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.common.block.BloodMagicBlocks;
import wayoftime.bloodmagic.common.item.BloodMagicItems;
import wayoftime.bloodmagic.common.item.potion.ItemAlchemyFlask;
import wayoftime.bloodmagic.core.registry.OrbRegistry;
import wayoftime.bloodmagic.recipe.EffectHolder;
import wayoftime.bloodmagic.recipe.flask.RecipePotionFlaskBase;
import wayoftime.bloodmagic.util.ChatUtil;

public class PotionRecipeCategory
implements IRecipeCategory<RecipePotionFlaskBase> {
    private static final int OUTPUT_SLOT = 0;
    private static final int ORB_SLOT = 1;
    private static final int INPUT_SLOT = 2;
    public static final ResourceLocation UID = BloodMagic.rl("potion");
    @Nonnull
    private final IDrawable background;
    private final IDrawable icon;

    public PotionRecipeCategory(IGuiHelper guiHelper) {
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((ItemLike)BloodMagicBlocks.ALCHEMY_TABLE.get()));
        this.background = guiHelper.createDrawable(BloodMagic.rl("gui/jei/alchemytable.png"), 0, 0, 118, 40);
    }

    @Nonnull
    public ResourceLocation getUid() {
        return UID;
    }

    public List<Component> getTooltipStrings(RecipePotionFlaskBase recipe, double mouseX, double mouseY) {
        ArrayList tooltip = Lists.newArrayList();
        if (mouseX >= 58.0 && mouseX <= 78.0 && mouseY >= 21.0 && mouseY <= 34.0) {
            tooltip.add(new TranslatableComponent("tooltip.bloodmagic.tier", new Object[]{ChatUtil.DECIMAL_FORMAT.format(recipe.getMinimumTier())}));
            tooltip.add(new TranslatableComponent("jei.bloodmagic.recipe.lpDrained", new Object[]{ChatUtil.DECIMAL_FORMAT.format(recipe.getSyphon())}));
            tooltip.add(new TranslatableComponent("jei.bloodmagic.recipe.ticksRequired", new Object[]{ChatUtil.DECIMAL_FORMAT.format(recipe.getTicks())}));
        }
        return tooltip;
    }

    @Nonnull
    public Component getTitle() {
        return new TranslatableComponent("jei.bloodmagic.recipe.potionflask");
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull RecipePotionFlaskBase recipe, @Nonnull IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, false, 91, 13);
        guiItemStacks.init(1, true, 60, 0);
        for (int y = 0; y < 2; ++y) {
            for (int x = 0; x < 3; ++x) {
                int index = 2 + x + y * 3;
                guiItemStacks.init(index, true, x * 18, y * 18);
            }
        }
        guiItemStacks.set(ingredients);
    }

    public Class<? extends RecipePotionFlaskBase> getRecipeClass() {
        return RecipePotionFlaskBase.class;
    }

    public void setIngredients(RecipePotionFlaskBase recipe, IIngredients ingredients) {
        List<ItemStack> validOrbs = OrbRegistry.getOrbsDownToTier(recipe.getMinimumTier());
        ItemStack[] validOrbStacks = new ItemStack[validOrbs.size()];
        for (int i = 0; i < validOrbStacks.length; ++i) {
            validOrbStacks[i] = validOrbs.get(i);
        }
        Item[] flaskItems = new Item[]{(Item)BloodMagicItems.ALCHEMY_FLASK.get(), (Item)BloodMagicItems.ALCHEMY_FLASK_THROWABLE.get(), (Item)BloodMagicItems.ALCHEMY_FLASK_LINGERING.get()};
        ItemStack[] flaskStacks = new ItemStack[flaskItems.length];
        ArrayList ingList = Lists.newArrayList();
        ingList.add(Ingredient.m_43927_((ItemStack[])validOrbStacks));
        ingList.addAll(recipe.getInput());
        ItemStack flaskStack = recipe.getExamplePotionFlask();
        for (int i = 0; i < flaskItems.length; ++i) {
            Item inputFlask = flaskItems[i];
            ItemStack copyFlaskStack = new ItemStack((ItemLike)inputFlask);
            copyFlaskStack.m_41751_(flaskStack.m_41783_());
            flaskStacks[i] = copyFlaskStack;
        }
        ingList.add(Ingredient.m_43927_((ItemStack[])flaskStacks));
        List<EffectHolder> holderList = ((ItemAlchemyFlask)flaskStack.m_41720_()).getEffectHoldersOfFlask(flaskStack);
        ingredients.setInputIngredients((List)ingList);
        ItemStack outputStack = recipe.getOutput(flaskStack, holderList);
        ((ItemAlchemyFlask)flaskStack.m_41720_()).resyncEffectInstances(outputStack);
        ingredients.setOutput(VanillaTypes.ITEM, (Object)outputStack);
    }
}

