/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.tile;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import wayoftime.bloodmagic.api.compat.EnumDemonWillType;
import wayoftime.bloodmagic.api.compat.IDemonWillConduit;
import wayoftime.bloodmagic.common.block.BloodMagicBlocks;
import wayoftime.bloodmagic.common.tile.BloodMagicTileEntities;
import wayoftime.bloodmagic.common.tile.TileDemonCrystal;
import wayoftime.bloodmagic.common.tile.base.TileTicking;
import wayoftime.bloodmagic.demonaura.WorldDemonWillHandler;
import wayoftime.bloodmagic.will.DemonWillHolder;

public class TileDemonCrystallizer
extends TileTicking
implements IDemonWillConduit {
    public static final int maxWill = 100;
    public static final double drainRate = 1.0;
    public static final double willToFormCrystal = 99.0;
    public static final double totalFormationTime = 1000.0;
    public DemonWillHolder holder = new DemonWillHolder();
    public double internalCounter = 0.0;

    public TileDemonCrystallizer(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public TileDemonCrystallizer(BlockPos pos, BlockState state) {
        this((BlockEntityType)BloodMagicTileEntities.DEMON_CRYSTALLIZER_TYPE.get(), pos, state);
    }

    @Override
    public void onUpdate() {
        if (this.f_58857_.f_46443_) {
            return;
        }
        BlockPos offsetPos = this.f_58858_.m_142300_(Direction.UP);
        if (this.m_58904_().m_46859_(offsetPos)) {
            EnumDemonWillType highestType = WorldDemonWillHandler.getHighestDemonWillType(this.m_58904_(), this.f_58858_);
            double amount = WorldDemonWillHandler.getCurrentWill(this.m_58904_(), this.f_58858_, highestType);
            if (amount >= 99.0) {
                this.internalCounter += this.getCrystalFormationRate(amount);
                if (this.internalCounter >= 1000.0 && WorldDemonWillHandler.drainWill(this.m_58904_(), this.m_58899_(), highestType, 99.0, false) >= 99.0 && this.formCrystal(highestType, offsetPos)) {
                    WorldDemonWillHandler.drainWill(this.m_58904_(), this.m_58899_(), highestType, 99.0, true);
                    this.internalCounter = 0.0;
                }
            }
        }
    }

    public boolean formCrystal(EnumDemonWillType type, BlockPos position) {
        Block block = (Block)BloodMagicBlocks.RAW_CRYSTAL_BLOCK.get();
        switch (type) {
            case CORROSIVE: {
                block = (Block)BloodMagicBlocks.CORROSIVE_CRYSTAL_BLOCK.get();
                break;
            }
            case DESTRUCTIVE: {
                block = (Block)BloodMagicBlocks.DESTRUCTIVE_CRYSTAL_BLOCK.get();
                break;
            }
            case STEADFAST: {
                block = (Block)BloodMagicBlocks.STEADFAST_CRYSTAL_BLOCK.get();
                break;
            }
            case VENGEFUL: {
                block = (Block)BloodMagicBlocks.VENGEFUL_CRYSTAL_BLOCK.get();
                break;
            }
        }
        this.m_58904_().m_46597_(position, block.m_49966_());
        BlockEntity tile = this.m_58904_().m_7702_(position);
        if (tile instanceof TileDemonCrystal) {
            ((TileDemonCrystal)tile).setPlacement(Direction.UP);
            return true;
        }
        return false;
    }

    public double getCrystalFormationRate(double currentWill) {
        return 1.0;
    }

    @Override
    public void deserialize(CompoundTag tag) {
        this.holder.readFromNBT(tag, "Will");
        this.internalCounter = tag.m_128459_("internalCounter");
    }

    @Override
    public CompoundTag serialize(CompoundTag tag) {
        this.holder.writeToNBT(tag, "Will");
        tag.m_128347_("internalCounter", this.internalCounter);
        return tag;
    }

    @Override
    public int getWeight() {
        return 10;
    }

    @Override
    public double fillDemonWill(EnumDemonWillType type, double amount, boolean doFill) {
        if (amount <= 0.0) {
            return 0.0;
        }
        if (!this.canFill(type)) {
            return 0.0;
        }
        if (!doFill) {
            return Math.min(100.0 - this.holder.getWill(type), amount);
        }
        return this.holder.addWill(type, amount, 100.0);
    }

    @Override
    public double drainDemonWill(EnumDemonWillType type, double amount, boolean doDrain) {
        double drained = amount;
        double current = this.holder.getWill(type);
        if (current < drained) {
            drained = current;
        }
        if (doDrain) {
            return this.holder.drainWill(type, amount);
        }
        return drained;
    }

    @Override
    public boolean canFill(EnumDemonWillType type) {
        return true;
    }

    @Override
    public boolean canDrain(EnumDemonWillType type) {
        return true;
    }

    @Override
    public double getCurrentWill(EnumDemonWillType type) {
        return this.holder.getWill(type);
    }
}

