/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.routing;

import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import wayoftime.bloodmagic.common.item.routing.IFilterKey;
import wayoftime.bloodmagic.common.routing.IItemFilter;
import wayoftime.bloodmagic.util.Utils;

public class BlacklistItemFilter
implements IItemFilter {
    protected List<IFilterKey> requestList;
    protected BlockEntity accessedTile;
    protected IItemHandler itemHandler;

    @Override
    public void initializeFilter(List<IFilterKey> filteredList, BlockEntity tile, IItemHandler itemHandler, boolean isFilterOutput) {
        this.accessedTile = tile;
        this.itemHandler = itemHandler;
        if (isFilterOutput) {
            this.requestList = filteredList;
            for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
                ItemStack checkedStack = itemHandler.getStackInSlot(slot);
                if (checkedStack.m_41619_()) continue;
                int stackSize = checkedStack.m_41613_();
                for (IFilterKey filterStack : this.requestList) {
                    if (filterStack.getCount() == 0 || !this.doStacksMatch(filterStack, checkedStack)) continue;
                    filterStack.setCount(Math.max(filterStack.getCount() - stackSize, 0));
                }
            }
        } else {
            this.requestList = filteredList;
            for (IFilterKey filterStack : this.requestList) {
                filterStack.setCount(filterStack.getCount() * -1);
            }
            for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
                ItemStack checkedStack = itemHandler.getStackInSlot(slot);
                if (checkedStack.m_41619_()) continue;
                int stackSize = checkedStack.m_41613_();
                for (IFilterKey filterStack : filteredList) {
                    if (!this.doStacksMatch(filterStack, checkedStack)) continue;
                    filterStack.grow(stackSize);
                }
            }
        }
    }

    @Override
    public ItemStack transferStackThroughOutputFilter(ItemStack inputStack) {
        int allowedAmount = inputStack.m_41613_();
        for (IFilterKey filterStack : this.requestList) {
            if (!this.doStacksMatch(filterStack, inputStack)) continue;
            return inputStack;
        }
        if (allowedAmount <= 0) {
            return inputStack;
        }
        ItemStack testStack = inputStack.m_41777_();
        testStack.m_41764_(allowedAmount);
        ItemStack remainderStack = Utils.insertStackIntoTile(testStack, this.itemHandler);
        int changeAmount = allowedAmount - (remainderStack.m_41619_() ? 0 : remainderStack.m_41613_());
        testStack = inputStack.m_41777_();
        testStack.m_41774_(changeAmount);
        Iterator<IFilterKey> itr = this.requestList.iterator();
        while (itr.hasNext()) {
            IFilterKey filterStack = itr.next();
            if (this.doStacksMatch(filterStack, inputStack)) continue;
            filterStack.shrink(changeAmount);
            if (!filterStack.isEmpty()) continue;
            itr.remove();
        }
        Level world = this.accessedTile.m_58904_();
        BlockPos pos = this.accessedTile.m_58899_();
        world.m_7260_(pos, world.m_8055_(pos), world.m_8055_(pos), 3);
        return testStack;
    }

    @Override
    public int transferThroughInputFilter(IItemFilter outputFilter, int maxTransfer) {
        int totalChange = 0;
        block0: for (int slot = 0; slot < this.itemHandler.getSlots(); ++slot) {
            ItemStack inputStack = this.itemHandler.getStackInSlot(slot);
            if (inputStack.m_41619_() || this.itemHandler.extractItem(slot, inputStack.m_41613_(), true).m_41619_()) continue;
            int allowedAmount = Math.min(inputStack.m_41613_(), maxTransfer);
            for (IFilterKey filterStack : this.requestList) {
                if (!this.doStacksMatch(filterStack, inputStack)) continue;
                continue block0;
            }
            if (allowedAmount <= 0) continue;
            ItemStack testStack = inputStack.m_41777_();
            testStack.m_41764_(allowedAmount);
            ItemStack remainderStack = outputFilter.transferStackThroughOutputFilter(testStack);
            int changeAmount = allowedAmount - (remainderStack.m_41619_() ? 0 : remainderStack.m_41613_());
            if (!remainderStack.m_41619_() && remainderStack.m_41613_() == allowedAmount) continue;
            this.itemHandler.extractItem(slot, changeAmount, false);
            for (IFilterKey filterStack : this.requestList) {
                if (this.doStacksMatch(filterStack, inputStack)) continue;
                filterStack.shrink(changeAmount);
            }
            Level world = this.accessedTile.m_58904_();
            BlockPos pos = this.accessedTile.m_58899_();
            world.m_7260_(pos, world.m_8055_(pos), world.m_8055_(pos), 3);
            totalChange += changeAmount;
            if ((maxTransfer -= changeAmount) > 0) continue;
            return totalChange;
        }
        return totalChange;
    }

    @Override
    public boolean doesStackPassFilter(ItemStack testStack) {
        for (IFilterKey filterStack : this.requestList) {
            if (!this.doStacksMatch(filterStack, testStack)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean doStacksMatch(IFilterKey filterStack, ItemStack testStack) {
        return filterStack.doesStackMatch(testStack);
    }

    @Override
    public void initializeFilter(List<IFilterKey> filteredList) {
        this.requestList = filteredList;
    }
}

