/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.meteor;

import java.util.ArrayList;
import java.util.Optional;
import java.util.Random;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITag;
import wayoftime.bloodmagic.common.meteor.RandomBlockContainer;

public class RandomBlockTagContainer
extends RandomBlockContainer {
    private TagKey<Block> tag;
    private int index = -1;

    public RandomBlockTagContainer(TagKey<Block> tag2, int index) {
        this.tag = tag2;
        this.index = index;
    }

    @Override
    public Block getRandomBlock(Random rand, Level world) {
        ArrayList list = new ArrayList();
        ITag blockTag = ForgeRegistries.BLOCKS.tags().getTag(this.tag);
        blockTag.forEach(a -> list.add(a));
        if (list.size() <= 0) {
            return null;
        }
        if (this.index >= 0 && this.index < list.size()) {
            return (Block)list.get(this.index);
        }
        Optional optionalBlock = blockTag.getRandomElement(rand);
        return optionalBlock.orElse(null);
    }

    @Override
    public String getEntry() {
        ResourceLocation rl = this.tag.f_203868_();
        String entry = "#" + rl.toString();
        if (this.index >= 0) {
            entry = entry + "#" + this.index;
        }
        return entry;
    }
}

