/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.item.sigil;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import wayoftime.bloodmagic.api.compat.IAltarReader;
import wayoftime.bloodmagic.client.key.IKeybindable;
import wayoftime.bloodmagic.client.key.KeyBindings;
import wayoftime.bloodmagic.common.container.item.ContainerHolding;
import wayoftime.bloodmagic.common.item.IBindable;
import wayoftime.bloodmagic.common.item.inventory.InventoryHolding;
import wayoftime.bloodmagic.common.item.sigil.ISigil;
import wayoftime.bloodmagic.common.item.sigil.ItemSigilBase;
import wayoftime.bloodmagic.core.data.Binding;
import wayoftime.bloodmagic.util.Utils;
import wayoftime.bloodmagic.util.helper.NBTHelper;
import wayoftime.bloodmagic.util.helper.PlayerHelper;

public class ItemSigilHolding
extends ItemSigilBase
implements IKeybindable,
IAltarReader,
ISigil.Holding,
MenuProvider {
    public static final int inventorySize = 5;

    public ItemSigilHolding() {
        super("holding");
    }

    @Override
    public void onKeyPressed(ItemStack stack, Player player, KeyBindings key, boolean showInChat) {
        if (stack == player.m_21205_() && stack.m_41720_() instanceof ItemSigilHolding && key.equals((Object)KeyBindings.OPEN_HOLDING)) {
            Utils.setUUID(stack);
            if (player instanceof ServerPlayer) {
                NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)this, buf -> buf.writeItemStack(stack, false));
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, world, tooltip, flag);
        tooltip.add((Component)new TranslatableComponent("tooltip.bloodmagic.sigil.holding.press", new Object[]{new TranslatableComponent(KeyBindings.OPEN_HOLDING.getKey().m_90865_()).m_130940_(ChatFormatting.ITALIC)}).m_130940_(ChatFormatting.GRAY));
        if (!stack.m_41782_()) {
            return;
        }
        NonNullList<ItemStack> inv = ItemSigilHolding.getInternalInventory(stack);
        int currentSlot = ItemSigilHolding.getCurrentItemOrdinal(stack);
        ItemStack item = (ItemStack)inv.get(currentSlot);
        for (int i = 0; i < 5; ++i) {
            ItemStack invStack = (ItemStack)inv.get(i);
            if (invStack.m_41619_()) continue;
            if (!item.m_41619_() && invStack == item) {
                tooltip.add((Component)new TranslatableComponent("tooltip.bloodmagic.sigil.holding.sigilInSlot", new Object[]{i + 1, invStack.m_41786_().m_6879_().m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.UNDERLINE})}));
                continue;
            }
            tooltip.add((Component)new TranslatableComponent("tooltip.bloodmagic.sigil.holding.sigilInSlot", new Object[]{i + 1, invStack.m_41786_()}));
        }
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        InteractionHand hand = context.m_43724_();
        ItemStack stack = player.m_21120_(hand);
        if (PlayerHelper.isFakePlayer(player)) {
            return InteractionResult.FAIL;
        }
        int currentSlot = ItemSigilHolding.getCurrentItemOrdinal(stack);
        NonNullList<ItemStack> inv = ItemSigilHolding.getInternalInventory(stack);
        ItemStack itemUsing = (ItemStack)inv.get(currentSlot);
        if (itemUsing.m_41619_() || ((IBindable)itemUsing.m_41720_()).getBinding(itemUsing) == null) {
            return InteractionResult.PASS;
        }
        InteractionResult result = itemUsing.m_41720_().m_6225_(context);
        this.saveInventory(stack, inv);
        return result;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (PlayerHelper.isFakePlayer(player)) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        int currentSlot = ItemSigilHolding.getCurrentItemOrdinal(stack);
        NonNullList<ItemStack> inv = ItemSigilHolding.getInternalInventory(stack);
        ItemStack itemUsing = (ItemStack)inv.get(currentSlot);
        if (itemUsing.m_41619_() || ((IBindable)itemUsing.m_41720_()).getBinding(itemUsing) == null) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        itemUsing.m_41720_().m_7203_(world, player, hand);
        this.saveInventory(stack, inv);
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    @Override
    @Nonnull
    public ItemStack getHeldItem(ItemStack holdingStack, Player player) {
        return (ItemStack)ItemSigilHolding.getInternalInventory(holdingStack).get(ItemSigilHolding.getCurrentItemOrdinal(holdingStack));
    }

    public void saveInventory(ItemStack itemStack, NonNullList<ItemStack> inventory) {
        CompoundTag itemTag = itemStack.m_41783_();
        if (itemTag == null) {
            itemTag = new CompoundTag();
            itemStack.m_41751_(itemTag);
        }
        ContainerHelper.m_18973_((CompoundTag)itemTag, inventory);
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected) {
        if (stack.m_41782_()) {
            this.tickInternalInventory(stack, world, entity, itemSlot, isSelected);
        }
    }

    public void tickInternalInventory(ItemStack itemStack, Level world, Entity entity, int itemSlot, boolean isSelected) {
        for (ItemStack stack : ItemSigilHolding.getInternalInventory(itemStack)) {
            Binding binding;
            if (stack.m_41619_() || !(stack.m_41720_() instanceof IBindable) || !(stack.m_41720_() instanceof ISigil) || (binding = ((IBindable)stack.m_41720_()).getBinding(stack)) == null) continue;
            stack.m_41720_().m_6883_(stack, world, entity, itemSlot, isSelected);
        }
    }

    public static int next(int mode) {
        int index = mode + 1;
        if (index >= 5) {
            index = 0;
        }
        return index;
    }

    public static int prev(int mode) {
        int index = mode - 1;
        if (index < 0) {
            index = 5;
        }
        return index;
    }

    private static void initModeTag(ItemStack stack) {
        if (!stack.m_41782_()) {
            stack = NBTHelper.checkNBT(stack);
            stack.m_41783_().m_128405_("currentSigil", 5);
        }
    }

    public static ItemStack getItemStackInSlot(ItemStack itemStack, int slot) {
        if (itemStack.m_41720_() instanceof ItemSigilHolding) {
            NonNullList<ItemStack> inv = ItemSigilHolding.getInternalInventory(itemStack);
            if (inv != null) {
                return (ItemStack)inv.get(slot == 5 ? 4 : slot);
            }
            return ItemStack.f_41583_;
        }
        return ItemStack.f_41583_;
    }

    public static int getCurrentItemOrdinal(ItemStack stack) {
        if (stack.m_41720_() instanceof ItemSigilHolding) {
            ItemSigilHolding.initModeTag(stack);
            int currentSigil = stack.m_41783_().m_128451_("currentSigil");
            currentSigil = Mth.m_14045_((int)currentSigil, (int)0, (int)4);
            return currentSigil;
        }
        return 0;
    }

    public static NonNullList<ItemStack> getInternalInventory(ItemStack stack) {
        ItemSigilHolding.initModeTag(stack);
        CompoundTag tagCompound = stack.m_41783_();
        if (tagCompound == null) {
            return NonNullList.m_122780_((int)5, (Object)ItemStack.f_41583_);
        }
        NonNullList inv = NonNullList.m_122780_((int)5, (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)tagCompound, (NonNullList)inv);
        return inv;
    }

    public static void cycleToNextSigil(ItemStack itemStack, int mode) {
        if (itemStack.m_41720_() instanceof ItemSigilHolding) {
            ItemSigilHolding.initModeTag(itemStack);
            int index = mode;
            if (mode == 120 || mode == -120) {
                int currentIndex = ItemSigilHolding.getCurrentItemOrdinal(itemStack);
                ItemStack currentItemStack = ItemSigilHolding.getItemStackInSlot(itemStack, currentIndex);
                if (currentItemStack.m_41619_()) {
                    return;
                }
                if (mode < 0) {
                    index = ItemSigilHolding.next(currentIndex);
                    currentItemStack = ItemSigilHolding.getItemStackInSlot(itemStack, index);
                    while (currentItemStack.m_41619_()) {
                        index = ItemSigilHolding.next(index);
                        currentItemStack = ItemSigilHolding.getItemStackInSlot(itemStack, index);
                    }
                } else {
                    index = ItemSigilHolding.prev(currentIndex);
                    currentItemStack = ItemSigilHolding.getItemStackInSlot(itemStack, index);
                    while (currentItemStack.m_41619_()) {
                        index = ItemSigilHolding.prev(index);
                        currentItemStack = ItemSigilHolding.getItemStackInSlot(itemStack, index);
                    }
                }
            }
            itemStack.m_41783_().m_128405_("currentSigil", index);
        }
    }

    public AbstractContainerMenu m_7208_(int p_createMenu_1_, Inventory p_createMenu_2_, Player player) {
        assert (player.m_20193_() != null);
        return new ContainerHolding(p_createMenu_1_, player, p_createMenu_2_, new InventoryHolding(player.m_21205_()));
    }

    public Component m_5446_() {
        return new TextComponent("Sigil of Holding");
    }
}

