/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.item.sigil;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import wayoftime.bloodmagic.common.item.sigil.ItemSigilToggleableBase;
import wayoftime.bloodmagic.core.data.SoulTicket;
import wayoftime.bloodmagic.util.helper.NetworkHelper;
import wayoftime.bloodmagic.util.helper.PlayerHelper;

public class ItemSigilGreenGrove
extends ItemSigilToggleableBase {
    public ItemSigilGreenGrove() {
        super("green_grove", 150);
    }

    @Override
    public boolean onSigilUse(ItemStack stack, Player player, Level world, BlockPos blockPos, Direction side, Vec3 vec) {
        if (PlayerHelper.isFakePlayer(player)) {
            return false;
        }
        if (!world.f_46443_ && NetworkHelper.getSoulNetwork(player).syphonAndDamage(player, SoulTicket.item(stack, world, (Entity)player, this.getLpUsed())).isSuccess() && ItemSigilGreenGrove.applyBonemeal(stack, world, blockPos, player)) {
            world.m_46796_(2005, blockPos, 0);
            return true;
        }
        return false;
    }

    @Override
    public void onSigilUpdate(ItemStack stack, Level worldIn, Player player, int itemSlot, boolean isSelected) {
        if (PlayerHelper.isFakePlayer(player)) {
            return;
        }
        int range = 3;
        int verticalRange = 2;
        int posX = (int)Math.round(player.m_20185_() - 0.5);
        int posY = (int)player.m_20186_();
        int posZ = (int)Math.round(player.m_20189_() - 0.5);
        if (worldIn instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)worldIn;
            for (int ix = posX - range; ix <= posX + range; ++ix) {
                for (int iz = posZ - range; iz <= posZ + range; ++iz) {
                    for (int iy = posY - verticalRange; iy <= posY + verticalRange; ++iy) {
                        BlockPos blockPos = new BlockPos(ix, iy, iz);
                        BlockState state = worldIn.m_8055_(blockPos);
                        if (!(state.m_60734_() instanceof BonemealableBlock) || state.m_60734_() == Blocks.f_50440_ || worldIn.f_46441_.nextInt(50) != 0) continue;
                        BlockState preBlockState = worldIn.m_8055_(blockPos);
                        if (!((BonemealableBlock)state.m_60734_()).m_7370_((BlockGetter)serverWorld, blockPos, preBlockState, worldIn.f_46443_)) continue;
                        ((BonemealableBlock)state.m_60734_()).m_7719_(serverWorld, worldIn.f_46441_, blockPos, state);
                        BlockState newState = worldIn.m_8055_(blockPos);
                        if (newState.equals(preBlockState) || worldIn.f_46443_) continue;
                        worldIn.m_46796_(2005, blockPos, 0);
                    }
                }
            }
        }
    }

    private static boolean applyBonemeal(ItemStack stack, Level worldIn, BlockPos pos, Player player) {
        BonemealableBlock igrowable;
        BlockState blockstate = worldIn.m_8055_(pos);
        int hook = ForgeEventFactory.onApplyBonemeal((Player)player, (Level)worldIn, (BlockPos)pos, (BlockState)blockstate, (ItemStack)stack);
        if (hook != 0) {
            return hook > 0;
        }
        if (blockstate.m_60734_() instanceof BonemealableBlock && (igrowable = (BonemealableBlock)blockstate.m_60734_()).m_7370_((BlockGetter)worldIn, pos, blockstate, worldIn.f_46443_)) {
            if (worldIn instanceof ServerLevel && igrowable.m_5491_(worldIn, worldIn.f_46441_, pos, blockstate)) {
                igrowable.m_7719_((ServerLevel)worldIn, worldIn.f_46441_, pos, blockstate);
            }
            return true;
        }
        return false;
    }
}

