/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.item.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import wayoftime.bloodmagic.common.tile.TileMimic;

public class ItemBlockMimic
extends BlockItem {
    public ItemBlockMimic(Block block, Item.Properties prop) {
        super(block, prop);
    }

    public InteractionResult m_40576_(BlockPlaceContext context) {
        Player player = context.m_43723_();
        ItemStack stack = player.m_21120_(context.m_43724_());
        if (!player.m_6144_()) {
            return super.m_40576_(context);
        }
        BlockPos pos = context.m_8083_().m_142300_(context.m_43719_().m_122424_());
        Level world = context.m_43725_();
        Direction direction = context.m_43719_();
        if (player.m_36204_(pos, direction, stack)) {
            BlockState replacedBlockstate = world.m_8055_(pos);
            Block replacedBlock = replacedBlockstate.m_60734_();
            ItemStack replacedStack = replacedBlock.m_7397_((BlockGetter)world, pos, replacedBlockstate);
            BlockState mimicBlockstate = this.m_40614_().m_49966_();
            if (!this.canReplaceBlock(world, pos, replacedBlockstate)) {
                return super.m_40576_(context);
            }
            BlockEntity tileReplaced = world.m_7702_(pos);
            if (!this.canReplaceTile(tileReplaced)) {
                return InteractionResult.FAIL;
            }
            CompoundTag tileTag = this.getTagFromTileEntity(tileReplaced);
            if (tileReplaced != null) {
                CompoundTag voidTag = new CompoundTag();
                voidTag.m_128405_("x", pos.m_123341_());
                voidTag.m_128405_("y", pos.m_123342_());
                voidTag.m_128405_("z", pos.m_123343_());
                tileReplaced.deserializeNBT(voidTag);
            }
            stack.m_41774_(1);
            world.m_7731_(pos, mimicBlockstate, 3);
            SoundType soundtype = mimicBlockstate.getSoundType((LevelReader)world, pos, (Entity)context.m_43723_());
            world.m_5594_(player, pos, soundtype.m_56777_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
            BlockEntity tile = world.m_7702_(pos);
            if (tile instanceof TileMimic) {
                TileMimic mimic = (TileMimic)tile;
                mimic.tileTag = tileTag;
                mimic.setMimic(replacedBlockstate);
                mimic.m_6836_(0, replacedStack);
                mimic.refreshTileEntity();
                if (player.m_7500_()) {
                    mimic.dropItemsOnBreak = false;
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public boolean canReplaceTile(BlockEntity tile) {
        if (tile instanceof ChestBlockEntity) {
            return true;
        }
        return tile == null;
    }

    public boolean canReplaceBlock(Level world, BlockPos pos, BlockState state) {
        return state.m_60800_((BlockGetter)world, pos) != -1.0f;
    }

    public CompoundTag getTagFromTileEntity(BlockEntity tile) {
        CompoundTag tag = new CompoundTag();
        if (tile != null) {
            return tile.m_187482_();
        }
        return tag;
    }
}

