/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.util.BMLog;
import wayoftime.bloodmagic.util.helper.NBTHelper;

public class ItemExperienceBook
extends Item {
    public ItemExperienceBook() {
        super(new Item.Properties().m_41487_(1).m_41491_(BloodMagic.TAB));
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_5812_(ItemStack stack) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)new TranslatableComponent("tooltip.bloodmagic.experienceTome").m_130940_(ChatFormatting.GRAY));
        if (!stack.m_41782_()) {
            return;
        }
        double storedExp = ItemExperienceBook.getStoredExperience(stack);
        tooltip.add((Component)new TranslatableComponent("tooltip.bloodmagic.experienceTome.exp", new Object[]{(int)storedExp}).m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)new TranslatableComponent("tooltip.bloodmagic.experienceTome.expLevel", new Object[]{ItemExperienceBook.getLevelForExperience(storedExp)}).m_130940_(ChatFormatting.GRAY));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!world.f_46443_) {
            if (player.m_6144_()) {
                this.absorbOneLevelExpFromPlayer(stack, player);
            } else {
                this.giveOneLevelExpToPlayer(stack, player);
            }
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public void giveOneLevelExpToPlayer(ItemStack stack, Player player) {
        float progress = player.f_36080_;
        int expToNext = ItemExperienceBook.getExperienceForNextLevel(player.f_36078_);
        int neededExp = (int)Math.ceil((1.0f - progress) * (float)expToNext);
        float containedExp = (float)ItemExperienceBook.getStoredExperience(stack);
        BMLog.DEBUG.info("Needed: " + neededExp + ", contained: " + containedExp + ", exp to next: " + expToNext, new Object[0]);
        if (containedExp >= (float)neededExp) {
            ItemExperienceBook.setStoredExperience(stack, containedExp - (float)neededExp);
            ItemExperienceBook.addPlayerXP(player, neededExp);
            if (player.f_36078_ % 5 == 0) {
                float f = player.f_36078_ > 30 ? 1.0f : (float)player.f_36078_ / 30.0f;
                player.m_20193_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12275_, player.m_5720_(), f * 0.75f, 1.0f);
            }
        } else {
            ItemExperienceBook.setStoredExperience(stack, 0.0);
            ItemExperienceBook.addPlayerXP(player, (int)containedExp);
        }
    }

    public void absorbOneLevelExpFromPlayer(ItemStack stack, Player player) {
        float progress = player.f_36080_;
        if (progress > 0.0f) {
            int expDeduction = (int)ItemExperienceBook.getExperienceAcquiredToNext(player);
            if (expDeduction > 0) {
                ItemExperienceBook.addPlayerXP(player, -expDeduction);
                ItemExperienceBook.addExperience(stack, expDeduction);
            }
        } else if (progress == 0.0f && player.f_36078_ > 0) {
            int expDeduction = ItemExperienceBook.getExperienceForNextLevel(player.f_36078_ - 1);
            ItemExperienceBook.addPlayerXP(player, -expDeduction);
            ItemExperienceBook.addExperience(stack, expDeduction);
        }
    }

    public static int getPlayerXP(Player player) {
        return (int)((float)ItemExperienceBook.getExperienceForLevel(player.f_36078_) + player.f_36080_ * (float)player.m_36323_());
    }

    public static void addPlayerXP(Player player, int amount) {
        int experience;
        player.f_36079_ = experience = Math.max(0, ItemExperienceBook.getPlayerXP(player) + amount);
        player.f_36078_ = ItemExperienceBook.getLevelForExperience(experience);
        int expForLevel = ItemExperienceBook.getExperienceForLevel(player.f_36078_);
        player.f_36080_ = (float)(experience - expForLevel) / (float)player.m_36323_();
    }

    public static void setStoredExperience(ItemStack stack, double exp) {
        NBTHelper.checkNBT(stack);
        CompoundTag tag = stack.m_41783_();
        tag.m_128347_("experience", exp);
    }

    public static double getStoredExperience(ItemStack stack) {
        NBTHelper.checkNBT(stack);
        CompoundTag tag = stack.m_41783_();
        return tag.m_128459_("experience");
    }

    public static void addExperience(ItemStack stack, double exp) {
        ItemExperienceBook.setStoredExperience(stack, ItemExperienceBook.getStoredExperience(stack) + exp);
    }

    public static int getExperienceForNextLevel(int currentLevel) {
        if (currentLevel < 16) {
            return 2 * currentLevel + 7;
        }
        if (currentLevel < 31) {
            return 5 * currentLevel - 38;
        }
        return 9 * currentLevel - 158;
    }

    public static int getExperienceForLevel(int level) {
        if (level >= 21863) {
            return Integer.MAX_VALUE;
        }
        if (level == 0) {
            return 0;
        }
        int res = 0;
        for (int i = 0; i < level; ++i) {
            res += ItemExperienceBook.getExperienceForNextLevel(i);
        }
        return res;
    }

    public static double getExperienceAcquiredToNext(Player player) {
        return player.f_36080_ * (float)player.m_36323_();
    }

    public static int getLevelForExperience(double exp) {
        if (exp <= 352.0) {
            return (int)Math.floor(ItemExperienceBook.solveParabola(1.0, 6.0, -exp));
        }
        if (exp <= 1507.0) {
            return (int)Math.floor(ItemExperienceBook.solveParabola(2.5, -40.5, 360.0 - exp));
        }
        return (int)Math.floor(ItemExperienceBook.solveParabola(4.5, -162.5, 2220.0 - exp));
    }

    public static double solveParabola(double a, double b, double c) {
        return (-b + Math.sqrt(b * b - 4.0 * a * c)) / (2.0 * a);
    }
}

