/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.item;

import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.extensions.IForgeItem;
import wayoftime.bloodmagic.common.item.BloodOrb;
import wayoftime.bloodmagic.common.item.IBloodOrb;
import wayoftime.bloodmagic.common.item.ItemBindableBase;
import wayoftime.bloodmagic.core.data.Binding;
import wayoftime.bloodmagic.core.data.SoulNetwork;
import wayoftime.bloodmagic.core.data.SoulTicket;
import wayoftime.bloodmagic.util.helper.NetworkHelper;
import wayoftime.bloodmagic.util.helper.PlayerHelper;

public class ItemBloodOrb
extends ItemBindableBase
implements IBloodOrb,
IForgeItem {
    private final Supplier<BloodOrb> sup;

    public ItemBloodOrb(Supplier<BloodOrb> sup) {
        this.sup = sup;
    }

    @Override
    public BloodOrb getOrb(ItemStack stack) {
        return this.sup.get();
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        BloodOrb orb = this.getOrb(stack);
        if (orb == null) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        if (world == null) {
            return super.m_7203_(world, player, hand);
        }
        world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11937_, SoundSource.BLOCKS, 0.5f, 2.6f + (world.f_46441_.nextFloat() - world.f_46441_.nextFloat()) * 0.8f);
        if (PlayerHelper.isFakePlayer(player)) {
            return super.m_7203_(world, player, hand);
        }
        if (!stack.m_41782_()) {
            return super.m_7203_(world, player, hand);
        }
        Binding binding = this.getBinding(stack);
        if (binding == null) {
            return super.m_7203_(world, player, hand);
        }
        if (world.f_46443_) {
            return super.m_7203_(world, player, hand);
        }
        SoulNetwork ownerNetwork = NetworkHelper.getSoulNetwork(binding);
        if (binding.getOwnerId().equals(player.m_36316_().getId())) {
            ownerNetwork.setOrbTier(orb.getTier());
        }
        ownerNetwork.add(SoulTicket.item(stack, world, (Entity)player, 200), orb.getCapacity());
        ownerNetwork.hurtPlayer(player, 200.0f);
        return super.m_7203_(world, player, hand);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)new TranslatableComponent("tooltip.bloodmagic.orb.desc").m_130940_(ChatFormatting.GRAY));
        BloodOrb orb = this.getOrb(stack);
        if (flag.m_7050_() && orb != null) {
            tooltip.add((Component)new TranslatableComponent("tooltip.bloodmagic.orb.owner", new Object[]{stack.m_41720_().getRegistryName()}).m_130940_(ChatFormatting.GRAY));
        }
        super.m_7373_(stack, world, tooltip, flag);
    }

    public ItemStack getContainerItem(ItemStack stack) {
        return stack.m_41777_();
    }

    public boolean hasContainerItem(ItemStack stack) {
        return true;
    }
}

