/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.item;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.anointment.AnointmentData;
import wayoftime.bloodmagic.anointment.AnointmentHolder;
import wayoftime.bloodmagic.core.AnointmentRegistrar;

public class ItemAnointmentProvider
extends Item {
    public ResourceLocation anointRL;
    private int colour;
    private int level;
    private int maxDamage;

    public ItemAnointmentProvider(ResourceLocation anointRL, int colour, int level, int maxDamage) {
        super(new Item.Properties().m_41487_(16).m_41491_(BloodMagic.TAB));
        this.anointRL = anointRL;
        this.colour = colour;
        this.level = level;
        this.maxDamage = maxDamage;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        ItemStack weaponStack = player.m_21120_(hand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND);
        if (!world.f_46443_) {
            if (!weaponStack.m_41619_() && this.isItemValidForApplication(weaponStack)) {
                AnointmentHolder holder = AnointmentHolder.fromItemStack(weaponStack);
                if (holder == null) {
                    holder = new AnointmentHolder();
                }
                if (holder.applyAnointment(weaponStack, AnointmentRegistrar.ANOINTMENT_MAP.get(this.anointRL), new AnointmentData(this.level, 0, this.maxDamage))) {
                    SoundEvent soundevent = SoundEvents.f_11769_;
                    world.m_5594_(null, player.m_142538_(), soundevent, SoundSource.BLOCKS, 1.0f, 1.0f);
                    stack.m_41774_(1);
                    holder.toItemStack(weaponStack);
                    return InteractionResultHolder.m_19096_((Object)stack);
                }
            }
        } else if (!weaponStack.m_41619_() && this.isItemValidForApplication(weaponStack)) {
            AnointmentHolder holder = AnointmentHolder.fromItemStack(weaponStack);
            if (holder == null) {
                holder = new AnointmentHolder();
            }
            if (holder.canApplyAnointment(weaponStack, AnointmentRegistrar.ANOINTMENT_MAP.get(this.anointRL), new AnointmentData(this.level, 0, this.maxDamage))) {
                boolean flag1 = false;
                double d0 = (double)(this.colour >> 16 & 0xFF) / 255.0;
                double d1 = (double)(this.colour >> 8 & 0xFF) / 255.0;
                double d2 = (double)(this.colour >> 0 & 0xFF) / 255.0;
                for (int i = 0; i < 16; ++i) {
                    world.m_7106_((ParticleOptions)(flag1 ? ParticleTypes.f_123770_ : ParticleTypes.f_123811_), player.m_20208_(0.3), player.m_20187_(), player.m_20262_(0.3), d0, d1, d2);
                }
                return InteractionResultHolder.m_19096_((Object)stack);
            }
        }
        return super.m_7203_(world, player, hand);
    }

    public boolean isItemValidForApplication(ItemStack stack) {
        return ItemAnointmentProvider.isItemTool(stack) || ItemAnointmentProvider.isItemSword(stack);
    }

    public static boolean isItemTool(ItemStack stack) {
        for (ToolAction action : ItemAnointmentProvider.validToolActions()) {
            if (!stack.canPerformAction(action)) continue;
            return true;
        }
        return false;
    }

    public static boolean isItemSword(ItemStack stack) {
        return stack.m_41720_() instanceof SwordItem;
    }

    public static List<ToolAction> validToolActions() {
        ArrayList<ToolAction> actionList = new ArrayList<ToolAction>();
        actionList.add(ToolActions.AXE_DIG);
        actionList.add(ToolActions.SHOVEL_DIG);
        actionList.add(ToolActions.SWORD_DIG);
        actionList.add(ToolActions.PICKAXE_DIG);
        actionList.add(ToolActions.HOE_DIG);
        return actionList;
    }

    public int getColor() {
        return this.colour;
    }
}

