/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.data;

import java.util.Locale;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.api.compat.EnumDemonWillType;
import wayoftime.bloodmagic.common.block.BloodMagicBlocks;
import wayoftime.bloodmagic.common.item.BloodMagicItems;

public class GeneratorItemModels
extends ItemModelProvider {
    public GeneratorItemModels(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator, "bloodmagic", existingFileHelper);
    }

    protected void registerModels() {
        for (RegistryObject item : BloodMagicItems.BASICITEMS.getEntries()) {
            this.registerBasicItem((Item)item.get());
        }
        for (RegistryObject block : BloodMagicBlocks.BASICBLOCKS.getEntries()) {
            this.registerBlockModel((Block)block.get());
        }
        for (RegistryObject block : BloodMagicBlocks.DUNGEONBLOCKS.getEntries()) {
            this.registerBlockModel((Block)block.get());
        }
        this.registerBlockModel((Block)BloodMagicBlocks.BLANK_RITUAL_STONE.get());
        this.registerBlockModel((Block)BloodMagicBlocks.AIR_RITUAL_STONE.get());
        this.registerBlockModel((Block)BloodMagicBlocks.WATER_RITUAL_STONE.get());
        this.registerBlockModel((Block)BloodMagicBlocks.FIRE_RITUAL_STONE.get());
        this.registerBlockModel((Block)BloodMagicBlocks.EARTH_RITUAL_STONE.get());
        this.registerBlockModel((Block)BloodMagicBlocks.DUSK_RITUAL_STONE.get());
        this.registerBlockModel((Block)BloodMagicBlocks.DAWN_RITUAL_STONE.get());
        this.registerBlockModel((Block)BloodMagicBlocks.ALCHEMICAL_REACTION_CHAMBER.get());
        this.registerBlockModel((Block)BloodMagicBlocks.NETHER_SOIL.get());
        this.registerCustomBlockPath((Block)BloodMagicBlocks.RAW_CRYSTAL_BLOCK.get(), "crystal/defaultcrystal1");
        this.registerCustomBlockPath((Block)BloodMagicBlocks.CORROSIVE_CRYSTAL_BLOCK.get(), "crystal/corrosivecrystal1");
        this.registerCustomBlockPath((Block)BloodMagicBlocks.DESTRUCTIVE_CRYSTAL_BLOCK.get(), "crystal/destructivecrystal1");
        this.registerCustomBlockPath((Block)BloodMagicBlocks.VENGEFUL_CRYSTAL_BLOCK.get(), "crystal/vengefulcrystal1");
        this.registerCustomBlockPath((Block)BloodMagicBlocks.STEADFAST_CRYSTAL_BLOCK.get(), "crystal/steadfastcrystal1");
        this.registerCustomBlockPath((Block)BloodMagicBlocks.SPECTRAL.get(), "spectralblock");
        this.registerCustomBlockPath((Block)BloodMagicBlocks.ROUTING_NODE_BLOCK.get(), "routingnodecombined");
        this.registerCustomBlockPathWithTextures((Block)BloodMagicBlocks.INPUT_ROUTING_NODE_BLOCK.get(), "routingnodecombined", "core", "bloodmagic:models/modelinputroutingnode", "base", "bloodmagic:models/modelinputroutingnode");
        this.registerCustomBlockPathWithTextures((Block)BloodMagicBlocks.OUTPUT_ROUTING_NODE_BLOCK.get(), "routingnodecombined", "core", "bloodmagic:models/modeloutputroutingnode", "base", "bloodmagic:models/modeloutputroutingnode");
        this.registerCustomBlockPath((Block)BloodMagicBlocks.MASTER_ROUTING_NODE_BLOCK.get(), "masterroutingnodecombined");
        this.registerCustomBlockPath((Block)BloodMagicBlocks.DUNGEON_BRICK_ASSORTED.get(), "dungeon_brick1");
        this.registerBlockModel((Block)BloodMagicBlocks.DUNGEON_STONE.get());
        this.registerBlockModel((Block)BloodMagicBlocks.DUNGEON_BRICK_STAIRS.get());
        this.registerBlockModel((Block)BloodMagicBlocks.DUNGEON_POLISHED_STAIRS.get());
        this.registerBlockModel((Block)BloodMagicBlocks.DUNGEON_PILLAR_CENTER.get());
        this.registerBlockModel((Block)BloodMagicBlocks.DUNGEON_PILLAR_SPECIAL.get());
        this.registerBlockModel((Block)BloodMagicBlocks.DUNGEON_PILLAR_CAP.get());
        this.registerCustomBlockPath((Block)BloodMagicBlocks.DUNGEON_BRICK_WALL.get(), "dungeon_brick_wall_inventory");
        this.registerCustomBlockPath((Block)BloodMagicBlocks.DUNGEON_POLISHED_WALL.get(), "dungeon_polished_wall_inventory");
        this.registerBlockModel((Block)BloodMagicBlocks.DUNGEON_BRICK_GATE.get());
        this.registerBlockModel((Block)BloodMagicBlocks.DUNGEON_POLISHED_GATE.get());
        this.registerBlockModel((Block)BloodMagicBlocks.DUNGEON_BRICK_SLAB.get());
        this.registerBlockModel((Block)BloodMagicBlocks.DUNGEON_TILE_SLAB.get());
        this.registerBlockModel((Block)BloodMagicBlocks.DUNGEON_CONTROLLER.get());
        this.registerBlockModel((Block)BloodMagicBlocks.DUNGEON_SEAL.get());
        this.registerCustomBlockPath((Block)BloodMagicBlocks.SPECIAL_DUNGEON_SEAL.get(), "special_dungeon_seal_standard");
        this.registerBlockModel((Block)BloodMagicBlocks.TELEPOSER.get());
        this.registerToggleableItem((Item)BloodMagicItems.GREEN_GROVE_SIGIL.get());
        this.registerToggleableItem((Item)BloodMagicItems.FAST_MINER_SIGIL.get());
        this.registerToggleableItem((Item)BloodMagicItems.MAGNETISM_SIGIL.get());
        this.registerToggleableItem((Item)BloodMagicItems.ICE_SIGIL.get());
        this.registerToggleableItem((Item)BloodMagicItems.SUPPRESSION_SIGIL.get());
        this.registerDemonWillVariantItem((Item)BloodMagicItems.PETTY_GEM.get());
        this.registerDemonWillVariantItem((Item)BloodMagicItems.LESSER_GEM.get());
        this.registerDemonWillVariantItem((Item)BloodMagicItems.COMMON_GEM.get());
        this.registerDemonWillVariantItem((Item)BloodMagicItems.GREATER_GEM.get());
        this.registerDemonSword((Item)BloodMagicItems.SENTIENT_SWORD.get());
        this.registerDemonTool((Item)BloodMagicItems.SENTIENT_AXE.get());
        this.registerDemonTool((Item)BloodMagicItems.SENTIENT_PICKAXE.get());
        this.registerDemonTool((Item)BloodMagicItems.SENTIENT_SHOVEL.get());
        this.registerDemonTool((Item)BloodMagicItems.SENTIENT_SCYTHE.get());
        this.registerSacrificialKnife((Item)BloodMagicItems.SACRIFICIAL_DAGGER.get());
        this.registerCustomFullTexture((Block)BloodMagicBlocks.MIMIC.get(), "solidopaquemimic");
        this.registerCustomFullTexture((Block)BloodMagicBlocks.ETHEREAL_MIMIC.get(), "etherealopaquemimic");
        this.registerBasicItem((Item)BloodMagicItems.GROWING_DOUBT_ITEM.get(), this.modLoc("item/doubt_seed"));
        this.registerBasicItem((Item)BloodMagicItems.WEAK_TAU_ITEM.get(), this.modLoc("item/weak_tau"));
        this.registerBasicItem((Item)BloodMagicItems.STRONG_TAU_ITEM.get(), this.modLoc("item/strong_tau"));
        this.registerBlockModel((Block)BloodMagicBlocks.SHAPED_CHARGE.get());
        this.registerBlockModel((Block)BloodMagicBlocks.DEFORESTER_CHARGE.get());
        this.registerBlockModel((Block)BloodMagicBlocks.VEINMINE_CHARGE.get());
        this.registerBlockModel((Block)BloodMagicBlocks.FUNGAL_CHARGE.get());
        this.registerMultiLayerItem((Item)BloodMagicItems.SLATE_VIAL.get(), this.modLoc("item/alchemic_vial"), this.modLoc("item/alchemic_ribbon"));
        this.registerMultiLayerItem((Item)BloodMagicItems.MELEE_DAMAGE_ANOINTMENT.get(), this.modLoc("item/alchemic_liquid"), this.modLoc("item/alchemic_vial"), this.modLoc("item/alchemic_ribbon"));
        this.registerMultiLayerItem((Item)BloodMagicItems.SILK_TOUCH_ANOINTMENT.get(), this.modLoc("item/alchemic_liquid"), this.modLoc("item/alchemic_vial"), this.modLoc("item/alchemic_ribbon"));
        this.registerMultiLayerItem((Item)BloodMagicItems.FORTUNE_ANOINTMENT.get(), this.modLoc("item/alchemic_liquid"), this.modLoc("item/alchemic_vial"), this.modLoc("item/alchemic_ribbon"));
        this.registerMultiLayerItem((Item)BloodMagicItems.HOLY_WATER_ANOINTMENT.get(), this.modLoc("item/alchemic_liquid"), this.modLoc("item/alchemic_vial"), this.modLoc("item/alchemic_ribbon"));
        this.registerMultiLayerItem((Item)BloodMagicItems.HIDDEN_KNOWLEDGE_ANOINTMENT.get(), this.modLoc("item/alchemic_liquid"), this.modLoc("item/alchemic_vial"), this.modLoc("item/alchemic_ribbon"));
        this.registerMultiLayerItem((Item)BloodMagicItems.QUICK_DRAW_ANOINTMENT.get(), this.modLoc("item/alchemic_liquid"), this.modLoc("item/alchemic_vial"), this.modLoc("item/alchemic_ribbon"));
        this.registerMultiLayerItem((Item)BloodMagicItems.LOOTING_ANOINTMENT.get(), this.modLoc("item/alchemic_liquid"), this.modLoc("item/alchemic_vial"), this.modLoc("item/alchemic_ribbon"));
        this.registerMultiLayerItem((Item)BloodMagicItems.BOW_POWER_ANOINTMENT.get(), this.modLoc("item/alchemic_liquid"), this.modLoc("item/alchemic_vial"), this.modLoc("item/alchemic_ribbon"));
        this.registerMultiLayerItem((Item)BloodMagicItems.WILL_POWER_ANOINTMENT.get(), this.modLoc("item/alchemic_vial_will"), this.modLoc("item/alchemic_liquid"), this.modLoc("item/alchemic_ribbon_will"));
        this.registerMultiLayerItem((Item)BloodMagicItems.SMELTING_ANOINTMENT.get(), this.modLoc("item/alchemic_liquid"), this.modLoc("item/alchemic_vial"), this.modLoc("item/alchemic_ribbon"));
        this.registerMultiLayerItem((Item)BloodMagicItems.BOW_VELOCITY_ANOINTMENT.get(), this.modLoc("item/alchemic_liquid"), this.modLoc("item/alchemic_vial"), this.modLoc("item/alchemic_ribbon"));
        this.registerMultiLayerItem((Item)BloodMagicItems.BOW_POWER_ANOINTMENT_STRONG.get(), this.modLoc("item/alchemic_liquid"), this.modLoc("item/alchemic_vial"), this.modLoc("item/alchemic_ribbon_two"));
        this.registerMultiLayerItem((Item)BloodMagicItems.MELEE_DAMAGE_ANOINTMENT_L.get(), this.modLoc("item/alchemic_liquid"), this.modLoc("item/labeledalchemic_vial"), this.modLoc("item/alchemic_ribbon"));
        this.registerMultiLayerItem((Item)BloodMagicItems.SILK_TOUCH_ANOINTMENT_L.get(), this.modLoc("item/alchemic_liquid"), this.modLoc("item/labeledalchemic_vial"), this.modLoc("item/alchemic_ribbon"));
        this.registerMultiLayerItem((Item)BloodMagicItems.FORTUNE_ANOINTMENT_L.get(), this.modLoc("item/alchemic_liquid"), this.modLoc("item/labeledalchemic_vial"), this.modLoc("item/alchemic_ribbon"));
        this.registerMultiLayerItem((Item)BloodMagicItems.HOLY_WATER_ANOINTMENT_L.get(), this.modLoc("item/alchemic_liquid"), this.modLoc("item/labeledalchemic_vial"), this.modLoc("item/alchemic_ribbon"));
        this.registerMultiLayerItem((Item)BloodMagicItems.HIDDEN_KNOWLEDGE_ANOINTMENT_L.get(), this.modLoc("item/alchemic_liquid"), this.modLoc("item/labeledalchemic_vial"), this.modLoc("item/alchemic_ribbon"));
        this.registerMultiLayerItem((Item)BloodMagicItems.QUICK_DRAW_ANOINTMENT_L.get(), this.modLoc("item/alchemic_liquid"), this.modLoc("item/labeledalchemic_vial"), this.modLoc("item/alchemic_ribbon"));
        this.registerMultiLayerItem((Item)BloodMagicItems.LOOTING_ANOINTMENT_L.get(), this.modLoc("item/alchemic_liquid"), this.modLoc("item/labeledalchemic_vial"), this.modLoc("item/alchemic_ribbon"));
        this.registerMultiLayerItem((Item)BloodMagicItems.BOW_POWER_ANOINTMENT_L.get(), this.modLoc("item/alchemic_liquid"), this.modLoc("item/labeledalchemic_vial"), this.modLoc("item/alchemic_ribbon"));
        this.registerMultiLayerItem((Item)BloodMagicItems.SMELTING_ANOINTMENT_L.get(), this.modLoc("item/alchemic_liquid"), this.modLoc("item/labeledalchemic_vial"), this.modLoc("item/alchemic_ribbon"));
        this.registerMultiLayerItem((Item)BloodMagicItems.BOW_VELOCITY_ANOINTMENT_L.get(), this.modLoc("item/alchemic_liquid"), this.modLoc("item/labeledalchemic_vial"), this.modLoc("item/alchemic_ribbon"));
        this.registerMultiLayerItem((Item)BloodMagicItems.MELEE_DAMAGE_ANOINTMENT_2.get(), this.modLoc("item/alchemic_liquid"), this.modLoc("item/alchemic_vial"), this.modLoc("item/alchemic_ribbon_two"));
        this.registerMultiLayerItem((Item)BloodMagicItems.FORTUNE_ANOINTMENT_2.get(), this.modLoc("item/alchemic_liquid"), this.modLoc("item/alchemic_vial"), this.modLoc("item/alchemic_ribbon_two"));
        this.registerMultiLayerItem((Item)BloodMagicItems.HOLY_WATER_ANOINTMENT_2.get(), this.modLoc("item/alchemic_liquid"), this.modLoc("item/alchemic_vial"), this.modLoc("item/alchemic_ribbon_two"));
        this.registerMultiLayerItem((Item)BloodMagicItems.HIDDEN_KNOWLEDGE_ANOINTMENT_2.get(), this.modLoc("item/alchemic_liquid"), this.modLoc("item/alchemic_vial"), this.modLoc("item/alchemic_ribbon_two"));
        this.registerMultiLayerItem((Item)BloodMagicItems.QUICK_DRAW_ANOINTMENT_2.get(), this.modLoc("item/alchemic_liquid"), this.modLoc("item/alchemic_vial"), this.modLoc("item/alchemic_ribbon_two"));
        this.registerMultiLayerItem((Item)BloodMagicItems.LOOTING_ANOINTMENT_2.get(), this.modLoc("item/alchemic_liquid"), this.modLoc("item/alchemic_vial"), this.modLoc("item/alchemic_ribbon_two"));
        this.registerMultiLayerItem((Item)BloodMagicItems.BOW_POWER_ANOINTMENT_2.get(), this.modLoc("item/alchemic_liquid"), this.modLoc("item/alchemic_vial"), this.modLoc("item/alchemic_ribbon_two"));
        this.registerMultiLayerItem((Item)BloodMagicItems.BOW_VELOCITY_ANOINTMENT_2.get(), this.modLoc("item/alchemic_liquid"), this.modLoc("item/alchemic_vial"), this.modLoc("item/alchemic_ribbon_two"));
        this.registerMultiLayerItem((Item)BloodMagicItems.ALCHEMY_FLASK.get(), this.modLoc("item/potionflask_underlay"), this.modLoc("item/potionflask_outline"), this.modLoc("item/potionflask_overlay"));
        this.registerMultiLayerItem((Item)BloodMagicItems.ALCHEMY_FLASK_THROWABLE.get(), this.modLoc("item/potionflask_underlay"), this.modLoc("item/potionflask_outline_throwable"), this.modLoc("item/potionflask_overlay_throwable"));
        this.registerMultiLayerItem((Item)BloodMagicItems.ALCHEMY_FLASK_LINGERING.get(), this.modLoc("item/potionflask_underlay"), this.modLoc("item/potionflask_outline_lingering"), this.modLoc("item/potionflask_overlay_lingering"));
    }

    private void registerCustomFullTexture(Block block, String texturePath) {
        String path = block.getRegistryName().m_135815_();
        ((ItemModelBuilder)this.getBuilder(path)).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/" + texturePath)));
    }

    private void registerCustomBlockPath(Block block, String newPath) {
        String path = block.getRegistryName().m_135815_();
        ((ItemModelBuilder)this.getBuilder(path)).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/" + newPath)));
    }

    private void registerCustomBlockPathWithTextures(Block block, String newPath, String ... textures) {
        String path = block.getRegistryName().m_135815_();
        ItemModelBuilder builder = (ItemModelBuilder)((ItemModelBuilder)this.getBuilder(path)).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/" + newPath)));
        int length = textures.length / 2;
        for (int i = 1; i < length; ++i) {
            builder.texture(textures[i * 2], textures[i * 2 + 1]);
        }
    }

    private void registerBlockModel(Block block) {
        String path = block.getRegistryName().m_135815_();
        ((ItemModelBuilder)this.getBuilder(path)).parent((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/" + path)));
    }

    private void registerBasicItem(Item item) {
        String path = item.getRegistryName().m_135815_();
        this.singleTexture(path, this.mcLoc("item/generated"), "layer0", this.modLoc("item/" + path));
    }

    private void registerBasicItem(Item item, ResourceLocation separateLocation) {
        String path = item.getRegistryName().m_135815_();
        this.singleTexture(path, this.mcLoc("item/generated"), "layer0", separateLocation);
    }

    private void registerMultiLayerItem(Item item, ResourceLocation ... locations) {
        String path = item.getRegistryName().m_135815_();
        ItemModelBuilder builder = (ItemModelBuilder)((ItemModelBuilder)this.getBuilder(path)).parent((ModelFile)this.getExistingFile(this.mcLoc("item/generated")));
        for (int i = 0; i < locations.length; ++i) {
            builder.texture("layer" + i, locations[i]);
        }
        builder.assertExistence();
    }

    private void registerToggleableItem(Item item) {
        String path = item.getRegistryName().m_135815_();
        ModelBuilder activatedFile = this.singleTexture("item/variants/" + path + "_activated", this.mcLoc("item/handheld"), "layer0", this.modLoc("item/" + path + "_activated"));
        ModelBuilder deactivatedFile = this.singleTexture("item/variants/" + path + "_deactivated", this.mcLoc("item/handheld"), "layer0", this.modLoc("item/" + path + "_deactivated"));
        ((ItemModelBuilder)this.getBuilder(path)).override().predicate(BloodMagic.rl("active"), 0.0f).model((ModelFile)deactivatedFile).end().override().predicate(BloodMagic.rl("active"), 1.0f).model((ModelFile)activatedFile).end();
    }

    private void registerDemonWillVariantItem(Item item) {
        String path = item.getRegistryName().m_135815_();
        ItemModelBuilder builder = (ItemModelBuilder)this.getBuilder(path);
        for (EnumDemonWillType type : EnumDemonWillType.values()) {
            Object name = "";
            if (type.ordinal() != 0) {
                name = "_" + type.name().toLowerCase(Locale.ROOT);
            }
            ModelBuilder willFile = this.singleTexture("item/variants/" + path + (String)name, this.mcLoc("item/handheld"), "layer0", this.modLoc("item/" + path + (String)name));
            builder = builder.override().predicate(BloodMagic.rl("type"), (float)type.ordinal()).model((ModelFile)willFile).end();
        }
    }

    private void registerDemonSword(Item item) {
        String path = item.getRegistryName().m_135815_();
        ItemModelBuilder builder = (ItemModelBuilder)this.getBuilder(path);
        for (int i = 0; i <= 1; ++i) {
            for (EnumDemonWillType type : EnumDemonWillType.values()) {
                Object name;
                Object object = name = i == 0 ? "_deactivated" : "_activated";
                if (type.ordinal() != 0) {
                    name = "_" + type.name().toLowerCase(Locale.ROOT) + (String)name;
                }
                ModelBuilder willFile = this.singleTexture("item/variants/" + path + (String)name, this.mcLoc("item/handheld"), "layer0", this.modLoc("item/" + path + (String)name));
                builder = builder.override().predicate(BloodMagic.rl("type"), (float)type.ordinal()).predicate(BloodMagic.rl("active"), (float)i).model((ModelFile)willFile).end();
            }
        }
    }

    private void registerDemonTool(Item item) {
        String path = item.getRegistryName().m_135815_();
        ItemModelBuilder builder = (ItemModelBuilder)this.getBuilder(path);
        for (EnumDemonWillType type : EnumDemonWillType.values()) {
            Object name = "";
            if (type.ordinal() != 0) {
                name = "_" + type.name().toLowerCase(Locale.ROOT) + (String)name;
            }
            ModelBuilder willFile = this.singleTexture("item/variants/" + path + (String)name, this.mcLoc("item/handheld"), "layer0", this.modLoc("item/" + path + (String)name));
            builder = builder.override().predicate(BloodMagic.rl("type"), (float)type.ordinal()).model((ModelFile)willFile).end();
        }
    }

    private void registerSacrificialKnife(Item item) {
        String path = item.getRegistryName().m_135815_();
        ItemModelBuilder builder = (ItemModelBuilder)this.getBuilder(path);
        ModelBuilder baseKnifeFile = this.singleTexture("item/variants/" + path, this.mcLoc("item/handheld"), "layer0", this.modLoc("item/" + path));
        ModelBuilder ceremonialKnifeFile = this.singleTexture("item/variants/" + path + "_ceremonial", this.mcLoc("item/handheld"), "layer0", this.modLoc("item/" + path + "_ceremonial"));
        builder = builder.override().predicate(BloodMagic.rl("incense"), 0.0f).model((ModelFile)baseKnifeFile).end().override().predicate(BloodMagic.rl("incense"), 1.0f).model((ModelFile)ceremonialKnifeFile).end();
    }

    private void registerRoutingNode(Block block) {
    }
}

