/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import wayoftime.bloodmagic.common.tile.TileExplosiveCharge;
import wayoftime.bloodmagic.common.tile.TileShapedExplosive;

public class BlockShapedExplosive
extends Block
implements EntityBlock {
    private static final VoxelShape UP = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)7.0, (double)14.0);
    private static final VoxelShape DOWN = Block.m_49796_((double)2.0, (double)9.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private static final VoxelShape NORTH = Block.m_49796_((double)2.0, (double)2.0, (double)7.0, (double)14.0, (double)14.0, (double)16.0);
    private static final VoxelShape SOUTH = Block.m_49796_((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)7.0);
    private static final VoxelShape EAST = Block.m_49796_((double)0.0, (double)2.0, (double)2.0, (double)7.0, (double)14.0, (double)14.0);
    private static final VoxelShape WEST = Block.m_49796_((double)9.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0);
    public static final EnumProperty<Direction> ATTACHED = EnumProperty.m_61587_((String)"attached", Direction.class);
    protected final int explosionSize;

    public BlockShapedExplosive(int explosionSize, BlockBehaviour.Properties properties) {
        super(properties);
        this.explosionSize = explosionSize;
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(ATTACHED, (Comparable)Direction.UP));
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TileShapedExplosive(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return (level1, blockPos, blockState, tile) -> {
            if (tile instanceof TileExplosiveCharge) {
                ((TileExplosiveCharge)tile).tick();
            }
        };
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        return facing.m_122424_() == stateIn.m_61143_(ATTACHED) && !stateIn.m_60710_((LevelReader)worldIn, currentPos) ? Blocks.f_50016_.m_49966_() : stateIn;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction[] adirection;
        BlockState blockstate = this.m_49966_();
        Level iworldreader = context.m_43725_();
        BlockPos blockpos = context.m_8083_();
        for (Direction direction : adirection = context.m_6232_()) {
            Direction direction1 = direction.m_122424_();
            if (!(blockstate = (BlockState)blockstate.m_61124_(ATTACHED, (Comparable)direction1)).m_60710_((LevelReader)iworldreader, blockpos)) continue;
            return blockstate;
        }
        return null;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{ATTACHED});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        switch ((Direction)state.m_61143_(ATTACHED)) {
            case DOWN: {
                return DOWN;
            }
            case NORTH: {
                return NORTH;
            }
            case SOUTH: {
                return SOUTH;
            }
            case EAST: {
                return EAST;
            }
            case WEST: {
                return WEST;
            }
        }
        return UP;
    }

    public void m_5707_(Level world, BlockPos blockPos, BlockState blockState, Player player) {
        TileExplosiveCharge tile = (TileExplosiveCharge)world.m_7702_(blockPos);
        if (tile != null && !world.f_46443_) {
            tile.dropSelf();
        }
        super.m_5707_(world, blockPos, blockState, player);
    }
}

