/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.client.screens;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import wayoftime.bloodmagic.client.screens.ScreenBase;
import wayoftime.bloodmagic.common.container.tile.ContainerAlchemyTable;
import wayoftime.bloodmagic.common.tile.TileAlchemyTable;
import wayoftime.bloodmagic.network.AlchemyTableButtonPacket;
import wayoftime.bloodmagic.network.BloodMagicPacketHandler;

public class ScreenAlchemyTable
extends ScreenBase<ContainerAlchemyTable> {
    private static final ResourceLocation background = new ResourceLocation("bloodmagic", "textures/gui/alchemytable.png");
    private static final List<Component> orbError = new ArrayList<Component>();
    private static final List<Component> lpError = new ArrayList<Component>();
    public TileAlchemyTable tileTable;
    private int left;
    private int top;

    public ScreenAlchemyTable(ContainerAlchemyTable container, Inventory playerInventory, Component title) {
        super(container, playerInventory, title);
        this.tileTable = container.tileTable;
        this.f_97726_ = 176;
        this.f_97727_ = 205;
        orbError.clear();
        orbError.add((Component)new TranslatableComponent("tooltip.bloodmagic.alchemytable.orberror.title").m_130940_(ChatFormatting.RED));
        orbError.add((Component)new TranslatableComponent("tooltip.bloodmagic.alchemytable.orberror.text").m_130940_(ChatFormatting.GRAY));
        lpError.clear();
        lpError.add((Component)new TranslatableComponent("tooltip.bloodmagic.alchemytable.lperror.title").m_130940_(ChatFormatting.RED));
        lpError.add((Component)new TranslatableComponent("tooltip.bloodmagic.alchemytable.lperror.text").m_130940_(ChatFormatting.GRAY));
    }

    @Override
    public ResourceLocation getBackground() {
        return background;
    }

    protected void m_7027_(PoseStack stack, int mouseX, int mouseY) {
        this.f_96547_.m_92889_(stack, (Component)new TranslatableComponent("tile.bloodmagic.alchemytable.name"), 8.0f, 5.0f, 0x404040);
        this.f_96547_.m_92889_(stack, (Component)new TranslatableComponent("container.inventory"), 8.0f, 111.0f, 0x404040);
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.left = (this.f_96543_ - this.f_97726_) / 2;
        this.top = (this.f_96544_ - this.f_97727_) / 2;
        this.m_169413_();
        this.m_142416_((GuiEventListener)new Button(this.left + 135, this.top + 52, 14, 14, (Component)new TextComponent("D"), (Button.OnPress)new DirectionalPress(this.tileTable, Direction.DOWN)));
        this.m_142416_((GuiEventListener)new Button(this.left + 153, this.top + 52, 14, 14, (Component)new TextComponent("U"), (Button.OnPress)new DirectionalPress(this.tileTable, Direction.UP)));
        this.m_142416_((GuiEventListener)new Button(this.left + 135, this.top + 70, 14, 14, (Component)new TextComponent("N"), (Button.OnPress)new DirectionalPress(this.tileTable, Direction.NORTH)));
        this.m_142416_((GuiEventListener)new Button(this.left + 153, this.top + 70, 14, 14, (Component)new TextComponent("S"), (Button.OnPress)new DirectionalPress(this.tileTable, Direction.SOUTH)));
        this.m_142416_((GuiEventListener)new Button(this.left + 135, this.top + 88, 14, 14, (Component)new TextComponent("W"), (Button.OnPress)new DirectionalPress(this.tileTable, Direction.WEST)));
        this.m_142416_((GuiEventListener)new Button(this.left + 153, this.top + 88, 14, 14, (Component)new TextComponent("E"), (Button.OnPress)new DirectionalPress(this.tileTable, Direction.EAST)));
    }

    @Override
    protected void m_7286_(PoseStack stack, float partialTicks, int mouseX, int mouseY) {
        int slotId;
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)background);
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        this.m_93228_(stack, i, j, 0, 0, this.f_97726_, this.f_97727_);
        int l = this.getCookProgressScaled(90);
        this.m_93228_(stack, i + 106, j + 14 + 90 - l, 176, 90 - l, 18, l);
        if (this.getOrbFlag()) {
            this.m_93228_(stack, i + 106, j + 24, 194, 55, 18, 18);
            if (mouseX >= i + 106 && mouseX < i + 106 + 18 && mouseY >= j + 24 && mouseY < j + 24 + 18) {
                this.renderTooltip(stack, orbError, Optional.empty(), mouseY, mouseY, this.f_96547_);
            }
        } else if (this.getLPFlag()) {
            this.m_93228_(stack, i + 106, j + 24, 194, 73, 18, 18);
            if (mouseX >= i + 106 && mouseX < i + 106 + 18 && mouseY >= j + 24 && mouseY < j + 24 + 18) {
                this.renderTooltip(stack, lpError, Optional.empty(), mouseX, mouseY, this.f_96547_);
            }
        }
        if ((slotId = this.tileTable.activeSlot) != -1) {
            Slot slot = ((ContainerAlchemyTable)this.m_6262_()).m_38853_(slotId);
            if (slotId == 7) {
                this.m_93228_(stack, i + slot.f_40220_, j + slot.f_40221_, 195, 37, 16, 16);
            } else {
                this.m_93228_(stack, i + slot.f_40220_, j + slot.f_40221_, 195, 19, 16, 16);
            }
            for (int buttonId = 0; buttonId < 6; ++buttonId) {
                int xOffset = buttonId % 2 * 18 + 133;
                int yOffset = buttonId / 2 * 18 + 50;
                if (this.tileTable.isSlotEnabled(slotId, Direction.m_122376_((int)buttonId))) {
                    this.m_93228_(stack, i + xOffset, j + yOffset, 212, 18, 18, 18);
                    continue;
                }
                this.m_93228_(stack, i + xOffset, j + yOffset, 212, 0, 18, 18);
            }
        }
    }

    public int getCookProgressScaled(int scale) {
        double progress = this.tileTable.getProgressForGui();
        return (int)(progress * (double)scale);
    }

    public boolean getOrbFlag() {
        return this.tileTable.getOrbFlagForGui();
    }

    public boolean getLPFlag() {
        return this.tileTable.getLPFlagforGui();
    }

    public class DirectionalPress
    implements Button.OnPress {
        private final TileAlchemyTable table;
        private final Direction direction;

        public DirectionalPress(TileAlchemyTable table, Direction direction) {
            this.table = table;
            this.direction = direction;
        }

        public void m_93750_(Button button) {
            int activeSlot = this.table.activeSlot;
            if (activeSlot != -1) {
                boolean enabled = this.table.isSlotEnabled(activeSlot, this.direction);
                this.table.setSlotEnabled(!enabled, activeSlot, this.direction);
                BloodMagicPacketHandler.INSTANCE.sendToServer((Object)new AlchemyTableButtonPacket(this.table.m_58899_(), activeSlot, this.direction, !enabled));
            }
        }
    }

    public class DirectionalButton
    extends Button {
        private static final int BUTTON_TEX_X = 200;
        private static final int BUTTON_TEX_Y = 60;

        public DirectionalButton(int x, int y, int width, int height, Component title, Button.OnPress pressedAction) {
            super(x, y, width, height, title, pressedAction);
        }

        public void m_6303_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            Minecraft minecraft = Minecraft.m_91087_();
            Font fontrenderer = minecraft.f_91062_;
            minecraft.m_91097_().m_174784_(f_93617_);
            int i = this.m_7202_(this.m_198029_());
            RenderSystem.m_69478_();
            RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            int width = this.f_93618_;
            int height = this.f_93619_;
            int halfWidthLeft = width / 2;
            int halfWidthRight = width % 2 == 0 ? halfWidthLeft : halfWidthLeft + 1;
            int halfHeightTop = height / 2;
            int halfHeightBottom = height % 2 == 0 ? halfHeightTop : halfHeightTop + 1;
            int position = i * 20;
            DirectionalButton.m_93133_((PoseStack)matrixStack, (int)this.f_93620_, (int)this.f_93621_, (float)0.0f, (float)position, (int)halfWidthLeft, (int)halfHeightTop, (int)200, (int)60);
            DirectionalButton.m_93133_((PoseStack)matrixStack, (int)this.f_93620_, (int)(this.f_93621_ + halfHeightTop), (float)0.0f, (float)(position + 20 - halfHeightBottom), (int)halfWidthLeft, (int)halfHeightBottom, (int)200, (int)60);
            DirectionalButton.m_93133_((PoseStack)matrixStack, (int)(this.f_93620_ + halfWidthLeft), (int)this.f_93621_, (float)(200 - halfWidthRight), (float)position, (int)halfWidthRight, (int)halfHeightTop, (int)200, (int)60);
            DirectionalButton.m_93133_((PoseStack)matrixStack, (int)(this.f_93620_ + halfWidthLeft), (int)(this.f_93621_ + halfHeightTop), (float)(200 - halfWidthRight), (float)(position + 20 - halfHeightBottom), (int)halfWidthRight, (int)halfHeightBottom, (int)200, (int)60);
            this.m_7906_(matrixStack, minecraft, mouseX, mouseY);
            RenderSystem.m_69461_();
            if (this.m_198029_()) {
                this.m_7428_(matrixStack, mouseX, mouseY);
            }
        }
    }
}

